/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.events;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.md5lukas.waypoints.WaypointsPlugin;
import de.md5lukas.waypoints.api.Waypoint;
import de.md5lukas.waypoints.api.WaypointMeta;
import de.md5lukas.waypoints.api.WaypointsPlayer;
import de.md5lukas.waypoints.api.event.WaypointPostDeleteEvent;
import de.md5lukas.waypoints.config.general.PointToDeathWaypointOnDeathConfiguration;
import de.md5lukas.waypoints.events.ConfigReloadEvent;
import de.md5lukas.waypoints.libs.skedule.LaunchersKt;
import de.md5lukas.waypoints.pointers.PlayerTrackable;
import de.md5lukas.waypoints.pointers.PointerManager;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.pointers.WaypointTrackable;
import de.md5lukas.waypoints.util.APIHelperKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.time.TimeKt;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0019H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/md5lukas/waypoints/events/PointerEvents;", "Lorg/bukkit/event/Listener;", "plugin", "Lde/md5lukas/waypoints/WaypointsPlugin;", "<init>", "(Lde/md5lukas/waypoints/WaypointsPlugin;)V", "pointerManager", "Lde/md5lukas/waypoints/pointers/PointerManager;", "getPointerManager", "()Lde/md5lukas/waypoints/pointers/PointerManager;", "onPlayerRespawn", "", "e", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "visitedCache", "Lcom/google/common/cache/Cache;", "Lorg/bukkit/entity/Player;", "Lde/md5lukas/waypoints/api/Waypoint;", "onMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onWaypointDelete", "Lde/md5lukas/waypoints/api/event/WaypointPostDeleteEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onConfigReload", "Lde/md5lukas/waypoints/events/ConfigReloadEvent;", "waypoints"})
@SourceDebugExtension(value={"SMAP\nPointerEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointerEvents.kt\nde/md5lukas/waypoints/events/PointerEvents\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1617#2,9:104\n1869#2:113\n1870#2:115\n1626#2:116\n1869#2,2:117\n1#3:114\n*S KotlinDebug\n*F\n+ 1 PointerEvents.kt\nde/md5lukas/waypoints/events/PointerEvents\n*L\n67#1:104,9\n67#1:113\n67#1:115\n67#1:116\n68#1:117,2\n67#1:114\n*E\n"})
public final class PointerEvents
implements Listener {
    @NotNull
    private final WaypointsPlugin plugin;
    @NotNull
    private final Cache<Player, Waypoint> visitedCache;

    public PointerEvents(@NotNull WaypointsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        Cache cache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.visitedCache = cache;
    }

    private final PointerManager getPointerManager() {
        return this.plugin.getPointerManager();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerRespawn(@NotNull PlayerRespawnEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        PointToDeathWaypointOnDeathConfiguration config = this.plugin.getWaypointsConfig().getGeneral().getPointToDeathWaypointOnDeath();
        if (this.plugin.getWaypointsConfig().getGeneral().getFeatures().getDeathWaypoints() && config.getEnabled()) {
            World world = e.getRespawnLocation().getWorld();
            Intrinsics.checkNotNull((Object)world);
            if (APIHelperKt.checkWorldAvailability(this.plugin, world)) {
                Plugin plugin = (Plugin)this.plugin;
                Player player3 = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player3, (String)"getPlayer(...)");
                LaunchersKt.skedule$default(plugin, (Entity)player3, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, e, config, player2, null){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int I$0;
                    int label;
                    final /* synthetic */ PointerEvents this$0;
                    final /* synthetic */ PlayerRespawnEvent $e;
                    final /* synthetic */ PointToDeathWaypointOnDeathConfiguration $config;
                    final /* synthetic */ Player $player;
                    {
                        this.this$0 = $receiver;
                        this.$e = $e;
                        this.$config = $config;
                        this.$player = $player;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var22_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = PointerEvents.access$getPlugin$p(this.this$0).getApi();
                                v1 = this.$e.getPlayer().getUniqueId();
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getUniqueId(...)");
                                this.label = 1;
                                v2 = v0.getWaypointPlayer(v1, (Continuation)this);
                                if (v2 == var22_2) {
                                    return var22_2;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl16:
                                // 2 sources

                                this.label = 2;
                                v3 = ((WaypointsPlayer)v2).getDeathFolder().getWaypoints((Continuation)this);
                                if (v3 == var22_2) {
                                    return var22_2;
                                }
                                ** GOTO lbl24
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl24:
                                // 2 sources

                                $this$maxByOrNull$iv = (Iterable)v3;
                                $i$f$maxByOrNull = false;
                                iterator$iv = $this$maxByOrNull$iv.iterator();
                                if (!iterator$iv.hasNext()) {
                                    v4 = null;
                                } else {
                                    maxElem$iv = iterator$iv.next();
                                    if (!iterator$iv.hasNext()) {
                                        v4 = maxElem$iv;
                                    } else {
                                        it = (Waypoint)maxElem$iv;
                                        $i$a$-maxByOrNull-PointerEvents$onPlayerRespawn$1$1 = false;
                                        maxValue$iv = it.getCreatedAt();
                                        do {
                                            e$iv = iterator$iv.next();
                                            it = (Waypoint)e$iv;
                                            $i$a$-maxByOrNull-PointerEvents$onPlayerRespawn$1$1 = false;
                                            v$iv = it.getCreatedAt();
                                            if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                                            maxElem$iv = e$iv;
                                            maxValue$iv = v$iv;
                                        } while (iterator$iv.hasNext());
                                        v4 = maxElem$iv;
                                    }
                                }
                                var2_18 = v4;
                                if (var2_18 == null) break;
                                var3_3 = var2_18;
                                var4_5 = this.this$0;
                                var5_6 = this.$e;
                                var6_7 = this.$config;
                                var7_8 = this.$player;
                                deathWaypoint = var3_3;
                                $i$a$-let-PointerEvents$onPlayerRespawn$1$2 = 0;
                                trackable = new WaypointTrackable(PointerEvents.access$getPlugin$p(var4_5), deathWaypoint);
                                v5 = PointerEvents.access$getPointerManager(var4_5);
                                v6 = var5_6.getPlayer();
                                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getPlayer(...)");
                                v5.enable(v6, trackable);
                                if (!var6_7.getAutoDeselectAfter().isPositive()) break;
                                this.L$0 = var4_5;
                                this.L$1 = var7_8;
                                this.L$2 = deathWaypoint;
                                this.L$3 = trackable;
                                this.I$0 = $i$a$-let-PointerEvents$onPlayerRespawn$1$2;
                                this.label = 3;
                                v7 = TimeKt.delay((Duration)var6_7.getAutoDeselectAfter(), (Continuation)this);
                                if (v7 == var22_2) {
                                    return var22_2;
                                }
                                ** GOTO lbl81
                            }
                            case 3: {
                                $i$a$-let-PointerEvents$onPlayerRespawn$1$2 = this.I$0;
                                trackable = (WaypointTrackable)this.L$3;
                                deathWaypoint = (Waypoint)this.L$2;
                                var7_8 = (Player)this.L$1;
                                var4_5 = (PointerEvents)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v7 = $result;
lbl81:
                                // 2 sources

                                if (var7_8.isOnline()) {
                                    PointerEvents.access$getPointerManager(var4_5).disable(var7_8, trackable.asPredicate());
                                    break;
                                }
                                v8 = PointerEvents.access$getPlugin$p(var4_5).getApi();
                                v9 = var7_8.getUniqueId();
                                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getUniqueId(...)");
                                this.L$0 = deathWaypoint;
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)trackable);
                                this.L$2 = null;
                                this.L$3 = null;
                                this.I$0 = $i$a$-let-PointerEvents$onPlayerRespawn$1$2;
                                this.label = 4;
                                v10 = v8.getWaypointPlayer(v9, (Continuation)this);
                                if (v10 == var22_2) {
                                    return var22_2;
                                }
                                ** GOTO lbl103
                            }
                            case 4: {
                                $i$a$-let-PointerEvents$onPlayerRespawn$1$2 = this.I$0;
                                trackable = (WaypointTrackable)this.L$1;
                                deathWaypoint = (Waypoint)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v10 = $result;
lbl103:
                                // 2 sources

                                var13_21 = apiPlayer = (WaypointsPlayer)v10;
                                this.L$0 = deathWaypoint;
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)trackable);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)apiPlayer);
                                this.L$3 = var13_21;
                                this.I$0 = $i$a$-let-PointerEvents$onPlayerRespawn$1$2;
                                this.label = 5;
                                v11 = apiPlayer.getSelectedWaypoints((Continuation)this);
                                if (v11 == var22_2) {
                                    return var22_2;
                                }
                                ** GOTO lbl122
                            }
                            case 5: {
                                $i$a$-let-PointerEvents$onPlayerRespawn$1$2 = this.I$0;
                                var13_21 = (WaypointsPlayer)this.L$3;
                                apiPlayer = (WaypointsPlayer)this.L$2;
                                trackable = (WaypointTrackable)this.L$1;
                                deathWaypoint = (Waypoint)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v11 = $result;
lbl122:
                                // 2 sources

                                var12_22 = (Iterable)v11;
                                $i$f$filterNot = false;
                                var15_24 = $this$filterNot$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterNotTo = false;
                                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                                    it = (Waypoint)element$iv$iv;
                                    $i$a$-filterNot-PointerEvents$onPlayerRespawn$1$2$1 = false;
                                    if (Intrinsics.areEqual((Object)deathWaypoint.getId(), (Object)it.getId())) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)deathWaypoint);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)trackable);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)apiPlayer);
                                this.L$3 = null;
                                this.I$0 = $i$a$-let-PointerEvents$onPlayerRespawn$1$2;
                                this.label = 6;
                                v12 = var13_21.setSelectedWaypoints((List)destination$iv$iv, (Continuation)this);
                                if (v12 == var22_2) {
                                    return var22_2;
                                }
                                break;
                            }
                            case 6: {
                                $i$a$-let-PointerEvents$onPlayerRespawn$1$2 = this.I$0;
                                apiPlayer = (WaypointsPlayer)this.L$2;
                                trackable = (WaypointTrackable)this.L$1;
                                deathWaypoint = (Waypoint)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v12 = $result;
                                break;
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 2, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onMove(@NotNull PlayerMoveEvent e) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int visitedRadius = this.plugin.getWaypointsConfig().getGeneral().getTeleport().getVisitedRadiusSquared();
        PointerManager pointerManager = this.plugin.getPointerManager();
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Iterable iterable = pointerManager.getCurrentTargets(player);
        Function1 transform$iv = WaypointTrackable.Extract.INSTANCE;
        boolean $i$f$mapNotNull = false;
        void var6_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            if (transform$iv.invoke(element$iv$iv) == null) continue;
            boolean bl2 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Waypoint it = (Waypoint)element$iv;
            boolean bl = false;
            if (e.getPlayer().getWorld() != it.getLocation().getWorld() || !(e.getPlayer().getLocation().distanceSquared(it.getLocation()) <= (double)visitedRadius) || Intrinsics.areEqual((Object)this.visitedCache.getIfPresent((Object)e.getPlayer()), (Object)it)) continue;
            this.visitedCache.put((Object)e.getPlayer(), (Object)it);
            Plugin plugin = (Plugin)this.plugin;
            Player player2 = e.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getPlayer(...)");
            LaunchersKt.skedule$default(plugin, (Entity)player2, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, e, null){
                int label;
                final /* synthetic */ Waypoint $it;
                final /* synthetic */ PlayerMoveEvent $e;
                {
                    this.$it = $it;
                    this.$e = $e;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = this.$e.getPlayer().getUniqueId();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getUniqueId(...)");
                            this.label = 1;
                            v1 = this.$it.getWaypointMeta(v0, (Continuation)this);
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl15:
                            // 2 sources

                            this.label = 2;
                            v2 = ((WaypointMeta)v1).setVisited(true, (Continuation)this);
                            if (v2 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl23
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl23:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 2, null);
        }
    }

    @EventHandler
    public final void onWaypointDelete(@NotNull WaypointPostDeleteEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        this.getPointerManager().disableAll((Function1<? super Trackable, Boolean>)((Function1)arg_0 -> PointerEvents.onWaypointDelete$lambda$1(e, arg_0)));
    }

    @EventHandler
    public final void onPlayerQuit(@NotNull PlayerQuitEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.getPointerManager().disableAll((Function1<? super Trackable, Boolean>)((Function1)arg_0 -> PointerEvents.onPlayerQuit$lambda$2(e, arg_0)));
    }

    @EventHandler
    public final void onConfigReload(@NotNull ConfigReloadEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        this.getPointerManager().applyNewConfiguration(e.getConfig().getPointers());
    }

    private static final boolean onWaypointDelete$lambda$1(WaypointPostDeleteEvent $e, Trackable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof Waypoint ? Intrinsics.areEqual((Object)((Waypoint)((Object)it)).getId(), (Object)$e.getWaypoint().getId()) : false;
    }

    private static final boolean onPlayerQuit$lambda$2(PlayerQuitEvent $e, Trackable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PlayerTrackable ? Intrinsics.areEqual((Object)((PlayerTrackable)it).getPlayer(), (Object)$e.getPlayer()) : false;
    }

    public static final /* synthetic */ WaypointsPlugin access$getPlugin$p(PointerEvents $this) {
        return $this.plugin;
    }

    public static final /* synthetic */ PointerManager access$getPointerManager(PointerEvents $this) {
        return $this.getPointerManager();
    }
}

