/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.integrations;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import de.md5lukas.waypoints.WaypointsPlugin;
import de.md5lukas.waypoints.api.Type;
import de.md5lukas.waypoints.api.Waypoint;
import de.md5lukas.waypoints.api.event.WaypointCreateEvent;
import de.md5lukas.waypoints.api.event.WaypointPostDeleteEvent;
import de.md5lukas.waypoints.libs.commons.paper.PluginKt;
import de.md5lukas.waypoints.libs.skedule.LaunchersKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/md5lukas/waypoints/integrations/BlueMapIntegration;", "Lorg/bukkit/event/Listener;", "plugin", "Lde/md5lukas/waypoints/WaypointsPlugin;", "<init>", "(Lde/md5lukas/waypoints/WaypointsPlugin;)V", "api", "Lde/bluecolored/bluemap/api/BlueMapAPI;", "markerSets", "Ljava/util/HashMap;", "Lorg/bukkit/World;", "Lde/bluecolored/bluemap/api/markers/MarkerSet;", "Lkotlin/collections/HashMap;", "setupBlueMap", "", "onCreate", "", "e", "Lde/md5lukas/waypoints/api/event/WaypointCreateEvent;", "onDelete", "Lde/md5lukas/waypoints/api/event/WaypointPostDeleteEvent;", "createMarker", "waypoint", "Lde/md5lukas/waypoints/api/Waypoint;", "getMarkerSet", "world", "waypoints"})
@SourceDebugExtension(value={"SMAP\nBlueMapIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlueMapIntegration.kt\nde/md5lukas/waypoints/integrations/BlueMapIntegration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1869#2,2:72\n*S KotlinDebug\n*F\n+ 1 BlueMapIntegration.kt\nde/md5lukas/waypoints/integrations/BlueMapIntegration\n*L\n66#1:72,2\n*E\n"})
public final class BlueMapIntegration
implements Listener {
    @NotNull
    private final WaypointsPlugin plugin;
    private BlueMapAPI api;
    @NotNull
    private final HashMap<World, MarkerSet> markerSets;

    public BlueMapIntegration(@NotNull WaypointsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        this.markerSets = new HashMap();
    }

    public final boolean setupBlueMap() {
        if (this.plugin.getServer().getPluginManager().getPlugin("BlueMap") == null) {
            return false;
        }
        BlueMapAPI.onEnable(arg_0 -> BlueMapIntegration.setupBlueMap$lambda$0(this, arg_0));
        return true;
    }

    @EventHandler
    public final void onCreate(@NotNull WaypointCreateEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        if (e.getWaypoint().getType() == Type.PUBLIC) {
            this.createMarker(e.getWaypoint());
        }
    }

    @EventHandler
    public final void onDelete(@NotNull WaypointPostDeleteEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        if (e.getWaypoint().getType() == Type.PUBLIC) {
            World world = e.getWaypoint().getLocation().getWorld();
            Intrinsics.checkNotNull((Object)world);
            this.getMarkerSet(world).remove(e.getWaypoint().getId().toString());
        }
    }

    private final void createMarker(Waypoint waypoint) {
        World world = waypoint.getLocation().getWorld();
        Intrinsics.checkNotNull((Object)world);
        Map map = this.getMarkerSet(world).getMarkers();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getMarkers(...)");
        Map map2 = map;
        String string = waypoint.getId().toString();
        POIMarker pOIMarker = new POIMarker(waypoint.getName(), new Vector3d(waypoint.getLocation().getX(), waypoint.getLocation().getY(), waypoint.getLocation().getZ()));
        map2.put(string, pOIMarker);
    }

    private final MarkerSet getMarkerSet(World world) {
        MarkerSet markerSet = this.markerSets.computeIfAbsent(world, arg_0 -> BlueMapIntegration.getMarkerSet$lambda$5(arg_0 -> BlueMapIntegration.getMarkerSet$lambda$4(this, world, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)markerSet, (String)"computeIfAbsent(...)");
        return markerSet;
    }

    private static final void setupBlueMap$lambda$0(BlueMapIntegration this$0, BlueMapAPI it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.api = it;
        LaunchersKt.skedule$default((Plugin)this$0.plugin, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ BlueMapIntegration this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = BlueMapIntegration.access$getPlugin$p(this.this$0).getApi().getPublicWaypoints().getAllWaypoints((Continuation)this);
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = (Iterable)v0;
                        var3_4 = this.this$0;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            waypoint = (Waypoint)element$iv;
                            $i$a$-forEach-BlueMapIntegration$setupBlueMap$1$1$1 = false;
                            BlueMapIntegration.access$createMarker(var3_4, waypoint);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
        PluginKt.registerEvents((Plugin)this$0.plugin, this$0);
        this$0.plugin.getSLF4JLogger().info("Delayed initialization of BlueMap integration completed");
    }

    private static final Unit getMarkerSet$lambda$4$lambda$2(MarkerSet $markerSet, BlueMapWorld blueMapWorld) {
        Intrinsics.checkNotNullParameter((Object)blueMapWorld, (String)"blueMapWorld");
        Collection collection = blueMapWorld.getMaps();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getMaps(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map map;
            BlueMapMap it = (BlueMapMap)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getMarkerSets(), (String)"getMarkerSets(...)");
            map.put("waypoints_public", $markerSet);
        }
        return Unit.INSTANCE;
    }

    private static final void getMarkerSet$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final MarkerSet getMarkerSet$lambda$4(BlueMapIntegration this$0, World $world, World it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MarkerSet markerSet = new MarkerSet(this$0.plugin.getTranslations().getINTEGRATIONS_MAPS_LABEL().getRawText());
        BlueMapAPI blueMapAPI = this$0.api;
        if (blueMapAPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"api");
            blueMapAPI = null;
        }
        blueMapAPI.getWorld((Object)$world).ifPresent(arg_0 -> BlueMapIntegration.getMarkerSet$lambda$4$lambda$3(arg_0 -> BlueMapIntegration.getMarkerSet$lambda$4$lambda$2(markerSet, arg_0), arg_0));
        return markerSet;
    }

    private static final MarkerSet getMarkerSet$lambda$5(Function1 $tmp0, Object p0) {
        return (MarkerSet)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ WaypointsPlugin access$getPlugin$p(BlueMapIntegration $this) {
        return $this.plugin;
    }

    public static final /* synthetic */ void access$createMarker(BlueMapIntegration $this, Waypoint waypoint) {
        $this.createMarker(waypoint);
    }
}

