/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.integrations;

import de.md5lukas.waypoints.WaypointsPlugin;
import de.md5lukas.waypoints.config.integrations.GeyserConfiguration;
import de.md5lukas.waypoints.lang.Translation;
import de.md5lukas.waypoints.lang.Translations;
import de.md5lukas.waypoints.libs.commons.paper.KyoriKt;
import de.md5lukas.waypoints.util.KyoriHelperKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.geyser.api.GeyserApi;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lde/md5lukas/waypoints/integrations/GeyserIntegration;", "", "plugin", "Lde/md5lukas/waypoints/WaypointsPlugin;", "<init>", "(Lde/md5lukas/waypoints/WaypointsPlugin;)V", "translations", "Lde/md5lukas/waypoints/lang/Translations;", "getTranslations", "()Lde/md5lukas/waypoints/lang/Translations;", "config", "Lde/md5lukas/waypoints/config/integrations/GeyserConfiguration;", "getConfig", "()Lde/md5lukas/waypoints/config/integrations/GeyserConfiguration;", "setupGeyser", "", "isBedrockPlayer", "player", "Lorg/bukkit/entity/Player;", "sendTrackingRequest", "", "from", "validForResolver", "Lnet/kyori/adventure/text/minimessage/tag/resolver/TagResolver;", "onAccept", "Lkotlin/Function0;", "waypoints"})
public final class GeyserIntegration {
    @NotNull
    private final WaypointsPlugin plugin;

    public GeyserIntegration(@NotNull WaypointsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
    }

    private final Translations getTranslations() {
        return this.plugin.getTranslations();
    }

    private final GeyserConfiguration getConfig() {
        return this.plugin.getWaypointsConfig().getIntegrations().getGeyser();
    }

    public final boolean setupGeyser() {
        return this.plugin.getServer().getPluginManager().getPlugin("Geyser-Spigot") != null;
    }

    public final boolean isBedrockPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return GeyserApi.api().isBedrockPlayer(player.getUniqueId());
    }

    public final void sendTrackingRequest(@NotNull Player player, @NotNull Player from, @NotNull TagResolver validForResolver, @NotNull Function0<Unit> onAccept) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)validForResolver, (String)"validForResolver");
        Intrinsics.checkNotNullParameter(onAccept, (String)"onAccept");
        GeyserApi geyserApi = GeyserApi.api();
        UUID uUID = player.getUniqueId();
        SimpleForm.Builder builder2 = (SimpleForm.Builder)SimpleForm.builder().title(KyoriHelperKt.asPlainText(this.getTranslations().getMESSAGE_TRACKING_REQUEST_GEYSER_TITLE().getText()));
        Translation translation = this.getTranslations().getMESSAGE_TRACKING_REQUEST_GEYSER_MESSAGE();
        TagResolver[] tagResolverArray = new TagResolver[2];
        Component component = from.displayName();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"displayName(...)");
        tagResolverArray[0] = KyoriKt.placeholder("from", component);
        tagResolverArray[1] = validForResolver;
        geyserApi.sendForm(uUID, builder2.content(KyoriHelperKt.asPlainText(translation.withReplacements(tagResolverArray))).button(KyoriHelperKt.asPlainText(this.getTranslations().getMESSAGE_TRACKING_REQUEST_GEYSER_ACCEPT().getText()), FormImage.Type.PATH, this.getConfig().getAcceptIcon()).button(KyoriHelperKt.asPlainText(this.getTranslations().getMESSAGE_TRACKING_REQUEST_GEYSER_DECLINE().getText()), FormImage.Type.PATH, this.getConfig().getDeclineIcon()).validResultHandler(arg_0 -> GeyserIntegration.sendTrackingRequest$lambda$0(onAccept, arg_0)));
    }

    private static final void sendTrackingRequest$lambda$0(Function0 $onAccept, SimpleFormResponse response) {
        if (response.clickedButtonId() == 0) {
            $onAccept.invoke();
        }
    }
}

