/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.integrations;

import de.md5lukas.waypoints.WaypointsPlugin;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/md5lukas/waypoints/integrations/VaultIntegration;", "", "plugin", "Lde/md5lukas/waypoints/WaypointsPlugin;", "<init>", "(Lde/md5lukas/waypoints/WaypointsPlugin;)V", "economy", "Lnet/milkbowl/vault/economy/Economy;", "setupEconomy", "", "withdraw", "player", "Lorg/bukkit/entity/Player;", "amount", "", "deposit", "getBalance", "waypoints"})
public final class VaultIntegration {
    @NotNull
    private final WaypointsPlugin plugin;
    @Nullable
    private Economy economy;

    public VaultIntegration(@NotNull WaypointsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
    }

    public final boolean setupEconomy() {
        if (!this.plugin.getPluginMeta().getPluginSoftDependencies().contains("Vault") || this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider registeredServiceProvider = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider == null) {
            return false;
        }
        RegisteredServiceProvider rsp = registeredServiceProvider;
        this.economy = (Economy)rsp.getProvider();
        return true;
    }

    public final boolean withdraw(@NotNull Player player, double amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Economy economy = this.economy;
        if (economy == null) {
            throw new IllegalStateException("There was an attempt to withdraw money via Vault without Vault being setup");
        }
        return economy.withdrawPlayer((OfflinePlayer)player, amount).transactionSuccess();
    }

    public final boolean deposit(@NotNull Player player, double amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Economy economy = this.economy;
        if (economy == null) {
            throw new IllegalStateException("There was an attempt to withdraw money via Vault without Vault being setup");
        }
        return economy.depositPlayer((OfflinePlayer)player, amount).transactionSuccess();
    }

    public final double getBalance(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Economy economy = this.economy;
        if (economy == null) {
            throw new IllegalStateException("There was an attempt to check the balance via Vault without Vault being setup");
        }
        return economy.getBalance((OfflinePlayer)player);
    }
}

