/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.lang;

import de.md5lukas.waypoints.events.ConfigReloadEvent;
import de.md5lukas.waypoints.lang.YmlTranslationLoader;
import de.md5lukas.waypoints.libs.commons.paper.PluginKt;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/md5lukas/waypoints/lang/WorldTranslations;", "Lorg/bukkit/event/Listener;", "tl", "Lde/md5lukas/waypoints/lang/YmlTranslationLoader;", "<init>", "(Lde/md5lukas/waypoints/lang/YmlTranslationLoader;)V", "warned", "", "Lorg/bukkit/World;", "getWorldName", "Lnet/kyori/adventure/text/Component;", "world", "onReload", "", "e", "Lde/md5lukas/waypoints/events/ConfigReloadEvent;", "waypoints"})
public final class WorldTranslations
implements Listener {
    @NotNull
    private final YmlTranslationLoader tl;
    @NotNull
    private final Set<World> warned;

    public WorldTranslations(@NotNull YmlTranslationLoader tl) {
        Intrinsics.checkNotNullParameter((Object)tl, (String)"tl");
        this.tl = tl;
        PluginKt.registerEvents((Plugin)this.tl.getPlugin(), this);
        Set set2 = Collections.synchronizedSet(new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue(set2, (String)"synchronizedSet(...)");
        this.warned = set2;
    }

    @NotNull
    public final Component getWorldName(@NotNull World world) {
        Component component;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (this.warned.contains(world)) {
            TextComponent textComponent = Component.text((String)world.getName());
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
            return (Component)textComponent;
        }
        String key = "worlds." + world.getName();
        if (this.tl.contains(key, false)) {
            TextComponent textComponent = Component.text((String)this.tl.get(key));
            Intrinsics.checkNotNull((Object)textComponent);
            component = (Component)textComponent;
        } else {
            this.warned.add(world);
            this.tl.getPlugin().getSLF4JLogger().warn("The world '{}' has no translation present. Using actual name as a fallback.", (Object)world.getName());
            TextComponent textComponent = Component.text((String)world.getName());
            Intrinsics.checkNotNull((Object)textComponent);
            component = (Component)textComponent;
        }
        return component;
    }

    @EventHandler
    public final void onReload(@NotNull ConfigReloadEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        this.warned.clear();
    }
}

