/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.lang;

import de.md5lukas.waypoints.WaypointsPlugin;
import de.md5lukas.waypoints.events.ConfigReloadEvent;
import de.md5lukas.waypoints.lang.AbstractTranslation;
import de.md5lukas.waypoints.lang.TranslationLoader;
import de.md5lukas.waypoints.libs.commons.paper.PluginKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00122\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u000fJ\u0011\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000fH\u0096\u0002J\u0016\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020'J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+H\u0007J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lde/md5lukas/waypoints/lang/YmlTranslationLoader;", "Lde/md5lukas/waypoints/lang/TranslationLoader;", "Lorg/bukkit/event/Listener;", "plugin", "Lde/md5lukas/waypoints/WaypointsPlugin;", "<init>", "(Lde/md5lukas/waypoints/WaypointsPlugin;)V", "getPlugin", "()Lde/md5lukas/waypoints/WaypointsPlugin;", "itemMiniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "getItemMiniMessage", "()Lnet/kyori/adventure/text/minimessage/MiniMessage;", "defaultLanguage", "", "loadedLanguage", "translations", "", "translationWrappers", "", "Lde/md5lukas/waypoints/lang/AbstractTranslation;", "bundledLanguages", "", "getLanguageFilePath", "languageKey", "getLanguageFile", "Ljava/io/File;", "extractLanguages", "", "processConfiguration", "languageConfig", "Lorg/bukkit/configuration/file/FileConfiguration;", "loadLanguage", "get", "key", "warned", "", "contains", "", "printWarning", "onConfigReload", "e", "Lde/md5lukas/waypoints/events/ConfigReloadEvent;", "registerTranslationWrapper", "translation", "waypoints"})
@SourceDebugExtension(value={"SMAP\nYmlTranslationLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YmlTranslationLoader.kt\nde/md5lukas/waypoints/lang/YmlTranslationLoader\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,151:1\n57#2:152\n1#3:153\n1869#4,2:154\n1869#4:156\n1870#4:163\n1869#4,2:164\n140#5:157\n129#5,5:158\n*S KotlinDebug\n*F\n+ 1 YmlTranslationLoader.kt\nde/md5lukas/waypoints/lang/YmlTranslationLoader\n*L\n48#1:152\n48#1:153\n60#1:154,2\n72#1:156\n72#1:163\n144#1:164,2\n74#1:157\n74#1:158,5\n*E\n"})
public final class YmlTranslationLoader
implements TranslationLoader,
Listener {
    @NotNull
    private final WaypointsPlugin plugin;
    @NotNull
    private final MiniMessage itemMiniMessage;
    @NotNull
    private final String defaultLanguage;
    private String loadedLanguage;
    private Map<String, String> translations;
    @NotNull
    private final List<AbstractTranslation> translationWrappers;
    @NotNull
    private final List<String> bundledLanguages;
    @NotNull
    private final Set<String> warned;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public YmlTranslationLoader(@NotNull WaypointsPlugin plugin) {
        void $this$useLines$iv;
        void $this$itemMiniMessage_u24lambda_u242_u24lambda_u240;
        void $this$itemMiniMessage_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        Object object = MiniMessage.builder();
        YmlTranslationLoader ymlTranslationLoader = this;
        boolean bl = false;
        Object object2 = TagResolver.builder();
        void var7_7 = $this$itemMiniMessage_u24lambda_u242;
        boolean bl2 = false;
        $this$itemMiniMessage_u24lambda_u242_u24lambda_u240.resolver(StandardTags.defaults());
        var7_7.tags($this$itemMiniMessage_u24lambda_u242_u24lambda_u240.build());
        $this$itemMiniMessage_u24lambda_u242.postProcessor(YmlTranslationLoader::itemMiniMessage$lambda$2$lambda$1);
        MiniMessage miniMessage = $this$itemMiniMessage_u24lambda_u242.build();
        Intrinsics.checkNotNullExpressionValue((Object)miniMessage, (String)"run(...)");
        ymlTranslationLoader.itemMiniMessage = miniMessage;
        this.defaultLanguage = "en";
        PluginKt.registerEvents((Plugin)this.getPlugin(), this);
        this.translationWrappers = new ArrayList();
        InputStream inputStream = this.getPlugin().getResource("resourceIndex");
        Intrinsics.checkNotNull((Object)inputStream);
        Closeable closeable = inputStream;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        object = new InputStreamReader((InputStream)closeable, charset2);
        int n = 8192;
        closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        ymlTranslationLoader = this;
        boolean $i$f$useLines = false;
        object = $this$useLines$iv;
        n = 8192;
        object = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)object;
            boolean bl3 = false;
            Sequence seq = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl4 = false;
            object2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)seq, YmlTranslationLoader::bundledLanguages$lambda$5$lambda$3), YmlTranslationLoader::bundledLanguages$lambda$5$lambda$4));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        ymlTranslationLoader.bundledLanguages = object2;
        Set set2 = Collections.synchronizedSet(new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue(set2, (String)"synchronizedSet(...)");
        this.warned = set2;
    }

    @Override
    @NotNull
    public WaypointsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public MiniMessage getItemMiniMessage() {
        return this.itemMiniMessage;
    }

    private final String getLanguageFilePath(String languageKey) {
        return "lang/" + languageKey + ".yml";
    }

    private final File getLanguageFile(String languageKey) {
        return new File(this.getPlugin().getDataFolder(), this.getLanguageFilePath(languageKey));
    }

    private final void extractLanguages() {
        Iterable $this$forEach$iv = this.bundledLanguages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String languageKey = (String)element$iv;
            boolean bl = false;
            if (this.getLanguageFile(languageKey).exists()) continue;
            this.getPlugin().saveResource(this.getLanguageFilePath(languageKey), false);
        }
    }

    private final Map<String, String> processConfiguration(FileConfiguration languageConfig) {
        HashMap map = new HashMap();
        Function1 isNewLine = YmlTranslationLoader::processConfiguration$lambda$7;
        Set set2 = languageConfig.getKeys(true);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getKeys(...)");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CharSequence charSequence;
            Map map2;
            String it;
            block3: {
                String $this$trimEnd$iv;
                it = (String)element$iv;
                boolean bl = false;
                if (!languageConfig.isString(it)) continue;
                map2 = map;
                Intrinsics.checkNotNull((Object)languageConfig.getString(it));
                boolean $i$f$trimEnd = false;
                CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
                boolean $i$f$trimEnd2 = false;
                int n = $this$trimEnd$iv$iv.length() + -1;
                if (0 <= n) {
                    do {
                        int index$iv$iv;
                        if (((Boolean)isNewLine.invoke((Object)Character.valueOf($this$trimEnd$iv$iv.charAt(index$iv$iv = n--)))).booleanValue()) continue;
                        charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                        break block3;
                    } while (0 <= n);
                }
                charSequence = "";
            }
            String string = ((Object)charSequence).toString();
            map2.put(it, string);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadLanguage(@NotNull String languageKey) {
        FileConfiguration fileConfiguration;
        YamlConfiguration loadedTranslations;
        Intrinsics.checkNotNullParameter((Object)languageKey, (String)"languageKey");
        this.loadedLanguage = languageKey;
        this.extractLanguages();
        File languageFile = this.getLanguageFile(languageKey);
        if (languageFile.exists()) {
            FileConfiguration fileConfiguration2;
            Object object;
            Object object2;
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)languageFile);
            Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration, (String)"loadConfiguration(...)");
            loadedTranslations = yamlConfiguration;
            if (this.bundledLanguages.contains(languageKey)) {
                InputStream inputStream = this.getPlugin().getResource(this.getLanguageFilePath(languageKey));
                Intrinsics.checkNotNull((Object)inputStream);
                Closeable closeable = inputStream;
                object2 = Charsets.UTF_8;
                closeable = new InputStreamReader((InputStream)closeable, (Charset)object2);
                object2 = null;
                try {
                    InputStreamReader it = (InputStreamReader)closeable;
                    boolean bl = false;
                    object = YamlConfiguration.loadConfiguration((Reader)it);
                }
                catch (Throwable bl) {
                    object2 = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                }
                fileConfiguration2 = (FileConfiguration)object;
            } else {
                fileConfiguration2 = null;
            }
            FileConfiguration sameLanguageFallback = fileConfiguration2;
            InputStream inputStream = this.getPlugin().getResource(this.getLanguageFilePath(this.defaultLanguage));
            Intrinsics.checkNotNull((Object)inputStream);
            object2 = inputStream;
            object = Charsets.UTF_8;
            object2 = new InputStreamReader((InputStream)object2, (Charset)object);
            object = null;
            try {
                FileConfiguration fileConfiguration3;
                InputStreamReader it = (InputStreamReader)object2;
                boolean bl = false;
                YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((Reader)it);
                Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration2, (String)"loadConfiguration(...)");
                YamlConfiguration fallback = yamlConfiguration2;
                if (sameLanguageFallback == null) {
                    fileConfiguration3 = (FileConfiguration)fallback;
                } else {
                    sameLanguageFallback.setDefaults((Configuration)fallback);
                    sameLanguageFallback.options().copyDefaults(true);
                    fileConfiguration3 = sameLanguageFallback;
                }
                fileConfiguration = fileConfiguration3;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
        }
        throw new IllegalArgumentException("A language with the key " + languageKey + " (" + languageFile.getAbsolutePath() + ") does not exist");
        FileConfiguration fallback = fileConfiguration;
        loadedTranslations.setDefaults((Configuration)fallback);
        loadedTranslations.options().copyDefaults(true);
        this.translations = this.processConfiguration((FileConfiguration)loadedTranslations);
    }

    @Override
    @NotNull
    public String get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, String> map = this.translations;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"translations");
            map = null;
        }
        String string = map.get(key);
        if (string == null) {
            String string2 = this.loadedLanguage;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadedLanguage");
                string2 = null;
            }
            throw new IllegalArgumentException("The key " + key + " is not present in the translation file for the language " + string2);
        }
        return string;
    }

    public final boolean contains(@NotNull String key, boolean printWarning) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, String> map = this.translations;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"translations");
            map = null;
        }
        boolean contains = map.containsKey(key);
        if (printWarning && !contains && !this.warned.contains(key)) {
            Logger logger = this.getPlugin().getSLF4JLogger();
            String string = this.loadedLanguage;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadedLanguage");
                string = null;
            }
            logger.warn("The translation key {} is missing in the translation file for the language {}, but not required", (Object)key, (Object)string);
            ((Collection)this.warned).add(key);
        }
        return contains;
    }

    @EventHandler
    public final void onConfigReload(@NotNull ConfigReloadEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        this.loadLanguage(e.getConfig().getGeneral().getLanguage());
        this.warned.clear();
        Iterable $this$forEach$iv = this.translationWrappers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractTranslation p0 = (AbstractTranslation)element$iv;
            boolean bl = false;
            p0.reset();
        }
    }

    @Override
    public void registerTranslationWrapper(@NotNull AbstractTranslation translation) {
        Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
        this.translationWrappers.add(translation);
    }

    private static final Component itemMiniMessage$lambda$2$lambda$1(Component it) {
        return it.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE).compact();
    }

    private static final boolean bundledLanguages$lambda$5$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it) && StringsKt.startsWith$default((String)it, (String)"lang/", (boolean)false, (int)2, null);
    }

    private static final String bundledLanguages$lambda$5$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.removeSurrounding((String)it, (CharSequence)"lang/", (CharSequence)".yml");
    }

    private static final boolean processConfiguration$lambda$7(char it) {
        return it == '\n' || it == '\r';
    }
}

