/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.libs.anvilgui;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.NotNull;

public final class AnvilGUI {
    private static final Set<String> STUPID_ANVIL_CLASSES = Set.of("com.willfp.ecoenchants.mechanics.AnvilSupport", "me.sciguymjm.uberenchant.utils.enchanting.AnvilEvents");
    private static final ThreadLocal<IntSet> STUPID_ANVIL_LOCKOUT = ThreadLocal.withInitial(IntArraySet::new);
    private final Plugin plugin;
    private final Player player;
    private final Component title;
    private final ItemStack[] initialContents;
    private final boolean preventClose;
    private final Set<Integer> interactableSlots;
    private final Consumer<StateSnapshot> closeListener;
    private final boolean concurrentClickHandlerExecution;
    private final ClickHandler clickHandler;
    private AnvilView view;
    private AnvilInventory inventory;
    private final ListenUp listener = new ListenUp();
    private boolean open;
    private ScheduledTask lockoutTask;

    private static ItemStack copyItemNotNull(ItemStack stack) {
        return stack == null ? ItemStack.empty() : stack.clone();
    }

    private AnvilGUI(Plugin plugin, Player player, Component title, ItemStack[] initialContents, boolean preventClose, Set<Integer> interactableSlots, Consumer<StateSnapshot> closeListener, boolean concurrentClickHandlerExecution, ClickHandler clickHandler) {
        this.plugin = plugin;
        this.player = player;
        this.title = title;
        this.initialContents = initialContents;
        this.preventClose = preventClose;
        this.interactableSlots = interactableSlots;
        this.closeListener = closeListener;
        this.concurrentClickHandlerExecution = concurrentClickHandlerExecution;
        this.clickHandler = clickHandler;
    }

    private void openInventory() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.listener, this.plugin);
        this.view = (AnvilView)MenuType.ANVIL.create((HumanEntity)this.player, this.title);
        this.inventory = this.view.getTopInventory();
        this.player.openInventory((InventoryView)this.view);
        for (int i2 = 0; i2 < this.initialContents.length; ++i2) {
            this.inventory.setItem(i2, this.initialContents[i2]);
        }
        this.lockoutTask = this.player.getScheduler().runAtFixedRate(this.plugin, task -> STUPID_ANVIL_LOCKOUT.get().clear(), () -> {}, 1L, 1L);
        this.open = true;
    }

    public void closeInventory() {
        this.closeInventory0();
        this.player.closeInventory();
    }

    private void closeInventory0() {
        if (!this.open) {
            return;
        }
        this.open = false;
        StateSnapshot state = StateSnapshot.fromAnvilGUI(this);
        this.inventory.clear();
        HandlerList.unregisterAll((Listener)this.listener);
        this.lockoutTask.cancel();
        if (this.closeListener != null) {
            this.closeListener.accept(state);
        }
    }

    @NotNull
    public AnvilInventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public String getRenameText() {
        return Objects.requireNonNullElse(this.view.getRenameText(), "");
    }

    private void runNextTick(@NotNull Runnable runnable) {
        this.player.getScheduler().run(this.plugin, task -> runnable.run(), () -> {});
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    static {
        HandlerList handlerList = PrepareAnvilEvent.getHandlerList();
        for (RegisteredListener registeredListener : handlerList.getRegisteredListeners()) {
            if (!STUPID_ANVIL_CLASSES.contains(registeredListener.getListener().getClass().getName())) continue;
            handlerList.unregister(registeredListener);
            EventExecutor eventExecutor = registeredListener.getExecutor();
            handlerList.register(new RegisteredListener(registeredListener.getListener(), (listener, event) -> {
                if (!STUPID_ANVIL_LOCKOUT.get().contains(event.hashCode())) {
                    eventExecutor.execute(listener, event);
                }
            }, registeredListener.getPriority(), registeredListener.getPlugin(), registeredListener.isIgnoringCancelled()));
        }
    }

    private final class ListenUp
    implements Listener {
        private boolean clickHandlerRunning = false;

        private ListenUp() {
        }

        @EventHandler
        public void onPluginDisable(PluginDisableEvent event) {
            if (event.getPlugin().equals((Object)AnvilGUI.this.plugin)) {
                AnvilGUI.this.closeInventory();
            }
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onPrepareAnvil(PrepareAnvilEvent event) {
            if (!event.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                return;
            }
            STUPID_ANVIL_LOCKOUT.get().add(event.hashCode());
            AnvilGUI.this.view.setRepairCost(0);
            ItemStack result = AnvilGUI.this.initialContents[2];
            if (result != null) {
                event.setResult(result);
            }
            AnvilGUI.this.player.updateInventory();
        }

        @EventHandler
        public void onInventoryClick(InventoryClickEvent event) {
            if (!event.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                return;
            }
            Player clicker = (Player)event.getWhoClicked();
            Inventory clickedInventory = event.getClickedInventory();
            if (clickedInventory != null && clickedInventory.equals((Object)clicker.getInventory()) && event.getClick().equals((Object)ClickType.DOUBLE_CLICK)) {
                event.setCancelled(true);
                return;
            }
            if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && !event.getClickedInventory().equals((Object)AnvilGUI.this.inventory)) {
                event.setCancelled(true);
                return;
            }
            int rawSlot = event.getRawSlot();
            if (rawSlot >= 0 && rawSlot <= 2) {
                event.setCancelled(!AnvilGUI.this.interactableSlots.contains(rawSlot));
                if (this.clickHandlerRunning && !AnvilGUI.this.concurrentClickHandlerExecution) {
                    return;
                }
                CompletableFuture actionsFuture = (CompletableFuture)AnvilGUI.this.clickHandler.apply(rawSlot, StateSnapshot.fromAnvilGUI(AnvilGUI.this));
                this.clickHandlerRunning = true;
                ((CompletableFuture)actionsFuture.thenAcceptAsync(actions -> {
                    for (ResponseAction action : actions) {
                        action.accept(AnvilGUI.this, clicker);
                    }
                }, AnvilGUI.this::runNextTick)).handle((results, exception) -> {
                    if (exception != null) {
                        AnvilGUI.this.plugin.getSLF4JLogger().error("An exception occurred in the AnvilGUI clickHandler", exception);
                    }
                    this.clickHandlerRunning = false;
                    return null;
                });
            }
        }

        @EventHandler
        public void onInventoryDrag(InventoryDragEvent event) {
            if (event.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                for (int slot : Slot.values) {
                    if (!event.getRawSlots().contains(slot) || AnvilGUI.this.interactableSlots.contains(slot)) continue;
                    event.setCancelled(true);
                    return;
                }
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent event) {
            if (AnvilGUI.this.open && event.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                AnvilGUI.this.closeInventory0();
                if (AnvilGUI.this.preventClose) {
                    AnvilGUI.this.runNextTick(AnvilGUI.this::openInventory);
                }
            }
        }
    }

    @FunctionalInterface
    public static interface ClickHandler
    extends BiFunction<Integer, StateSnapshot, CompletableFuture<List<ResponseAction>>> {
    }

    public record StateSnapshot(@NotNull String text, @NotNull ItemStack leftItem, @NotNull ItemStack rightItem, @NotNull ItemStack outputItem, @NotNull Player player) {
        private static StateSnapshot fromAnvilGUI(AnvilGUI anvilGUI) {
            AnvilInventory inventory = anvilGUI.getInventory();
            return new StateSnapshot(anvilGUI.getRenameText(), AnvilGUI.copyItemNotNull(inventory.getFirstItem()), AnvilGUI.copyItemNotNull(inventory.getSecondItem()), AnvilGUI.copyItemNotNull(inventory.getResult()), anvilGUI.player);
        }
    }

    public static final class Builder {
        private Consumer<StateSnapshot> closeListener;
        private boolean concurrentClickHandlerExecution = false;
        private ClickHandler clickHandler;
        private boolean preventClose = false;
        private Set<Integer> interactableSlots = Collections.emptySet();
        private Plugin plugin;
        private Component title = Component.translatable((String)"container.repair");
        private Component itemText;
        private ItemStack itemLeft;
        private ItemStack itemRight;
        private ItemStack itemOutput;

        @NotNull
        public Builder preventClose() {
            this.preventClose = true;
            return this;
        }

        @NotNull
        public Builder interactableSlots(int ... slots) {
            HashSet<Integer> newValue = new HashSet<Integer>();
            for (int slot : slots) {
                newValue.add(slot);
            }
            this.interactableSlots = newValue;
            return this;
        }

        @NotNull
        public Builder onClose(@NotNull @NotNull Consumer<@NotNull StateSnapshot> closeListener) {
            this.closeListener = Objects.requireNonNull(closeListener, "closeListener");
            return this;
        }

        @NotNull
        public Builder onClickAsync(@NotNull ClickHandler clickHandler) {
            this.clickHandler = Objects.requireNonNull(clickHandler, "clickHandler");
            return this;
        }

        @NotNull
        public Builder allowConcurrentClickHandlerExecution() {
            this.concurrentClickHandlerExecution = true;
            return this;
        }

        @NotNull
        public Builder onClick(@NotNull @NotNull BiFunction<@NotNull Integer, @NotNull StateSnapshot, @NotNull List<@NotNull ResponseAction>> clickHandler) {
            Objects.requireNonNull(clickHandler, "clickHandler");
            this.clickHandler = (slot, stateSnapshot) -> CompletableFuture.completedFuture((List)clickHandler.apply((Integer)slot, (StateSnapshot)stateSnapshot));
            return this;
        }

        @NotNull
        public Builder plugin(@NotNull Plugin plugin) {
            this.plugin = Objects.requireNonNull(plugin, "plugin");
            return this;
        }

        @NotNull
        public Builder text(@NotNull String text) {
            this.itemText = Component.text((String)Objects.requireNonNull(text, "text"));
            return this;
        }

        @NotNull
        public Builder text(@NotNull Component text) {
            this.itemText = Objects.requireNonNull(text, "text");
            return this;
        }

        @NotNull
        public Builder title(@NotNull String title) {
            this.title = Component.text((String)Objects.requireNonNull(title, "title"));
            return this;
        }

        @NotNull
        public Builder title(@NotNull Component title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        @NotNull
        public Builder itemLeft(@NotNull ItemStack item) {
            this.itemLeft = Objects.requireNonNull(item, "item").clone();
            return this;
        }

        @NotNull
        public Builder itemRight(@NotNull ItemStack item) {
            this.itemRight = Objects.requireNonNull(item, "item").clone();
            return this;
        }

        @NotNull
        public Builder itemOutput(@NotNull ItemStack item) {
            this.itemOutput = Objects.requireNonNull(item, "item").clone();
            return this;
        }

        @NotNull
        public AnvilGUI open(@NotNull Player player) {
            Objects.requireNonNull(this.plugin, "Plugin must be set");
            Objects.requireNonNull(this.clickHandler, "clickHandler must be set");
            Objects.requireNonNull(player, "player");
            if (this.itemText != null) {
                if (this.itemLeft == null) {
                    this.itemLeft = new ItemStack(Material.PAPER);
                }
                ItemMeta paperMeta = this.itemLeft.getItemMeta();
                paperMeta.displayName(this.itemText);
                this.itemLeft.setItemMeta(paperMeta);
            }
            AnvilGUI anvilGUI = new AnvilGUI(this.plugin, player, this.title, new ItemStack[]{this.itemLeft, this.itemRight, this.itemOutput}, this.preventClose, this.interactableSlots, this.closeListener, this.concurrentClickHandlerExecution, this.clickHandler);
            anvilGUI.openInventory();
            return anvilGUI;
        }
    }

    public static final class Slot {
        private static final int[] values = new int[]{0, 1, 2};
        public static final int INPUT_LEFT = 0;
        public static final int INPUT_RIGHT = 1;
        public static final int OUTPUT = 2;

        private Slot() {
        }

        public static int[] values() {
            return (int[])values.clone();
        }
    }

    @FunctionalInterface
    public static interface ResponseAction
    extends BiConsumer<AnvilGUI, Player> {
        @NotNull
        public static ResponseAction replaceInputText(@NotNull String text) {
            Objects.requireNonNull(text, "text");
            return (anvilgui, player) -> {
                ItemStack item = anvilgui.getInventory().getItem(2);
                if (item == null) {
                    item = anvilgui.getInventory().getItem(0);
                }
                if (item == null) {
                    throw new IllegalStateException("replaceInputText can only be used if slots OUTPUT or INPUT_LEFT are not empty");
                }
                ItemStack cloned = item.clone();
                ItemMeta meta = cloned.getItemMeta();
                meta.displayName((Component)Component.text((String)text));
                cloned.setItemMeta(meta);
                anvilgui.getInventory().setItem(0, cloned);
            };
        }

        @NotNull
        public static ResponseAction updateTitle(@NotNull Component title, boolean preserveRenameText) {
            Objects.requireNonNull(title, "title");
            return (anvilGUI, player) -> {
                AnvilInventory inventory;
                StateSnapshot oldState = StateSnapshot.fromAnvilGUI(anvilGUI);
                anvilGUI.inventory.clear();
                anvilGUI.view = (AnvilView)MenuType.ANVIL.create((HumanEntity)player, title);
                anvilGUI.inventory = inventory = anvilGUI.view.getTopInventory();
                if (preserveRenameText) {
                    ItemStack firstItem = oldState.leftItem();
                    if (!firstItem.isEmpty()) {
                        firstItem.editMeta(meta -> meta.displayName((Component)Component.text((String)oldState.text)));
                        inventory.setFirstItem(firstItem);
                    }
                } else {
                    inventory.setFirstItem(oldState.leftItem());
                }
                inventory.setSecondItem(oldState.rightItem());
                inventory.setResult(oldState.outputItem());
                player.openInventory((InventoryView)anvilGUI.view);
            };
        }

        @NotNull
        public static ResponseAction openInventory(@NotNull Inventory otherInventory) {
            Objects.requireNonNull(otherInventory, "otherInventory");
            return (anvilgui, player) -> player.openInventory(otherInventory);
        }

        @NotNull
        public static ResponseAction close() {
            return (anvilgui, player) -> anvilgui.closeInventory();
        }

        @NotNull
        public static ResponseAction run(@NotNull Runnable runnable) {
            Objects.requireNonNull(runnable, "runnable");
            return (anvilgui, player) -> runnable.run();
        }
    }
}

