/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.libs.bstats.charts;

import de.md5lukas.waypoints.libs.bstats.json.JsonObjectBuilder;
import java.util.function.BiConsumer;

public abstract class CustomChart {
    private final String chartId;

    protected CustomChart(String chartId) {
        if (chartId == null) {
            throw new IllegalArgumentException("chartId must not be null");
        }
        this.chartId = chartId;
    }

    public JsonObjectBuilder.JsonObject getRequestJsonObject(BiConsumer<String, Throwable> errorLogger, boolean logErrors) {
        JsonObjectBuilder builder2 = new JsonObjectBuilder();
        builder2.appendField("chartId", this.chartId);
        try {
            JsonObjectBuilder.JsonObject data = this.getChartData();
            if (data == null) {
                return null;
            }
            builder2.appendField("data", data);
        }
        catch (Throwable t) {
            if (logErrors) {
                errorLogger.accept("Failed to get data for custom chart with id " + this.chartId, t);
            }
            return null;
        }
        return builder2.build();
    }

    protected abstract JsonObjectBuilder.JsonObject getChartData() throws Exception;
}

