/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.libs.commons.collections;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0012\u0012\u0004\u0012\u0002H\u00010\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/md5lukas/waypoints/libs/commons/collections/LoopAroundList;", "T", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "cutOutSize", "", "(I)V", "cutOut", "", "getCutOut", "()Ljava/util/List;", "index", "move", "steps", "next", "previous", "setIndex", "md5-commons"})
public final class LoopAroundList<T>
extends ArrayList<T> {
    private final int cutOutSize;
    private int index;

    public LoopAroundList(int cutOutSize) {
        this.cutOutSize = cutOutSize;
        Preconditions.checkArgument((this.cutOutSize > 0 ? 1 : 0) != 0, (String)"The cutout size needs to be greater than zero, but was %d", (int)this.cutOutSize);
    }

    public final int next() {
        return this.move(1);
    }

    public final int previous() {
        return this.move(-1);
    }

    public final int move(int steps) {
        return this.setIndex(this.index + steps);
    }

    public final int setIndex(int index) {
        this.index = Math.floorMod(index, this.size());
        return this.index;
    }

    @NotNull
    public final List<T> getCutOut() {
        ArrayList result = new ArrayList();
        int n = this.cutOutSize;
        for (int i2 = 0; i2 < n; ++i2) {
            int actualIndex = i2 - this.index;
            actualIndex = actualIndex >= 0 ? actualIndex : actualIndex + this.size();
            result.add(this.get(actualIndex));
        }
        return result;
    }
}

