/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.libs.commons.collections;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0012\u0012\u0004\u0012\u0002H\u00010\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/md5lukas/waypoints/libs/commons/collections/PaginationList;", "T", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "itemsPerPage", "", "(I)V", "page", "", "pageEnd", "pageStart", "pages", "md5-commons"})
public final class PaginationList<T>
extends ArrayList<T> {
    private final int itemsPerPage;

    public PaginationList(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
        Preconditions.checkArgument((this.itemsPerPage > 0 ? 1 : 0) != 0, (String)"The amount of items per page must be greater than zero, but was %d", (int)this.itemsPerPage);
    }

    public final int pageStart(int page) {
        Preconditions.checkArgument((page >= 0 && page < this.pages() ? 1 : 0) != 0, (String)"The provided page number is out of bounds of the available pages", (Object[])new Object[0]);
        return page * this.itemsPerPage;
    }

    public final int pageEnd(int page) {
        Preconditions.checkArgument((page >= 0 && page < this.pages() ? 1 : 0) != 0, (String)"The provided page number is out of bounds of the available pages", (Object[])new Object[0]);
        int end = page * this.itemsPerPage + this.itemsPerPage;
        return RangesKt.coerceAtMost((int)this.size(), (int)end);
    }

    public final int pages() {
        return (int)Math.ceil((double)this.size() / (double)this.itemsPerPage);
    }

    @NotNull
    public final List<T> page(int page) {
        List list;
        if (this.size() == 0) {
            list = CollectionsKt.emptyList();
        } else {
            List list2 = this.subList(this.pageStart(page), this.pageEnd(page));
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"subList(pageStart(page), pageEnd(page))");
        }
        return list;
    }
}

