/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.libs.commons.paper;

import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import de.md5lukas.waypoints.libs.commons.MathHelperKt;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\r\u0010\u0004\u001a\u00020\u0005*\u00020\u0002H\u0086\u0002\u001a\r\u0010\u0006\u001a\u00020\u0005*\u00020\u0002H\u0086\u0002\u001a\r\u0010\u0007\u001a\u00020\u0005*\u00020\u0002H\u0086\u0002\u001a\u0012\u0010\b\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u001a\u0012\u0010\n\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u001a\u001a\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0005\u001a\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0011"}, d2={"isOutOfBounds", "", "Lorg/bukkit/Location;", "(Lorg/bukkit/Location;)Z", "component1", "", "component2", "component3", "distance2D", "other", "distance2DSquared", "fuzzyEquals", "tolerance", "teleportKeepOrientation", "Ljava/util/concurrent/CompletableFuture;", "Lorg/bukkit/entity/Player;", "location", "md5-commons"})
public final class LocationsKt {
    public static final double component1(@NotNull Location $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.getX();
    }

    public static final double component2(@NotNull Location $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        return $this$component2.getY();
    }

    public static final double component3(@NotNull Location $this$component3) {
        Intrinsics.checkNotNullParameter((Object)$this$component3, (String)"<this>");
        return $this$component3.getZ();
    }

    public static final double distance2DSquared(@NotNull Location $this$distance2DSquared, @NotNull Location other) {
        Intrinsics.checkNotNullParameter((Object)$this$distance2DSquared, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Preconditions.checkArgument((boolean)Intrinsics.areEqual((Object)$this$distance2DSquared.getWorld(), (Object)other.getWorld()));
        return MathHelperKt.getSquared($this$distance2DSquared.getX() - other.getX()) + MathHelperKt.getSquared($this$distance2DSquared.getZ() - other.getZ());
    }

    public static final double distance2D(@NotNull Location $this$distance2D, @NotNull Location other) {
        Intrinsics.checkNotNullParameter((Object)$this$distance2D, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Math.sqrt(LocationsKt.distance2DSquared($this$distance2D, other));
    }

    public static final boolean fuzzyEquals(@NotNull Location $this$fuzzyEquals, @NotNull Location other, double tolerance) {
        Intrinsics.checkNotNullParameter((Object)$this$fuzzyEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$fuzzyEquals.getWorld() == other.getWorld() && DoubleMath.fuzzyEquals((double)$this$fuzzyEquals.getX(), (double)other.getX(), (double)tolerance) && DoubleMath.fuzzyEquals((double)$this$fuzzyEquals.getY(), (double)other.getY(), (double)tolerance) && DoubleMath.fuzzyEquals((double)$this$fuzzyEquals.getX(), (double)other.getX(), (double)tolerance);
    }

    public static final boolean isOutOfBounds(@NotNull Location $this$isOutOfBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$isOutOfBounds, (String)"<this>");
        if (!$this$isOutOfBounds.getWorld().getWorldBorder().isInside($this$isOutOfBounds)) {
            return true;
        }
        int n = $this$isOutOfBounds.getWorld().getMinHeight();
        int n2 = $this$isOutOfBounds.getWorld().getMaxHeight();
        int n3 = MathKt.roundToInt((double)$this$isOutOfBounds.getY());
        return !(n <= n3 ? n3 <= n2 : false);
    }

    @NotNull
    public static final CompletableFuture<Boolean> teleportKeepOrientation(@NotNull Player $this$teleportKeepOrientation, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)$this$teleportKeepOrientation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Location location2 = location.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"location.clone()");
        Location target = location2;
        target.setPitch($this$teleportKeepOrientation.getLocation().getPitch());
        target.setYaw($this$teleportKeepOrientation.getLocation().getYaw());
        CompletableFuture completableFuture = $this$teleportKeepOrientation.teleportAsync(target);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"this.teleportAsync(target)");
        return completableFuture;
    }
}

