/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.libs.commons.time;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B=\u00126\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0002\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0010R>\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/md5lukas/waypoints/libs/commons/time/DurationFormatter;", "", "pluralizationHelper", "Lkotlin/Function2;", "Ljava/util/concurrent/TimeUnit;", "Lkotlin/ParameterName;", "name", "unit", "", "isPlural", "", "(Lkotlin/jvm/functions/Function2;)V", "formatDuration", "duration", "Ljava/time/Duration;", "value", "", "timeUnit", "pluralizeSeconds", "seconds", "md5-commons"})
public final class DurationFormatter {
    @NotNull
    private final Function2<TimeUnit, Boolean, String> pluralizationHelper;

    public DurationFormatter(@NotNull Function2<? super TimeUnit, ? super Boolean, String> pluralizationHelper) {
        Intrinsics.checkNotNullParameter(pluralizationHelper, (String)"pluralizationHelper");
        this.pluralizationHelper = pluralizationHelper;
    }

    @NotNull
    public final String formatDuration(@NotNull Duration duration) {
        int seconds;
        int minutes;
        int hours;
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Preconditions.checkArgument((!duration.isNegative() && !duration.isZero() ? 1 : 0) != 0, (String)"The duration to convert to a string must be positive", (Object[])new Object[0]);
        StringBuilder builder2 = new StringBuilder();
        long days = duration.toDaysPart();
        if (days > 0L) {
            builder2.append(days).append(' ').append(this.pluralizationHelper(days, TimeUnit.DAYS));
        }
        if ((hours = duration.toHoursPart()) > 0) {
            if (((CharSequence)builder2).length() > 0) {
                builder2.append(' ');
            }
            builder2.append(hours).append(' ').append(this.pluralizationHelper(hours, TimeUnit.HOURS));
        }
        if ((minutes = duration.toMinutesPart()) > 0) {
            if (((CharSequence)builder2).length() > 0) {
                builder2.append(' ');
            }
            builder2.append(minutes).append(' ').append(this.pluralizationHelper(minutes, TimeUnit.MINUTES));
        }
        if ((seconds = duration.toSecondsPart()) > 0) {
            if (((CharSequence)builder2).length() > 0) {
                builder2.append(' ');
            }
            builder2.append(seconds).append(' ').append(this.pluralizationHelper(seconds, TimeUnit.SECONDS));
        } else if (((CharSequence)builder2).length() == 0) {
            builder2.append("< 1 ").append(this.pluralizationHelper(1L, TimeUnit.SECONDS));
        }
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public final String pluralizeSeconds(long seconds) {
        return seconds + " " + this.pluralizationHelper(seconds, TimeUnit.SECONDS);
    }

    private final String pluralizationHelper(long value, TimeUnit timeUnit) {
        boolean isPlural = value != 1L;
        return (String)this.pluralizationHelper.invoke((Object)timeUnit, (Object)isPlural);
    }
}

