/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.libs.schedulers;

import de.md5lukas.waypoints.libs.schedulers.AbstractScheduledTask;
import de.md5lukas.waypoints.libs.schedulers.AbstractScheduler;
import de.md5lukas.waypoints.libs.schedulers.BukkitScheduledTask;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J*\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\"\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lde/md5lukas/waypoints/libs/schedulers/BukkitScheduler;", "Lde/md5lukas/waypoints/libs/schedulers/AbstractScheduler;", "plugin", "Lorg/bukkit/plugin/Plugin;", "(Lorg/bukkit/plugin/Plugin;)V", "getPlugin", "()Lorg/bukkit/plugin/Plugin;", "scheduler", "Lorg/bukkit/scheduler/BukkitScheduler;", "Lorg/jetbrains/annotations/NotNull;", "getScheduler", "()Lorg/bukkit/scheduler/BukkitScheduler;", "schedule", "Lde/md5lukas/waypoints/libs/schedulers/AbstractScheduledTask;", "retired", "Ljava/lang/Runnable;", "block", "scheduleAsync", "scheduleAtFixedRate", "interval", "", "delay", "scheduleAtFixedRateAsync", "scheduleDelayed", "scheduleDelayedAsync", "toString", "", "schedulers"})
public final class BukkitScheduler
implements AbstractScheduler {
    @NotNull
    private final Plugin plugin;

    public BukkitScheduler(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    private final org.bukkit.scheduler.BukkitScheduler getScheduler() {
        org.bukkit.scheduler.BukkitScheduler bukkitScheduler = this.getPlugin().getServer().getScheduler();
        Intrinsics.checkNotNullExpressionValue((Object)bukkitScheduler, (String)"plugin.server.scheduler");
        return bukkitScheduler;
    }

    @Override
    @NotNull
    public AbstractScheduledTask schedule(@Nullable Runnable retired, @NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        BukkitTask bukkitTask = this.getScheduler().runTask(this.getPlugin(), block);
        Intrinsics.checkNotNullExpressionValue((Object)bukkitTask, (String)"scheduler.runTask(plugin, block)");
        return new BukkitScheduledTask(bukkitTask);
    }

    @Override
    @NotNull
    public AbstractScheduledTask scheduleAsync(@NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        BukkitTask bukkitTask = this.getScheduler().runTaskAsynchronously(this.getPlugin(), block);
        Intrinsics.checkNotNullExpressionValue((Object)bukkitTask, (String)"scheduler.runTaskAsynchronously(plugin, block)");
        return new BukkitScheduledTask(bukkitTask);
    }

    @Override
    @NotNull
    public AbstractScheduledTask scheduleDelayed(long delay, @Nullable Runnable retired, @NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        BukkitTask bukkitTask = this.getScheduler().runTaskLater(this.getPlugin(), block, delay);
        Intrinsics.checkNotNullExpressionValue((Object)bukkitTask, (String)"scheduler.runTaskLater(plugin, block, delay)");
        return new BukkitScheduledTask(bukkitTask);
    }

    @Override
    @NotNull
    public AbstractScheduledTask scheduleDelayedAsync(long delay, @NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        BukkitTask bukkitTask = this.getScheduler().runTaskLaterAsynchronously(this.getPlugin(), block, delay);
        Intrinsics.checkNotNullExpressionValue((Object)bukkitTask, (String)"scheduler.runTaskLaterAs\u2026sly(plugin, block, delay)");
        return new BukkitScheduledTask(bukkitTask);
    }

    @Override
    @NotNull
    public AbstractScheduledTask scheduleAtFixedRate(long interval, long delay, @Nullable Runnable retired, @NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        BukkitTask bukkitTask = this.getScheduler().runTaskTimer(this.getPlugin(), block, delay, interval);
        Intrinsics.checkNotNullExpressionValue((Object)bukkitTask, (String)"scheduler.runTaskTimer(p\u2026, block, delay, interval)");
        return new BukkitScheduledTask(bukkitTask);
    }

    @Override
    @NotNull
    public AbstractScheduledTask scheduleAtFixedRateAsync(long interval, long delay, @NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        BukkitTask bukkitTask = this.getScheduler().runTaskTimerAsynchronously(this.getPlugin(), block, delay, interval);
        Intrinsics.checkNotNullExpressionValue((Object)bukkitTask, (String)"scheduler.runTaskTimerAs\u2026, block, delay, interval)");
        return new BukkitScheduledTask(bukkitTask);
    }

    @NotNull
    public String toString() {
        return "BukkitScheduler(plugin=" + this.getPlugin() + ")";
    }
}

