/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.libs.signgui;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class SignGUI {
    private static final int OFFSET = 4;
    private static final List<Component> EMPTY_LINES = List.of(Component.empty(), Component.empty(), Component.empty(), Component.empty());
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final ProtocolManager protocolManager;
    @NotNull
    private final Player player;
    @NotNull
    private final @NotNull Consumer<@NotNull String @NotNull []> onClose;
    @NotNull
    private final DyeColor color;
    @NotNull
    private final @NotNull List<@NotNull Component> lines;
    private boolean open;

    private SignGUI(@NotNull Plugin plugin, @NotNull Player player, @NotNull @NotNull Consumer<@NotNull String @NotNull []> onClose, @NotNull DyeColor color, @NotNull @NotNull List<@NotNull Component> lines) {
        this.plugin = plugin;
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        this.player = player;
        this.onClose = onClose;
        this.color = color;
        this.lines = lines;
        this.open = false;
    }

    private void open() {
        if (this.open) {
            return;
        }
        this.open = true;
        final Location signLocation = this.getSignLocation();
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter(this.plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Client.UPDATE_SIGN}){

            public void onPacketReceiving(PacketEvent event) {
                if (event.getPlayer() != SignGUI.this.player) {
                    return;
                }
                SignGUI.this.protocolManager.removePacketListener((PacketListener)this);
                event.setCancelled(true);
                SignGUI.this.open = false;
                Block realBlock = signLocation.getBlock();
                SignGUI.this.player.sendBlockChange(signLocation, realBlock.getBlockData());
                BlockState blockState = realBlock.getState();
                if (blockState instanceof TileState) {
                    TileState tileState = (TileState)blockState;
                    SignGUI.this.player.sendBlockUpdate(signLocation, tileState);
                }
                String[] lines = (String[])event.getPacket().getStringArrays().read(0);
                for (int index = 0; index < 3; ++index) {
                    SignGUI.this.lines.set(index, SignGUI.this.fromPlain(lines[index]));
                }
                SignGUI.this.onClose.accept(lines);
            }
        });
        BlockData blockData = this.plugin.getServer().createBlockData(Material.OAK_SIGN);
        this.player.sendBlockChange(signLocation, blockData);
        if (this.lines != EMPTY_LINES) {
            Sign blockState = (Sign)blockData.createBlockState();
            SignSide side = blockState.getSide(Side.FRONT);
            side.setColor(this.color);
            for (int index = 0; index < 4; ++index) {
                side.line(index, this.lines.get(index));
            }
            this.player.sendBlockUpdate(signLocation, (TileState)blockState);
        }
        PacketContainer openSignPacket = new PacketContainer(PacketType.Play.Server.OPEN_SIGN_EDITOR);
        openSignPacket.getBlockPositionModifier().write(0, (Object)new BlockPosition(signLocation.getBlockX(), signLocation.getBlockY(), signLocation.getBlockZ()));
        openSignPacket.getBooleans().writeSafely(0, (Object)true);
        this.protocolManager.sendServerPacket(this.player, openSignPacket);
    }

    @NotNull
    private Location getSignLocation() {
        Location signLocation = this.player.getLocation().toBlockLocation();
        if (signLocation.getY() <= (double)(signLocation.getWorld().getMinHeight() + 4)) {
            signLocation.add(0.0, 4.0, 0.0);
        } else {
            signLocation.subtract(0.0, 4.0, 0.0);
        }
        return signLocation;
    }

    @NotNull
    private Component fromPlain(@NotNull String json) {
        return PlainTextComponentSerializer.plainText().deserialize(json);
    }

    @NotNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Plugin plugin;
        private Player player;
        private Consumer<@NotNull String @NotNull []> onClose;
        @NotNull
        private DyeColor color = DyeColor.BLACK;
        @NotNull
        private @NotNull List<@NotNull Component> lines = new ArrayList<Component>(EMPTY_LINES);

        private Builder() {
        }

        @NotNull
        public Builder plugin(@NotNull Plugin plugin) {
            Preconditions.checkNotNull((Object)plugin);
            this.plugin = plugin;
            return this;
        }

        @NotNull
        public Builder player(@NotNull Player player) {
            Preconditions.checkNotNull((Object)player);
            this.player = player;
            return this;
        }

        @NotNull
        public Builder onClose(@NotNull @NotNull Consumer<@NotNull String @NotNull []> onClose) {
            Preconditions.checkNotNull(onClose);
            this.onClose = onClose;
            return this;
        }

        @NotNull
        public Builder color(@NotNull DyeColor color) {
            Preconditions.checkNotNull((Object)color);
            this.color = color;
            return this;
        }

        @NotNull
        public Builder lines(@NotNull @NotNull @Unmodifiable List<@NotNull String> lines) {
            Preconditions.checkNotNull(lines);
            Preconditions.checkArgument((lines.size() == 4 ? 1 : 0) != 0);
            this.lines = new ArrayList<Component>(4);
            for (String line : lines) {
                this.lines.add((Component)PlainTextComponentSerializer.plainText().deserialize(line));
            }
            return this;
        }

        @NotNull
        public SignGUI open() {
            Preconditions.checkNotNull((Object)this.plugin);
            Preconditions.checkNotNull((Object)this.player);
            Preconditions.checkNotNull(this.onClose);
            SignGUI signGui = new SignGUI(this.plugin, this.player, this.onClose, this.color, this.lines);
            signGui.open();
            return signGui;
        }
    }
}

