/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers;

import de.md5lukas.waypoints.libs.schedulers.AbstractScheduledTask;
import de.md5lukas.waypoints.libs.schedulers.AbstractScheduler;
import de.md5lukas.waypoints.libs.schedulers.Schedulers;
import de.md5lukas.waypoints.pointers.Pointer;
import de.md5lukas.waypoints.pointers.PointerManager;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.pointers.variants.PointerVariant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012J\u0006\u0010\u001f\u001a\u00020\u001cJ\u0006\u0010 \u001a\u00020\u001cJ\b\u0010!\u001a\u00020\u001cH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u00060\u000fR\u00020\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010$\u001a\u00070%\u00a2\u0006\u0002\b&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006\r"}, d2={"Lde/md5lukas/waypoints/pointers/ManagedPlayer;", "", "pointerManager", "Lde/md5lukas/waypoints/pointers/PointerManager;", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lde/md5lukas/waypoints/pointers/PointerManager;Lorg/bukkit/entity/Player;)V", "scheduler", "Lde/md5lukas/waypoints/libs/schedulers/AbstractScheduler;", "pointerSetupLock", "pointerSetup", "Ljava/util/concurrent/CompletableFuture;", "pointers", "", "Lde/md5lukas/waypoints/pointers/ManagedPlayer$PlayerPointer;", "tracked", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lde/md5lukas/waypoints/pointers/Trackable;", "readOnlyTracked", "", "getReadOnlyTracked", "()Ljava/util/Collection;", "canBeDiscarded", "", "getCanBeDiscarded", "()Z", "show", "", "trackable", "hide", "immediateCleanup", "reapplyConfiguration", "scheduleTasks", "translateTarget", "Lorg/bukkit/Location;", "logger", "Lorg/slf4j/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lorg/slf4j/Logger;", "PlayerPointer"})
@SourceDebugExtension(value={"SMAP\nManagedPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedPlayer.kt\nde/md5lukas/waypoints/pointers/ManagedPlayer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1869#2:229\n1870#2:231\n1869#2,2:232\n1869#2,2:234\n1869#2,2:236\n1#3:230\n*S KotlinDebug\n*F\n+ 1 ManagedPlayer.kt\nde/md5lukas/waypoints/pointers/ManagedPlayer\n*L\n49#1:229\n49#1:231\n60#1:232,2\n204#1:234,2\n71#1:236,2\n*E\n"})
public final class ManagedPlayer {
    @NotNull
    private final PointerManager pointerManager;
    @NotNull
    private final Player player;
    @NotNull
    private final AbstractScheduler scheduler;
    @NotNull
    private final Object pointerSetupLock;
    @Nullable
    private CompletableFuture<?> pointerSetup;
    @NotNull
    private final List<PlayerPointer> pointers;
    @NotNull
    private final CopyOnWriteArrayList<Trackable> tracked;
    @NotNull
    private final Collection<Trackable> readOnlyTracked;

    public ManagedPlayer(@NotNull PointerManager pointerManager, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)pointerManager, (String)"pointerManager");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.pointerManager = pointerManager;
        this.player = player;
        this.scheduler = Schedulers.INSTANCE.entity(this.pointerManager.getPlugin$pointers(), (Entity)this.player);
        this.pointerSetupLock = new Object();
        this.pointers = new ArrayList();
        this.tracked = new CopyOnWriteArrayList();
        Collection collection = Collections.unmodifiableCollection((Collection)this.tracked);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"unmodifiableCollection(...)");
        this.readOnlyTracked = collection;
    }

    @NotNull
    public final Collection<Trackable> getReadOnlyTracked() {
        return this.readOnlyTracked;
    }

    public final boolean getCanBeDiscarded() {
        return this.tracked.isEmpty();
    }

    public final void show(@NotNull Trackable trackable) {
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        if (this.tracked.contains(trackable)) {
            if (!Intrinsics.areEqual((Object)CollectionsKt.last((List)this.tracked), (Object)trackable)) {
                this.tracked.remove(trackable);
                this.tracked.add(trackable);
            }
        } else {
            this.tracked.add(trackable);
        }
        this.getLogger().debug("Showing Trackable {}", (Object)trackable);
        if (this.pointers.isEmpty()) {
            this.scheduleTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void hide(@NotNull Trackable trackable) {
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        this.tracked.remove(trackable);
        boolean discard = this.getCanBeDiscarded();
        this.getLogger().debug("Hiding Trackable {} Discard {}", (Object)trackable, (Object)discard);
        Iterable $this$forEach$iv = this.pointers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerPointer it = (PlayerPointer)element$iv;
            boolean bl = false;
            List<Trackable> list = it.getHide();
            synchronized (list) {
                boolean bl2 = false;
                boolean bl3 = it.getHide().add(trackable);
            }
            it.setScheduleKill(discard);
        }
        if (discard) {
            this.pointers.clear();
            this.pointerSetup = null;
        }
    }

    public final void immediateCleanup() {
        Iterable $this$forEach$iv = this.pointers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerPointer it = (PlayerPointer)element$iv;
            boolean bl = false;
            it.getTask().cancel();
            it.immediateCleanup();
        }
        this.pointers.clear();
    }

    public final void reapplyConfiguration() {
        ArrayList copy = new ArrayList(this.pointers);
        AbstractScheduler.schedule$default(this.scheduler, null, () -> ManagedPlayer.reapplyConfiguration$lambda$4(copy), 1, null);
        this.pointers.clear();
        this.pointerSetup = null;
        this.scheduleTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleTasks() {
        if (this.pointerSetup != null) {
            return;
        }
        Object object = this.pointerSetupLock;
        synchronized (object) {
            boolean bl = false;
            if (this.pointerSetup != null) {
                return;
            }
            this.pointerSetup = ((CompletableFuture)this.pointerManager.getHooks$pointers().loadEnabledPointers(this.player).thenAccept(arg_0 -> ManagedPlayer.scheduleTasks$lambda$7$lambda$5(new Function1(this){
                final /* synthetic */ ManagedPlayer this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(Map<PointerVariant, Boolean> enabled) {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Iterable iterable = (Iterable)PointerVariant.getEntries();
                    ManagedPlayer managedPlayer = this.this$0;
                    boolean $i$f$filter = false;
                    Iterator<T> iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        PointerVariant it = (PointerVariant)((Object)element$iv$iv);
                        boolean bl = false;
                        if (!((Boolean)it.isEnabled().invoke((Object)ManagedPlayer.access$getPointerManager$p(managedPlayer).getConfiguration$pointers()) != false && enabled.getOrDefault((Object)((Object)it), true) != false)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    managedPlayer = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        AbstractScheduledTask task;
                        PointerVariant it = (PointerVariant)((Object)element$iv);
                        boolean bl = false;
                        Pointer pointer = (Pointer)it.getCreate$pointers().invoke((Object)ManagedPlayer.access$getPointerManager$p(managedPlayer), (Object)ManagedPlayer.access$getPlayer$p(managedPlayer), (Object)ManagedPlayer.access$getScheduler$p(managedPlayer));
                        ManagedPlayer.access$getLogger(managedPlayer).debug("Commissioning new PlayerPointer for {}", (Object)pointer);
                        PlayerPointer playerPointer = managedPlayer.new PlayerPointer(pointer);
                        AbstractScheduledTask abstractScheduledTask = task = pointer.getAsync() ? ManagedPlayer.access$getScheduler$p(managedPlayer).scheduleAtFixedRateAsync(pointer.getInterval(), 1L, playerPointer) : AbstractScheduler.scheduleAtFixedRate$default(ManagedPlayer.access$getScheduler$p(managedPlayer), pointer.getInterval(), 1L, null, playerPointer, 4, null);
                        if (task == null) continue;
                        boolean bl2 = false;
                        playerPointer.setTask(task);
                        ((Collection)ManagedPlayer.access$getPointers$p(managedPlayer)).add(playerPointer);
                    }
                }
            }, arg_0))).exceptionally(arg_0 -> ManagedPlayer.scheduleTasks$lambda$7$lambda$6(this, arg_0));
            Unit unit = Unit.INSTANCE;
        }
    }

    private final Location translateTarget(Trackable trackable) {
        if (this.player.getWorld() == trackable.getLocation().getWorld()) {
            return trackable.getLocation();
        }
        Iterable $this$forEach$iv = this.pointerManager.getConfiguration$pointers().getConnectedWorlds().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it;
            block8: {
                block7: {
                    it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getKey(), (Object)this.player.getWorld().getName())) break block7;
                    World world = trackable.getLocation().getWorld();
                    if (Intrinsics.areEqual(it.getValue(), (Object)(world != null ? world.getName() : null))) break block8;
                }
                if (!Intrinsics.areEqual(it.getValue(), (Object)this.player.getWorld().getName())) continue;
                World world = trackable.getLocation().getWorld();
                if (!Intrinsics.areEqual(it.getKey(), (Object)(world != null ? world.getName() : null))) continue;
            }
            Location location = trackable.getLocation().clone();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
            Location target = location;
            target.setWorld(this.player.getWorld());
            if (Intrinsics.areEqual((Object)this.player.getWorld().getName(), it.getKey())) {
                target.setX(target.getX() * (double)8);
                target.setZ(target.getZ() * (double)8);
            } else {
                target.setX(Math.floor(target.getX() / (double)8));
                target.setZ(Math.floor(target.getZ() / (double)8));
            }
            return target;
        }
        return null;
    }

    private final Logger getLogger() {
        Logger logger = this.pointerManager.getPlugin$pointers().getSLF4JLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getSLF4JLogger(...)");
        return logger;
    }

    private static final void reapplyConfiguration$lambda$4(ArrayList $copy) {
        Iterable $this$forEach$iv = $copy;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerPointer it = (PlayerPointer)element$iv;
            boolean bl = false;
            it.getTask().cancel();
            it.immediateCleanup();
        }
    }

    private static final void scheduleTasks$lambda$7$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Void scheduleTasks$lambda$7$lambda$6(ManagedPlayer this$0, Throwable it) {
        this$0.getLogger().error("Couldn't load enabled pointer types for player " + this$0.player.getName(), it);
        return null;
    }

    public static final /* synthetic */ PointerManager access$getPointerManager$p(ManagedPlayer $this) {
        return $this.pointerManager;
    }

    public static final /* synthetic */ List access$getPointers$p(ManagedPlayer $this) {
        return $this.pointers;
    }

    public static final /* synthetic */ Player access$getPlayer$p(ManagedPlayer $this) {
        return $this.player;
    }

    public static final /* synthetic */ AbstractScheduler access$getScheduler$p(ManagedPlayer $this) {
        return $this.scheduler;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0019J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/md5lukas/waypoints/pointers/ManagedPlayer$PlayerPointer;", "Ljava/lang/Runnable;", "pointer", "Lde/md5lukas/waypoints/pointers/Pointer;", "<init>", "(Lde/md5lukas/waypoints/pointers/ManagedPlayer;Lde/md5lukas/waypoints/pointers/Pointer;)V", "task", "Lde/md5lukas/waypoints/libs/schedulers/AbstractScheduledTask;", "getTask", "()Lde/md5lukas/schedulers/AbstractScheduledTask;", "setTask", "(Lde/md5lukas/schedulers/AbstractScheduledTask;)V", "scheduleKill", "", "getScheduleKill", "()Z", "setScheduleKill", "(Z)V", "hide", "", "Lde/md5lukas/waypoints/pointers/Trackable;", "getHide", "()Ljava/util/List;", "previousPrimary", "run", "", "immediateCleanup", "toString", "", "pointers"})
    @SourceDebugExtension(value={"SMAP\nManagedPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedPlayer.kt\nde/md5lukas/waypoints/pointers/ManagedPlayer$PlayerPointer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1869#2,2:229\n1869#2,2:231\n543#2,6:233\n1869#2,2:240\n1#3:239\n*S KotlinDebug\n*F\n+ 1 ManagedPlayer.kt\nde/md5lukas/waypoints/pointers/ManagedPlayer$PlayerPointer\n*L\n137#1:229,2\n158#1:231,2\n164#1:233,6\n185#1:240,2\n*E\n"})
    public final class PlayerPointer
    implements Runnable {
        @NotNull
        private final Pointer pointer;
        public AbstractScheduledTask task;
        private boolean scheduleKill;
        @NotNull
        private final List<Trackable> hide;
        @Nullable
        private Trackable previousPrimary;

        public PlayerPointer(Pointer pointer) {
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            this.pointer = pointer;
            this.hide = new ArrayList();
        }

        @NotNull
        public final AbstractScheduledTask getTask() {
            AbstractScheduledTask abstractScheduledTask = this.task;
            if (abstractScheduledTask != null) {
                return abstractScheduledTask;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"task");
            return null;
        }

        public final void setTask(@NotNull AbstractScheduledTask abstractScheduledTask) {
            Intrinsics.checkNotNullParameter((Object)abstractScheduledTask, (String)"<set-?>");
            this.task = abstractScheduledTask;
        }

        public final boolean getScheduleKill() {
            return this.scheduleKill;
        }

        public final void setScheduleKill(boolean bl) {
            this.scheduleKill = bl;
        }

        @NotNull
        public final List<Trackable> getHide() {
            return this.hide;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            Iterable<Trackable> iterable = this.hide;
            ManagedPlayer managedPlayer = ManagedPlayer.this;
            List<Trackable> list = iterable;
            synchronized (list) {
                boolean $i$a$-synchronized-ManagedPlayer$PlayerPointer$run$22 = false;
                Iterable $this$forEach$iv = this.hide;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Trackable it = (Trackable)element$iv;
                    boolean bl = false;
                    if (!this.pointer.getVariant().canUse$pointers(it.getEnabledPointerVariants())) continue;
                    managedPlayer.getLogger().debug("Hiding {} on {}", (Object)it, (Object)this.pointer);
                    if (this.pointer.getSupportsMultipleTargets()) {
                        this.pointer.hide(it, managedPlayer.translateTarget(it));
                        continue;
                    }
                    if (it != this.previousPrimary) continue;
                    this.pointer.hide(it, managedPlayer.translateTarget(it));
                    this.previousPrimary = null;
                }
                this.hide.clear();
                Unit $i$a$-synchronized-ManagedPlayer$PlayerPointer$run$22 = Unit.INSTANCE;
            }
            if (this.scheduleKill) {
                ManagedPlayer.this.getLogger().debug("Killing Task for {}", (Object)this);
                this.getTask().cancel();
                return;
            }
            if (this.pointer.getSupportsMultipleTargets()) {
                void $this$forEach$iv;
                ManagedPlayer.this.getLogger().debug("Updating all tracked for {}", (Object)this);
                this.pointer.preUpdates();
                iterable = ManagedPlayer.this.tracked;
                managedPlayer = ManagedPlayer.this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Trackable it = (Trackable)element$iv;
                    boolean bl = false;
                    if (!this.pointer.getVariant().canUse$pointers(it.getEnabledPointerVariants())) continue;
                    Intrinsics.checkNotNull((Object)it);
                    this.pointer.update(it, managedPlayer.translateTarget(it));
                }
                this.pointer.postUpdates();
            } else {
                Object v0;
                Object element$iv;
                block14: {
                    List $this$lastOrNull$iv = ManagedPlayer.this.tracked;
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        element$iv = iterator$iv.previous();
                        Trackable it = (Trackable)element$iv;
                        boolean bl = false;
                        if (!this.pointer.getVariant().canUse$pointers(it.getEnabledPointerVariants())) continue;
                        v0 = element$iv;
                        break block14;
                    }
                    v0 = null;
                }
                Trackable primary = v0;
                boolean updatedRequired = false;
                updatedRequired = true;
                ManagedPlayer.this.getLogger().debug("Updating primary Trackable. Previous {}, current {}", (Object)this.previousPrimary, (Object)primary);
                if (this.previousPrimary != primary) {
                    Object object;
                    Trackable trackable = this.previousPrimary;
                    if (trackable != null) {
                        object = trackable;
                        element$iv = ManagedPlayer.this;
                        Trackable it = object;
                        boolean bl = false;
                        this.pointer.hide(it, ((ManagedPlayer)element$iv).translateTarget(it));
                    }
                    Trackable trackable2 = primary;
                    if (trackable2 != null) {
                        Trackable trackable3 = trackable2;
                        object = ManagedPlayer.this;
                        Trackable it = trackable3;
                        boolean bl = false;
                        this.pointer.show(it, ((ManagedPlayer)object).translateTarget(it));
                        updatedRequired = false;
                    }
                    this.previousPrimary = primary;
                }
                if (primary != null && updatedRequired) {
                    this.pointer.update(primary, ManagedPlayer.this.translateTarget(primary));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void immediateCleanup() {
            block2: {
                block1: {
                    void $this$forEach$iv;
                    ManagedPlayer.this.getLogger().debug("Performing immediate clean up");
                    if (!this.pointer.getSupportsMultipleTargets()) break block1;
                    Iterable iterable = ManagedPlayer.this.tracked;
                    ManagedPlayer managedPlayer = ManagedPlayer.this;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Trackable it = (Trackable)element$iv;
                        boolean bl = false;
                        if (!this.pointer.getVariant().canUse$pointers(it.getEnabledPointerVariants())) continue;
                        Intrinsics.checkNotNull((Object)it);
                        this.pointer.immediateCleanup(it, managedPlayer.translateTarget(it));
                    }
                    break block2;
                }
                Trackable trackable = this.previousPrimary;
                if (trackable == null) break block2;
                Trackable trackable2 = trackable;
                ManagedPlayer managedPlayer = ManagedPlayer.this;
                Trackable it = trackable2;
                boolean bl = false;
                this.pointer.immediateCleanup(it, managedPlayer.translateTarget(it));
            }
        }

        @NotNull
        public String toString() {
            return "PlayerPointer(pointer=" + this.pointer + ", task=" + this.getTask() + ")";
        }
    }
}

