/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers;

import de.md5lukas.waypoints.WaypointsPlugin;
import de.md5lukas.waypoints.lang.Translation;
import de.md5lukas.waypoints.libs.commons.paper.KyoriKt;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.util.KyoriHelperKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lde/md5lukas/waypoints/pointers/PlayerTrackable;", "Lde/md5lukas/waypoints/pointers/Trackable;", "plugin", "Lde/md5lukas/waypoints/WaypointsPlugin;", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lde/md5lukas/waypoints/WaypointsPlugin;Lorg/bukkit/entity/Player;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "location", "Lorg/bukkit/Location;", "getLocation", "()Lorg/bukkit/Location;", "getHologramText", "Lnet/kyori/adventure/text/Component;", "translatedTarget", "hologramItem", "Lorg/bukkit/inventory/ItemStack;", "getHologramItem", "()Lorg/bukkit/inventory/ItemStack;", "seed", "", "getSeed", "()J", "equals", "", "other", "", "hashCode", "", "waypoints"})
public final class PlayerTrackable
implements Trackable {
    @NotNull
    private final WaypointsPlugin plugin;
    @NotNull
    private final Player player;
    @NotNull
    private final ItemStack hologramItem;

    /*
     * WARNING - void declaration
     */
    public PlayerTrackable(@NotNull WaypointsPlugin plugin, @NotNull Player player) {
        void stack;
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.plugin = plugin;
        this.player = player;
        ItemStack itemStack2 = itemStack = new ItemStack(Material.PLAYER_HEAD);
        PlayerTrackable playerTrackable = this;
        boolean bl = false;
        stack.editMeta(arg_0 -> PlayerTrackable.hologramItem$lambda$2$lambda$1(arg_0 -> PlayerTrackable.hologramItem$lambda$2$lambda$0(this, arg_0), arg_0));
        playerTrackable.hologramItem = itemStack;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public Location getLocation() {
        Location location = this.player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        return location;
    }

    @Override
    @NotNull
    public Component getHologramText(@NotNull Player player, @NotNull Location translatedTarget) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)translatedTarget, (String)"translatedTarget");
        Translation translation = this.plugin.getTranslations().getPOINTERS_HOLOGRAM_PLAYER_TRACKING();
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        Component component = this.player.displayName();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"displayName(...)");
        spreadBuilder.add((Object)KyoriKt.placeholder("name", component));
        spreadBuilder.addSpread((Object)KyoriHelperKt.getResolvers(this.getLocation(), this.plugin, player, translatedTarget));
        return translation.withReplacements((TagResolver[])spreadBuilder.toArray((Object[])new TagResolver[spreadBuilder.size()]));
    }

    @Override
    @NotNull
    public ItemStack getHologramItem() {
        return this.hologramItem;
    }

    @Override
    public long getSeed() {
        return this.player.getUniqueId().getMostSignificantBits();
    }

    public boolean equals(@Nullable Object other) {
        PlayerTrackable playerTrackable = other instanceof PlayerTrackable ? (PlayerTrackable)other : null;
        return Intrinsics.areEqual((Object)this.player, (Object)(playerTrackable != null ? playerTrackable.player : null));
    }

    public int hashCode() {
        return this.player.hashCode();
    }

    private static final Unit hologramItem$lambda$2$lambda$0(PlayerTrackable this$0, ItemMeta it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
        SkullMeta cfr_ignored_0 = (SkullMeta)it;
        ((SkullMeta)it).setOwningPlayer((OfflinePlayer)this$0.player);
        return Unit.INSTANCE;
    }

    private static final void hologramItem$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

