/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers;

import de.md5lukas.waypoints.pointers.ManagedPlayer;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.pointers.config.PointerConfiguration;
import de.md5lukas.waypoints.pointers.variants.PointerVariant;
import de.md5lukas.waypoints.pointers.variants.TrailPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J&\u0010!\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020 0#j\u0002`$J0\u0010!\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020 0#j\u0002`$2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001e\u0010%\u001a\u00020\u00172\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020 0#j\u0002`$J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001e0'2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0015\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*H\u0001\u00a2\u0006\u0002\b+J\u0015\u0010,\u001a\u00020\u00172\u0006\u0010)\u001a\u00020-H\u0001\u00a2\u0006\u0002\b.J\u0015\u0010/\u001a\u00020\u00172\u0006\u0010)\u001a\u000200H\u0001\u00a2\u0006\u0002\b1J\u0015\u00102\u001a\u00020\u00172\u0006\u0010)\u001a\u000203H\u0001\u00a2\u0006\u0002\b4R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lde/md5lukas/waypoints/pointers/PointerManager;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "hooks", "Lde/md5lukas/waypoints/pointers/PointerManager$Hooks;", "configuration", "Lde/md5lukas/waypoints/pointers/config/PointerConfiguration;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lde/md5lukas/waypoints/pointers/PointerManager$Hooks;Lde/md5lukas/waypoints/pointers/config/PointerConfiguration;)V", "getPlugin$pointers", "()Lorg/bukkit/plugin/Plugin;", "getHooks$pointers", "()Lde/md5lukas/waypoints/pointers/PointerManager$Hooks;", "getConfiguration$pointers", "()Lde/md5lukas/waypoints/pointers/config/PointerConfiguration;", "setConfiguration$pointers", "(Lde/md5lukas/waypoints/pointers/config/PointerConfiguration;)V", "players", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lde/md5lukas/waypoints/pointers/ManagedPlayer;", "applyNewConfiguration", "", "newConfiguration", "reapplyConfiguration", "player", "Lorg/bukkit/entity/Player;", "enable", "trackable", "Lde/md5lukas/waypoints/pointers/Trackable;", "save", "", "disable", "predicate", "Lkotlin/Function1;", "Lde/md5lukas/waypoints/pointers/TrackablePredicate;", "disableAll", "getCurrentTargets", "", "onPlayerJoin", "e", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerJoin$pointers", "onQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onQuit$pointers", "onMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onMove$pointers", "onPluginDisable", "Lorg/bukkit/event/server/PluginDisableEvent;", "onPluginDisable$pointers", "Hooks", "pointers"})
@SourceDebugExtension(value={"SMAP\nPointerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointerManager.kt\nde/md5lukas/waypoints/pointers/PointerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1869#2,2:240\n774#2:242\n865#2,2:243\n1869#2,2:245\n1869#2:247\n1870#2:249\n1869#2,2:250\n1869#2,2:252\n1869#2,2:254\n1#3:248\n*S KotlinDebug\n*F\n+ 1 PointerManager.kt\nde/md5lukas/waypoints/pointers/PointerManager\n*L\n49#1:240,2\n88#1:242\n88#1:243,2\n88#1:245,2\n104#1:247\n104#1:249\n133#1:250,2\n148#1:252,2\n114#1:254,2\n*E\n"})
public final class PointerManager
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Hooks hooks;
    @NotNull
    private PointerConfiguration configuration;
    @NotNull
    private final ConcurrentHashMap<UUID, ManagedPlayer> players;

    public PointerManager(@NotNull Plugin plugin, @NotNull Hooks hooks, @NotNull PointerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)hooks, (String)"hooks");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.plugin = plugin;
        this.hooks = hooks;
        this.configuration = configuration;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        this.players = new ConcurrentHashMap();
    }

    @NotNull
    public final Plugin getPlugin$pointers() {
        return this.plugin;
    }

    @NotNull
    public final Hooks getHooks$pointers() {
        return this.hooks;
    }

    @NotNull
    public final PointerConfiguration getConfiguration$pointers() {
        return this.configuration;
    }

    public final void setConfiguration$pointers(@NotNull PointerConfiguration pointerConfiguration) {
        Intrinsics.checkNotNullParameter((Object)pointerConfiguration, (String)"<set-?>");
        this.configuration = pointerConfiguration;
    }

    public final void applyNewConfiguration(@NotNull PointerConfiguration newConfiguration) {
        Intrinsics.checkNotNullParameter((Object)newConfiguration, (String)"newConfiguration");
        this.configuration = newConfiguration;
        TrailPointer.Companion.resetPathfinder();
        Collection<ManagedPlayer> collection = this.players.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ManagedPlayer it = (ManagedPlayer)element$iv;
            boolean bl = false;
            it.reapplyConfiguration();
        }
    }

    public final void reapplyConfiguration(@NotNull Player player) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            ManagedPlayer managedPlayer = this.players.get(player.getUniqueId());
            if (managedPlayer == null) break block0;
            managedPlayer.reapplyConfiguration();
        }
    }

    public final void enable(@NotNull Player player, @NotNull Trackable trackable) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        this.enable(player, trackable, true);
    }

    private final void enable(Player player, Trackable trackable, boolean save) {
        ManagedPlayer managedPlayer = this.players.computeIfAbsent(player.getUniqueId(), arg_0 -> PointerManager.enable$lambda$2(arg_0 -> PointerManager.enable$lambda$1(this, player, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)managedPlayer, (String)"computeIfAbsent(...)");
        ManagedPlayer managedPlayer2 = managedPlayer;
        managedPlayer2.show(trackable);
        if (save) {
            this.hooks.saveActiveTrackables(player, managedPlayer2.getReadOnlyTracked());
        }
    }

    public final void disable(@NotNull Player player, @NotNull Function1<? super Trackable, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        this.disable(player, predicate, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void disable(Player player, Function1<? super Trackable, Boolean> predicate, boolean save) {
        block4: {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            ManagedPlayer managedPlayer = this.players.get(player.getUniqueId());
            if (managedPlayer == null) break block4;
            ManagedPlayer managedPlayer2 = managedPlayer;
            boolean bl = false;
            Iterable $this$filter$iv = managedPlayer2.getReadOnlyTracked();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)predicate.invoke(element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Trackable it = (Trackable)element$iv;
                boolean bl2 = false;
                managedPlayer2.hide(it);
            }
            if (save) {
                this.hooks.saveActiveTrackables(player, managedPlayer2.getReadOnlyTracked());
            }
            if (managedPlayer2.getCanBeDiscarded()) {
                Map map = this.players;
                map.remove(player.getUniqueId());
            }
        }
    }

    public final void disableAll(@NotNull Function1<? super Trackable, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Set set2 = this.players.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (this.plugin.getServer().getPlayer(uuid) == null) continue;
            boolean bl2 = false;
            this.disable(it, predicate);
        }
    }

    @NotNull
    public final Collection<Trackable> getCurrentTargets(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = this.players.get(player.getUniqueId());
        if (object == null || (object = ((ManagedPlayer)object).getReadOnlyTracked()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @EventHandler
    public final void onPlayerJoin$pointers(@NotNull PlayerJoinEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.hooks.loadActiveTrackables(player).thenAccept(arg_0 -> PointerManager.onPlayerJoin$lambda$9(arg_0 -> PointerManager.onPlayerJoin$lambda$8(this, e, arg_0), arg_0));
    }

    @EventHandler
    public final void onQuit$pointers(@NotNull PlayerQuitEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ManagedPlayer managedPlayer = this.players.remove(e.getPlayer().getUniqueId());
            if (managedPlayer == null) break block0;
            managedPlayer.immediateCleanup();
        }
    }

    @EventHandler
    public final void onMove$pointers(@NotNull PlayerMoveEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Collection<Trackable> trackables = this.getCurrentTargets(player);
        int disableWhenReachedRadius = this.configuration.getDisableWhenReachedRadiusSquared();
        if (trackables.isEmpty() || disableWhenReachedRadius == 0) {
            return;
        }
        Iterable $this$forEach$iv = trackables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            double distance;
            Trackable it = (Trackable)element$iv;
            boolean bl = false;
            if (e.getPlayer().getWorld() != it.getLocation().getWorld() || !((distance = e.getPlayer().getLocation().distanceSquared(it.getLocation())) <= (double)disableWhenReachedRadius)) continue;
            Player player2 = e.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getPlayer(...)");
            this.disable(player2, it.asPredicate());
        }
    }

    @EventHandler
    public final void onPluginDisable$pointers(@NotNull PluginDisableEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getPlugin() != this.plugin) {
            return;
        }
        Collection<ManagedPlayer> collection = this.players.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ManagedPlayer p0 = (ManagedPlayer)element$iv;
            boolean bl = false;
            p0.immediateCleanup();
        }
        this.players.clear();
    }

    private static final ManagedPlayer enable$lambda$1(PointerManager this$0, Player $player, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ManagedPlayer(this$0, $player);
    }

    private static final ManagedPlayer enable$lambda$2(Function1 $tmp0, Object p0) {
        return (ManagedPlayer)$tmp0.invoke(p0);
    }

    private static final Unit onPlayerJoin$lambda$8(PointerManager this$0, PlayerJoinEvent $e, Collection trackables) {
        Intrinsics.checkNotNull((Object)trackables);
        Iterable $this$forEach$iv = trackables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Trackable it = (Trackable)element$iv;
            boolean bl = false;
            Player player = $e.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            this$0.enable(player, it, false);
        }
        return Unit.INSTANCE;
    }

    private static final void onPlayerJoin$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u0017J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001c\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u0013\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018\u00c0\u0006\u0001"}, d2={"Lde/md5lukas/waypoints/pointers/PointerManager$Hooks;", "", "actionBarHooks", "Lde/md5lukas/waypoints/pointers/PointerManager$Hooks$ActionBar;", "getActionBarHooks", "()Lde/md5lukas/waypoints/pointers/PointerManager$Hooks$ActionBar;", "saveActiveTrackables", "", "player", "Lorg/bukkit/entity/Player;", "tracked", "", "Lde/md5lukas/waypoints/pointers/Trackable;", "loadActiveTrackables", "Ljava/util/concurrent/CompletableFuture;", "saveCompassTarget", "location", "Lorg/bukkit/Location;", "loadCompassTarget", "loadEnabledPointers", "", "Lde/md5lukas/waypoints/pointers/variants/PointerVariant;", "", "ActionBar", "pointers"})
    public static interface Hooks {
        @NotNull
        public ActionBar getActionBarHooks();

        default public void saveActiveTrackables(@NotNull Player player, @NotNull Collection<? extends Trackable> tracked) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(tracked, (String)"tracked");
        }

        @NotNull
        default public CompletableFuture<Collection<Trackable>> loadActiveTrackables(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            CompletableFuture<Collection<Trackable>> completableFuture = CompletableFuture.completedFuture(CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }

        default public void saveCompassTarget(@NotNull Player player, @NotNull Location location) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        }

        @NotNull
        default public CompletableFuture<Location> loadCompassTarget(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }

        @NotNull
        default public CompletableFuture<? extends Map<PointerVariant, Boolean>> loadEnabledPointers(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            CompletableFuture<Map> completableFuture = CompletableFuture.completedFuture(MapsKt.emptyMap());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H&J \u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lde/md5lukas/waypoints/pointers/PointerManager$Hooks$ActionBar;", "", "formatDistanceMessage", "Lnet/kyori/adventure/text/Component;", "player", "Lorg/bukkit/entity/Player;", "distance3D", "", "heightDifference", "formatWrongWorldMessage", "current", "Lorg/bukkit/World;", "correct", "pointers"})
        public static interface ActionBar {
            @NotNull
            public Component formatDistanceMessage(@NotNull Player var1, double var2, double var4);

            @NotNull
            public Component formatWrongWorldMessage(@NotNull Player var1, @NotNull World var2, @NotNull World var3);
        }
    }
}

