/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers;

import de.md5lukas.waypoints.WaypointsPlugin;
import de.md5lukas.waypoints.api.Waypoint;
import de.md5lukas.waypoints.pointers.BeaconColor;
import de.md5lukas.waypoints.pointers.StaticTrackable;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.util.APIExtensions;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006&"}, d2={"Lde/md5lukas/waypoints/pointers/WaypointTrackable;", "Lde/md5lukas/waypoints/pointers/StaticTrackable;", "plugin", "Lde/md5lukas/waypoints/WaypointsPlugin;", "waypoint", "Lde/md5lukas/waypoints/api/Waypoint;", "<init>", "(Lde/md5lukas/waypoints/WaypointsPlugin;Lde/md5lukas/waypoints/api/Waypoint;)V", "getWaypoint", "()Lde/md5lukas/waypoints/api/Waypoint;", "location", "Lorg/bukkit/Location;", "getLocation", "()Lorg/bukkit/Location;", "beaconColor", "Lde/md5lukas/waypoints/pointers/BeaconColor;", "getBeaconColor", "()Lde/md5lukas/waypoints/pointers/BeaconColor;", "getHologramText", "Lnet/kyori/adventure/text/Component;", "player", "Lorg/bukkit/entity/Player;", "translatedTarget", "hologramItem", "Lorg/bukkit/inventory/ItemStack;", "getHologramItem", "()Lorg/bukkit/inventory/ItemStack;", "seed", "", "getSeed", "()J", "equals", "", "other", "", "hashCode", "", "Extract", "waypoints"})
@SourceDebugExtension(value={"SMAP\nWaypointTrackable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaypointTrackable.kt\nde/md5lukas/waypoints/pointers/WaypointTrackable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class WaypointTrackable
implements StaticTrackable {
    @NotNull
    private final WaypointsPlugin plugin;
    @NotNull
    private final Waypoint waypoint;
    @NotNull
    private final ItemStack hologramItem;

    /*
     * WARNING - void declaration
     */
    public WaypointTrackable(@NotNull WaypointsPlugin plugin, @NotNull Waypoint waypoint) {
        void $this$hologramItem_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)waypoint, (String)"waypoint");
        this.plugin = plugin;
        this.waypoint = waypoint;
        APIExtensions aPIExtensions = this.plugin.getApiExtensions();
        WaypointTrackable waypointTrackable = this;
        boolean bl = false;
        waypointTrackable.hologramItem = $this$hologramItem_u24lambda_u242.getIconStack(this.waypoint);
    }

    @NotNull
    public final Waypoint getWaypoint() {
        return this.waypoint;
    }

    @Override
    @NotNull
    public Location getLocation() {
        return this.waypoint.getLocation();
    }

    @Override
    @Nullable
    public BeaconColor getBeaconColor() {
        BeaconColor beaconColor;
        Material material = this.waypoint.getBeaconColor();
        if (material != null) {
            Material it = material;
            boolean bl = false;
            beaconColor = BeaconColor.Companion.byMaterial(it);
        } else {
            beaconColor = null;
        }
        return beaconColor;
    }

    @Override
    @NotNull
    public Component getHologramText(@NotNull Player player, @NotNull Location translatedTarget) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)translatedTarget, (String)"translatedTarget");
        APIExtensions $this$getHologramText_u24lambda_u241 = this.plugin.getApiExtensions();
        boolean bl = false;
        TagResolver[] tagResolverArray = $this$getHologramText_u24lambda_u241.getResolvers(this.waypoint, player, translatedTarget);
        return $this$getHologramText_u24lambda_u241.getHologramTranslations(this.waypoint).withReplacements(Arrays.copyOf(tagResolverArray, tagResolverArray.length));
    }

    @Override
    @NotNull
    public ItemStack getHologramItem() {
        return this.hologramItem;
    }

    @Override
    public long getSeed() {
        return this.waypoint.getId().getMostSignificantBits();
    }

    public boolean equals(@Nullable Object other) {
        WaypointTrackable waypointTrackable = other instanceof WaypointTrackable ? (WaypointTrackable)other : null;
        return Intrinsics.areEqual((Object)this.waypoint, (Object)(waypointTrackable != null ? waypointTrackable.waypoint : null));
    }

    public int hashCode() {
        return this.waypoint.hashCode();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0002\u00a8\u0006\b"}, d2={"Lde/md5lukas/waypoints/pointers/WaypointTrackable$Extract;", "Lkotlin/Function1;", "Lde/md5lukas/waypoints/pointers/Trackable;", "Lde/md5lukas/waypoints/api/Waypoint;", "<init>", "()V", "invoke", "trackable", "waypoints"})
    public static final class Extract
    implements Function1<Trackable, Waypoint> {
        @NotNull
        public static final Extract INSTANCE = new Extract();

        private Extract() {
        }

        @Nullable
        public Waypoint invoke(@NotNull Trackable trackable) {
            Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
            WaypointTrackable waypointTrackable = trackable instanceof WaypointTrackable ? (WaypointTrackable)trackable : null;
            return waypointTrackable != null ? waypointTrackable.getWaypoint() : null;
        }
    }
}

