/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers;

import de.md5lukas.waypoints.WaypointsPlugin;
import de.md5lukas.waypoints.api.Waypoint;
import de.md5lukas.waypoints.api.WaypointsPointerManager;
import de.md5lukas.waypoints.pointers.PlayerTrackable;
import de.md5lukas.waypoints.pointers.PointerManager;
import de.md5lukas.waypoints.pointers.TemporaryWaypointTrackable;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.pointers.WaypointTrackable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lde/md5lukas/waypoints/pointers/WaypointsPointerManagerImpl;", "Lde/md5lukas/waypoints/api/WaypointsPointerManager;", "plugin", "Lde/md5lukas/waypoints/WaypointsPlugin;", "<init>", "(Lde/md5lukas/waypoints/WaypointsPlugin;)V", "realManager", "Lde/md5lukas/waypoints/pointers/PointerManager;", "getRealManager", "()Lde/md5lukas/waypoints/pointers/PointerManager;", "enable", "", "player", "Lorg/bukkit/entity/Player;", "waypoint", "Lde/md5lukas/waypoints/api/Waypoint;", "target", "Lorg/bukkit/Location;", "disable", "disableAllTemporaryWaypoints", "disableAll", "getWaypoints", "", "getTrackedPlayers", "getTemporaryWaypoints", "waypoints"})
@SourceDebugExtension(value={"SMAP\nWaypointsPointerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaypointsPointerManagerImpl.kt\nde/md5lukas/waypoints/pointers/WaypointsPointerManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1617#2,9:57\n1869#2:66\n1870#2:68\n1626#2:69\n1617#2,9:70\n1869#2:79\n1870#2:81\n1626#2:82\n1617#2,9:83\n1869#2:92\n1870#2:94\n1626#2:95\n1#3:67\n1#3:80\n1#3:93\n*S KotlinDebug\n*F\n+ 1 WaypointsPointerManagerImpl.kt\nde/md5lukas/waypoints/pointers/WaypointsPointerManagerImpl\n*L\n43#1:57,9\n43#1:66\n43#1:68\n43#1:69\n47#1:70,9\n47#1:79\n47#1:81\n47#1:82\n51#1:83,9\n51#1:92\n51#1:94\n51#1:95\n43#1:67\n47#1:80\n51#1:93\n*E\n"})
public final class WaypointsPointerManagerImpl
implements WaypointsPointerManager {
    @NotNull
    private final WaypointsPlugin plugin;

    public WaypointsPointerManagerImpl(@NotNull WaypointsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
    }

    private final PointerManager getRealManager() {
        return this.plugin.getPointerManager();
    }

    @Override
    public void enable(@NotNull Player player, @NotNull Waypoint waypoint) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)waypoint, (String)"waypoint");
        this.getRealManager().enable(player, new WaypointTrackable(this.plugin, waypoint));
    }

    @Override
    public void enable(@NotNull Player player, @NotNull Player target) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.getRealManager().enable(player, new PlayerTrackable(this.plugin, player));
    }

    @Override
    public void enable(@NotNull Player player, @NotNull Location target) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.getRealManager().enable(player, new TemporaryWaypointTrackable(this.plugin, target, null, 4, null));
    }

    @Override
    public void disable(@NotNull Player player, @NotNull Waypoint waypoint) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)waypoint, (String)"waypoint");
        this.getRealManager().disable(player, (Function1<? super Trackable, Boolean>)((Function1)arg_0 -> WaypointsPointerManagerImpl.disable$lambda$0(waypoint, arg_0)));
    }

    @Override
    public void disable(@NotNull Player player, @NotNull Player target) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.getRealManager().disable(player, (Function1<? super Trackable, Boolean>)((Function1)arg_0 -> WaypointsPointerManagerImpl.disable$lambda$1(target, arg_0)));
    }

    @Override
    public void disableAllTemporaryWaypoints(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.getRealManager().disable(player, (Function1<? super Trackable, Boolean>)((Function1)WaypointsPointerManagerImpl::disableAllTemporaryWaypoints$lambda$2));
    }

    @Override
    public void disableAll(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.getRealManager().disable(player, (Function1<? super Trackable, Boolean>)((Function1)WaypointsPointerManagerImpl::disableAll$lambda$3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Waypoint> getWaypoints(@NotNull Player player) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable iterable = this.getRealManager().getCurrentTargets(player);
        Function1 transform$iv = WaypointTrackable.Extract.INSTANCE;
        boolean $i$f$mapNotNull = false;
        void var5_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            if (transform$iv.invoke(element$iv$iv) == null) continue;
            boolean bl2 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Player> getTrackedPlayers(@NotNull Player player) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$mapNotNull$iv = this.getRealManager().getCurrentTargets(player);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Player it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Trackable it = (Trackable)element$iv$iv;
            boolean bl2 = false;
            PlayerTrackable playerTrackable = it instanceof PlayerTrackable ? (PlayerTrackable)it : null;
            if ((playerTrackable != null ? playerTrackable.getPlayer() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Location> getTemporaryWaypoints(@NotNull Player player) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$mapNotNull$iv = this.getRealManager().getCurrentTargets(player);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Location it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Trackable it = (Trackable)element$iv$iv;
            boolean bl2 = false;
            TemporaryWaypointTrackable temporaryWaypointTrackable = it instanceof TemporaryWaypointTrackable ? (TemporaryWaypointTrackable)it : null;
            if ((temporaryWaypointTrackable != null ? temporaryWaypointTrackable.getLocation() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean disable$lambda$0(Waypoint $waypoint, Trackable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof WaypointTrackable && Intrinsics.areEqual((Object)((WaypointTrackable)it).getWaypoint(), (Object)$waypoint);
    }

    private static final boolean disable$lambda$1(Player $target, Trackable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PlayerTrackable && Intrinsics.areEqual((Object)((PlayerTrackable)it).getPlayer(), (Object)$target);
    }

    private static final boolean disableAllTemporaryWaypoints$lambda$2(Trackable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof TemporaryWaypointTrackable;
    }

    private static final boolean disableAll$lambda$3(Trackable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

