/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers.path;

import de.md5lukas.waypoints.pointers.path.Pathfinder;
import de.md5lukas.waypoints.pointers.path.world.BlockPosition;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B-\b\u0000\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0000H\u0096\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lde/md5lukas/waypoints/pointers/path/Node;", "", "context", "Lde/md5lukas/waypoints/pointers/path/Pathfinder$ActivePathingContext;", "Lde/md5lukas/waypoints/pointers/path/Pathfinder;", "position", "Lde/md5lukas/waypoints/pointers/path/world/BlockPosition;", "cost", "", "parent", "(Lde/md5lukas/pathfinder/Pathfinder$ActivePathingContext;Lde/md5lukas/pathfinder/world/BlockPosition;DLde/md5lukas/pathfinder/Node;)V", "depth", "", "getDepth", "()I", "f", "getF", "()D", "g", "h", "getParent", "()Lde/md5lukas/pathfinder/Node;", "getPosition", "()Lde/md5lukas/pathfinder/world/BlockPosition;", "compareTo", "other", "retracePath", "", "Lorg/bukkit/Location;", "toString", "", "pathfinder"})
public final class Node
implements Comparable<Node> {
    @NotNull
    private final BlockPosition position;
    @Nullable
    private final Node parent;
    private final int depth;
    private final double g;
    private final double h;
    private final double f;

    public Node(@NotNull Pathfinder.ActivePathingContext context, @NotNull BlockPosition position, double cost, @Nullable Node parent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.position = position;
        Node node = this.parent = parent;
        this.depth = (node != null ? node.depth : 0) + 1;
        Node node2 = this.parent;
        this.g = (node2 != null ? node2.g : 0.0) + cost;
        this.h = this.position.octileDistance(context.getGoal());
        this.f = context.getPathfinder().getWeigher$pathfinder().calculateF(context, this.position, this.g, this.h);
    }

    @NotNull
    public final BlockPosition getPosition() {
        return this.position;
    }

    @Nullable
    public final Node getParent() {
        return this.parent;
    }

    public final int getDepth() {
        return this.depth;
    }

    public final double getF() {
        return this.f;
    }

    @Override
    public int compareTo(@NotNull Node other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (int)Math.signum(this.f - other.f);
    }

    @NotNull
    public final List<Location> retracePath() {
        Node current = this;
        List path = new ArrayList();
        while (current != null) {
            path.add(current.position.asBukkit());
            current = current.parent;
        }
        CollectionsKt.reverse((List)path);
        return path;
    }

    @NotNull
    public String toString() {
        return "Node(depth=" + this.depth + ", g=" + this.g + ", h=" + this.h + ", f=" + this.f + ")";
    }
}

