/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers.path;

import de.md5lukas.waypoints.pointers.path.ChunkInvalidationListener;
import de.md5lukas.waypoints.pointers.path.FailureReason;
import de.md5lukas.waypoints.pointers.path.Node;
import de.md5lukas.waypoints.pointers.path.PathFailure;
import de.md5lukas.waypoints.pointers.path.PathResult;
import de.md5lukas.waypoints.pointers.path.PathStatus;
import de.md5lukas.waypoints.pointers.path.PathSuccess;
import de.md5lukas.waypoints.pointers.path.PathingContext;
import de.md5lukas.waypoints.pointers.path.behaviour.BasicPlayerPathingStrategy;
import de.md5lukas.waypoints.pointers.path.behaviour.ConstantFWeigher;
import de.md5lukas.waypoints.pointers.path.behaviour.FWeigher;
import de.md5lukas.waypoints.pointers.path.behaviour.PathingStrategy;
import de.md5lukas.waypoints.pointers.path.world.BlockAccessor;
import de.md5lukas.waypoints.pointers.path.world.BlockPosition;
import de.md5lukas.waypoints.pointers.path.world.Offset;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u000289Bw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J$\u0010\"\u001a\u00020#2\n\u0010$\u001a\u00060%R\u00020\u00002\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u001c\u0010*\u001a\u00020\f2\n\u0010$\u001a\u00060%R\u00020\u00002\u0006\u0010&\u001a\u00020'H\u0002J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020)J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u0002002\u0006\u0010/\u001a\u000200J\u0014\u00101\u001a\u00020-2\n\u0010$\u001a\u00060%R\u00020\u0000H\u0002J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000203J\u0014\u00105\u001a\u000203*\u00020)2\u0006\u00106\u001a\u000207H\u0002R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\r\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006:"}, d2={"Lde/md5lukas/waypoints/pointers/path/Pathfinder;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "executor", "Ljava/util/concurrent/Executor;", "maxIterations", "", "maxLength", "pathingStrategy", "Lde/md5lukas/waypoints/pointers/path/behaviour/PathingStrategy;", "allowIncompletePathing", "", "allowChunkLoading", "allowChunkGeneration", "partialPathOnUnloadedChunks", "cacheRetention", "Ljava/time/Duration;", "weigher", "Lde/md5lukas/waypoints/pointers/path/behaviour/FWeigher;", "debugTime", "", "(Lorg/bukkit/plugin/Plugin;Ljava/util/concurrent/Executor;IILde/md5lukas/pathfinder/behaviour/PathingStrategy;ZZZZLjava/time/Duration;Lde/md5lukas/pathfinder/behaviour/FWeigher;J)V", "accessor", "Lde/md5lukas/waypoints/pointers/path/world/BlockAccessor;", "getAllowChunkGeneration$pathfinder", "()Z", "getAllowChunkLoading$pathfinder", "getCacheRetention$pathfinder", "()Ljava/time/Duration;", "invalidationListener", "Lorg/bukkit/event/Listener;", "getWeigher$pathfinder", "()Lde/md5lukas/pathfinder/behaviour/FWeigher;", "examineNewLocation", "Lde/md5lukas/waypoints/pointers/path/Pathfinder$ExaminationResult;", "context", "Lde/md5lukas/waypoints/pointers/path/Pathfinder$ActivePathingContext;", "node", "Lde/md5lukas/waypoints/pointers/path/Node;", "position", "Lde/md5lukas/waypoints/pointers/path/world/BlockPosition;", "expandNode", "findPath", "Ljava/util/concurrent/CompletableFuture;", "Lde/md5lukas/waypoints/pointers/path/PathResult;", "start", "goal", "Lorg/bukkit/Location;", "findPath0", "registerInvalidationListener", "", "unregisterListener", "broadcastBlockChange", "material", "Lorg/bukkit/Material;", "ActivePathingContext", "ExaminationResult", "pathfinder"})
@SourceDebugExtension(value={"SMAP\nPathfinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pathfinder.kt\nde/md5lukas/pathfinder/Pathfinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1#2:185\n13579#3,2:186\n1855#4,2:188\n*S KotlinDebug\n*F\n+ 1 Pathfinder.kt\nde/md5lukas/pathfinder/Pathfinder\n*L\n105#1:186,2\n158#1:188,2\n*E\n"})
public final class Pathfinder {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Executor executor;
    private final int maxIterations;
    private final int maxLength;
    @NotNull
    private final PathingStrategy pathingStrategy;
    private final boolean allowIncompletePathing;
    private final boolean allowChunkLoading;
    private final boolean allowChunkGeneration;
    private final boolean partialPathOnUnloadedChunks;
    @NotNull
    private final Duration cacheRetention;
    @NotNull
    private final FWeigher weigher;
    private final long debugTime;
    @NotNull
    private final BlockAccessor accessor;
    @Nullable
    private Listener invalidationListener;

    public Pathfinder(@NotNull Plugin plugin, @NotNull Executor executor, int maxIterations, int maxLength, @NotNull PathingStrategy pathingStrategy, boolean allowIncompletePathing, boolean allowChunkLoading, boolean allowChunkGeneration, boolean partialPathOnUnloadedChunks, @NotNull Duration cacheRetention, @NotNull FWeigher weigher, long debugTime) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)pathingStrategy, (String)"pathingStrategy");
        Intrinsics.checkNotNullParameter((Object)cacheRetention, (String)"cacheRetention");
        Intrinsics.checkNotNullParameter((Object)weigher, (String)"weigher");
        this.plugin = plugin;
        this.executor = executor;
        this.maxIterations = maxIterations;
        this.maxLength = maxLength;
        this.pathingStrategy = pathingStrategy;
        this.allowIncompletePathing = allowIncompletePathing;
        this.allowChunkLoading = allowChunkLoading;
        this.allowChunkGeneration = allowChunkGeneration;
        this.partialPathOnUnloadedChunks = partialPathOnUnloadedChunks;
        this.cacheRetention = cacheRetention;
        this.weigher = weigher;
        this.debugTime = debugTime;
        this.accessor = new BlockAccessor(this);
    }

    public /* synthetic */ Pathfinder(Plugin plugin, Executor executor, int n, int n2, PathingStrategy pathingStrategy, boolean bl, boolean bl2, boolean bl3, boolean bl4, Duration duration, FWeigher fWeigher, long l, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x10) != 0) {
            pathingStrategy = new BasicPlayerPathingStrategy(false, 1.0);
        }
        if ((n3 & 0x20) != 0) {
            bl = true;
        }
        if ((n3 & 0x40) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x80) != 0) {
            bl3 = true;
        }
        if ((n3 & 0x100) != 0) {
            bl4 = true;
        }
        if ((n3 & 0x200) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(5)");
            duration = duration2;
        }
        if ((n3 & 0x400) != 0) {
            fWeigher = new ConstantFWeigher(0.0, 1, null);
        }
        if ((n3 & 0x800) != 0) {
            l = 0L;
        }
        this(plugin, executor, n, n2, pathingStrategy, bl, bl2, bl3, bl4, duration, fWeigher, l);
    }

    public final boolean getAllowChunkLoading$pathfinder() {
        return this.allowChunkLoading;
    }

    public final boolean getAllowChunkGeneration$pathfinder() {
        return this.allowChunkGeneration;
    }

    @NotNull
    public final Duration getCacheRetention$pathfinder() {
        return this.cacheRetention;
    }

    @NotNull
    public final FWeigher getWeigher$pathfinder() {
        return this.weigher;
    }

    /*
     * WARNING - void declaration
     */
    public final void registerInvalidationListener() {
        void it;
        ChunkInvalidationListener chunkInvalidationListener;
        ChunkInvalidationListener chunkInvalidationListener2 = chunkInvalidationListener = new ChunkInvalidationListener(this.accessor);
        Pathfinder pathfinder = this;
        boolean bl = false;
        Bukkit.getPluginManager().registerEvents((Listener)it, this.plugin);
        pathfinder.invalidationListener = chunkInvalidationListener;
    }

    public final void unregisterListener() {
        block0: {
            Listener listener = this.invalidationListener;
            if (listener == null) break block0;
            Listener it = listener;
            boolean bl = false;
            HandlerList.unregisterAll((Listener)it);
        }
    }

    @NotNull
    public final CompletableFuture<PathResult> findPath(@NotNull Location start, @NotNull Location goal) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        return this.findPath(new BlockPosition(start), new BlockPosition(goal));
    }

    @NotNull
    public final CompletableFuture<PathResult> findPath(@NotNull BlockPosition start, @NotNull BlockPosition goal) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        CompletableFuture<PathResult> completableFuture = CompletableFuture.supplyAsync(() -> Pathfinder.findPath$lambda$2(this, start, goal), this.executor);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync({ findPath0(\u2026tart, goal)) }, executor)");
        return completableFuture;
    }

    private final PathResult findPath0(ActivePathingContext context) {
        context.getExaminedPositions().add(context.getStart());
        Node startNode = new Node(context, context.getStart(), 0.0, null);
        context.getFrontier().add(startNode);
        Node bestNode = startNode;
        while (!((Collection)context.getFrontier()).isEmpty()) {
            context.setIterations(context.getIterations() + 1);
            if (context.getIterations() >= this.maxIterations) break;
            if (!this.plugin.isEnabled()) {
                return new PathFailure((PathingContext)context, FailureReason.PLUGIN_DISABLED);
            }
            Node next = context.getFrontier().poll();
            if (Intrinsics.areEqual((Object)next.getPosition(), (Object)context.getGoal())) {
                return new PathSuccess(context, PathStatus.COMPLETE, next.retracePath());
            }
            if (next.getF() <= bestNode.getF()) {
                Intrinsics.checkNotNullExpressionValue((Object)next, (String)"next");
                bestNode = next;
                if (this.maxLength > 0 && bestNode.getDepth() >= this.maxLength) {
                    return new PathSuccess(context, PathStatus.PARTIAL, bestNode.retracePath());
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)next, (String)"next");
            if (!this.expandNode(context, next)) continue;
            return new PathSuccess(context, PathStatus.PARTIAL, next.retracePath());
        }
        if (this.allowIncompletePathing) {
            return new PathSuccess(context, PathStatus.INCOMPLETE, bestNode.retracePath());
        }
        return new PathFailure((PathingContext)context, context.getFrontier().isEmpty() ? FailureReason.EXHAUSTED_OPTIONS : (context.getIterations() >= this.maxIterations ? FailureReason.MAX_ITERATIONS : FailureReason.UNKNOWN));
    }

    private final boolean expandNode(ActivePathingContext context, Node node) {
        if (this.debugTime > 0L) {
            this.broadcastBlockChange(node.getPosition(), Material.GLOWSTONE);
        }
        Offset[] $this$forEach$iv = Offset.Companion.getDiagonal();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            Offset element$iv;
            Offset offset = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            if (this.examineNewLocation(context, node, node.getPosition().plus(offset)) != ExaminationResult.CHUNK_EDGE) continue;
            return true;
        }
        if (this.debugTime > 0L) {
            this.broadcastBlockChange(node.getPosition(), Material.GLASS);
        }
        return false;
    }

    private final ExaminationResult examineNewLocation(ActivePathingContext context, Node node, BlockPosition position) {
        if (context.getExaminedPositions().contains(position)) {
            return ExaminationResult.INVALID;
        }
        if (position.isOutOfBounds()) {
            return ExaminationResult.INVALID;
        }
        boolean isBlockAvailable = this.accessor.isBlockAvailable(position);
        if (!isBlockAvailable && this.partialPathOnUnloadedChunks) {
            return ExaminationResult.CHUNK_EDGE;
        }
        ((Collection)context.getExaminedPositions()).add(position);
        if (isBlockAvailable && this.pathingStrategy.isValid(this.accessor, node.getParent(), position)) {
            ((Collection)context.getFrontier()).add(new Node(context, position, this.pathingStrategy.getCost(this.accessor, node.getParent(), position) * node.getPosition().octileDistance(position), node));
            if (this.debugTime > 0L) {
                this.broadcastBlockChange(position, Material.LIME_STAINED_GLASS);
                Thread.sleep(this.debugTime);
            }
            return ExaminationResult.VALID;
        }
        if (this.debugTime > 0L) {
            this.broadcastBlockChange(position, Material.PINK_STAINED_GLASS);
            Thread.sleep(this.debugTime);
        }
        return ExaminationResult.INVALID;
    }

    private final void broadcastBlockChange(BlockPosition $this$broadcastBlockChange, Material material) {
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers()");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            it.sendBlockChange($this$broadcastBlockChange.asBukkit(), material.createBlockData());
        }
    }

    private static final PathResult findPath$lambda$2(Pathfinder this$0, BlockPosition $start, BlockPosition $goal) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$start, (String)"$start");
        Intrinsics.checkNotNullParameter((Object)$goal, (String)"$goal");
        return this$0.findPath0(this$0.new ActivePathingContext($start, $goal));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lde/md5lukas/waypoints/pointers/path/Pathfinder$ActivePathingContext;", "Lde/md5lukas/waypoints/pointers/path/PathingContext;", "start", "Lde/md5lukas/waypoints/pointers/path/world/BlockPosition;", "goal", "(Lde/md5lukas/pathfinder/Pathfinder;Lde/md5lukas/pathfinder/world/BlockPosition;Lde/md5lukas/pathfinder/world/BlockPosition;)V", "examinedPositions", "", "getExaminedPositions", "()Ljava/util/Set;", "frontier", "Ljava/util/PriorityQueue;", "Lde/md5lukas/waypoints/pointers/path/Node;", "getFrontier", "()Ljava/util/PriorityQueue;", "getGoal", "()Lde/md5lukas/pathfinder/world/BlockPosition;", "iterations", "", "getIterations", "()I", "setIterations", "(I)V", "pathfinder", "Lde/md5lukas/waypoints/pointers/path/Pathfinder;", "getPathfinder", "()Lde/md5lukas/pathfinder/Pathfinder;", "getStart", "toString", ""})
    public final class ActivePathingContext
    implements PathingContext {
        @NotNull
        private final BlockPosition start;
        @NotNull
        private final BlockPosition goal;
        @NotNull
        private final Set<BlockPosition> examinedPositions;
        @NotNull
        private final PriorityQueue<Node> frontier;
        private int iterations;

        public ActivePathingContext(@NotNull BlockPosition start, BlockPosition goal) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
            this.start = start;
            this.goal = goal;
            this.examinedPositions = new HashSet();
            this.frontier = new PriorityQueue();
        }

        @Override
        @NotNull
        public BlockPosition getStart() {
            return this.start;
        }

        @Override
        @NotNull
        public BlockPosition getGoal() {
            return this.goal;
        }

        @NotNull
        public final Pathfinder getPathfinder() {
            return Pathfinder.this;
        }

        @Override
        @NotNull
        public Set<BlockPosition> getExaminedPositions() {
            return this.examinedPositions;
        }

        @NotNull
        public final PriorityQueue<Node> getFrontier() {
            return this.frontier;
        }

        @Override
        public int getIterations() {
            return this.iterations;
        }

        public void setIterations(int n) {
            this.iterations = n;
        }

        @NotNull
        public String toString() {
            return "ActivePathingContext(start=" + this.getStart() + ", goal=" + this.getGoal() + ", examinedPositionsN=" + this.getExaminedPositions().size() + ", frontierN=" + this.frontier.size() + ", iterations=" + this.getIterations() + ")";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lde/md5lukas/waypoints/pointers/path/Pathfinder$ExaminationResult;", "", "(Ljava/lang/String;I)V", "VALID", "INVALID", "CHUNK_EDGE", "pathfinder"})
    private static final class ExaminationResult
    extends Enum<ExaminationResult> {
        public static final /* enum */ ExaminationResult VALID = new ExaminationResult();
        public static final /* enum */ ExaminationResult INVALID = new ExaminationResult();
        public static final /* enum */ ExaminationResult CHUNK_EDGE = new ExaminationResult();
        private static final /* synthetic */ ExaminationResult[] $VALUES;

        public static ExaminationResult[] values() {
            return (ExaminationResult[])$VALUES.clone();
        }

        public static ExaminationResult valueOf(String value) {
            return Enum.valueOf(ExaminationResult.class, value);
        }

        static {
            $VALUES = examinationResultArray = new ExaminationResult[]{ExaminationResult.VALID, ExaminationResult.INVALID, ExaminationResult.CHUNK_EDGE};
        }
    }
}

