/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers.path.behaviour;

import de.md5lukas.waypoints.pointers.path.Node;
import de.md5lukas.waypoints.pointers.path.behaviour.PathingStrategy;
import de.md5lukas.waypoints.pointers.path.world.BlockAccessor;
import de.md5lukas.waypoints.pointers.path.world.BlockPosition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/md5lukas/waypoints/pointers/path/behaviour/BasicPlayerPathingStrategy;", "Lde/md5lukas/waypoints/pointers/path/behaviour/PathingStrategy;", "allowSwimming", "", "swimmingPenalty", "", "(ZD)V", "getCost", "accessor", "Lde/md5lukas/waypoints/pointers/path/world/BlockAccessor;", "previousNode", "Lde/md5lukas/waypoints/pointers/path/Node;", "position", "Lde/md5lukas/waypoints/pointers/path/world/BlockPosition;", "isValid", "pathfinder"})
public final class BasicPlayerPathingStrategy
implements PathingStrategy {
    private boolean allowSwimming;
    private double swimmingPenalty;

    public BasicPlayerPathingStrategy(boolean allowSwimming, double swimmingPenalty) {
        this.allowSwimming = allowSwimming;
        this.swimmingPenalty = swimmingPenalty;
    }

    @Override
    public boolean isValid(@NotNull BlockAccessor accessor, @Nullable Node previousNode, @NotNull BlockPosition position) {
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (!PathingStrategy.Companion.fitsPlayer(accessor, position)) {
            return false;
        }
        Material ground = accessor.getBlock(position.plus(0, -1, 0));
        if (ground == null) {
            return false;
        }
        return this.allowSwimming && ground == Material.WATER || PathingStrategy.Companion.isValidGround(ground);
    }

    @Override
    public double getCost(@NotNull BlockAccessor accessor, @Nullable Node previousNode, @NotNull BlockPosition position) {
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        double baseCost = PathingStrategy.super.getCost(accessor, previousNode, position);
        if (this.allowSwimming && accessor.getBlock(position.plus(0, -1, 0)) == Material.WATER) {
            return baseCost * this.swimmingPenalty;
        }
        return baseCost;
    }
}

