/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers.path.world;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import de.md5lukas.waypoints.pointers.path.Pathfinder;
import de.md5lukas.waypoints.pointers.path.world.BlockPosition;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tJ\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0002"}, d2={"Lde/md5lukas/waypoints/pointers/path/world/BlockAccessor;", "", "pathfinder", "Lde/md5lukas/waypoints/pointers/path/Pathfinder;", "(Lde/md5lukas/pathfinder/Pathfinder;)V", "worlds", "Lcom/google/common/cache/LoadingCache;", "Ljava/util/UUID;", "Lcom/google/common/cache/Cache;", "", "Lorg/bukkit/ChunkSnapshot;", "canLoadChunk", "", "position", "Lde/md5lukas/waypoints/pointers/path/world/BlockPosition;", "getBlock", "Lorg/bukkit/Material;", "getChunkSnapshot", "invalidate", "", "world", "Lorg/bukkit/World;", "chunkKey", "isBlockAvailable"})
public final class BlockAccessor {
    @NotNull
    private final Pathfinder pathfinder;
    @NotNull
    private final LoadingCache<UUID, Cache<Long, ChunkSnapshot>> worlds;

    public BlockAccessor(@NotNull Pathfinder pathfinder) {
        Intrinsics.checkNotNullParameter((Object)pathfinder, (String)"pathfinder");
        this.pathfinder = pathfinder;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterAccess(this.pathfinder.getCacheRetention$pathfinder());
        LoadingCache loadingCache = cacheBuilder.build((CacheLoader)new CacheLoader<UUID, Cache<Long, ChunkSnapshot>>((CacheBuilder<Object, Object>)cacheBuilder){
            final /* synthetic */ CacheBuilder<Object, Object> $cacheBuilder;
            {
                this.$cacheBuilder = $cacheBuilder;
            }

            @NotNull
            public Cache<Long, ChunkSnapshot> load(@NotNull UUID key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Cache cache = this.$cacheBuilder.build();
                Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"cacheBuilder.build()");
                return cache;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"cacheBuilder.build(\n    \u2026er.build()\n            })");
        this.worlds = loadingCache;
    }

    public final boolean isBlockAvailable(@NotNull BlockPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return ((Cache)this.worlds.get((Object)position.getWorld().getUID())).asMap().containsKey(position.getChunkKey()) || this.canLoadChunk(position);
    }

    @Nullable
    public final Material getBlock(@NotNull BlockPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (position.isOutOfBounds()) {
            return Material.VOID_AIR;
        }
        ChunkSnapshot chunkSnapshot = this.getChunkSnapshot(position);
        return chunkSnapshot != null ? chunkSnapshot.getBlockType(position.getChunkLocalX(), position.getY(), position.getChunkLocalZ()) : null;
    }

    public final void invalidate(@NotNull World world, long chunkKey) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Cache cache = (Cache)this.worlds.getIfPresent((Object)world.getUID());
            if (cache == null) break block0;
            cache.invalidate((Object)chunkKey);
        }
    }

    private final ChunkSnapshot getChunkSnapshot(BlockPosition position) {
        Cache worldCache = (Cache)this.worlds.get((Object)position.getWorld().getUID());
        return this.canLoadChunk(position) ? (ChunkSnapshot)worldCache.get((Object)position.getChunkKey(), () -> BlockAccessor.getChunkSnapshot$lambda$0(position)) : (ChunkSnapshot)worldCache.getIfPresent((Object)position.getChunkKey());
    }

    private final boolean canLoadChunk(BlockPosition position) {
        return !(!this.pathfinder.getAllowChunkLoading$pathfinder() && !position.getWorld().isChunkLoaded(position.getChunkX(), position.getChunkZ()) || !this.pathfinder.getAllowChunkGeneration$pathfinder() && !position.getWorld().isChunkGenerated(position.getChunkX(), position.getChunkZ()));
    }

    private static final ChunkSnapshot getChunkSnapshot$lambda$0(BlockPosition $position) {
        Intrinsics.checkNotNullParameter((Object)$position, (String)"$position");
        return ((Chunk)$position.getWorld().getChunkAtAsyncUrgently($position.getChunkX(), $position.getChunkZ()).join()).getChunkSnapshot(false, false, false);
    }
}

