/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers.path.world;

import de.md5lukas.waypoints.pointers.path.world.Offset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 02\u00020\u0001:\u00010B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u001e\u001a\u00020\u0003J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\"\u001a\u00020\u0006H\u0016J\u0006\u0010#\u001a\u00020 J \u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0011\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\u0000J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020&H\u0086\u0002J\u001e\u0010)\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0006J\b\u0010.\u001a\u00020/H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012\u00a8\u00061"}, d2={"Lde/md5lukas/waypoints/pointers/path/world/BlockPosition;", "", "bukkitLocation", "Lorg/bukkit/Location;", "(Lorg/bukkit/Location;)V", "x", "", "y", "z", "world", "Lorg/bukkit/World;", "(IIILorg/bukkit/World;)V", "chunkKey", "", "getChunkKey", "()J", "chunkLocalX", "getChunkLocalX", "()I", "chunkLocalZ", "getChunkLocalZ", "chunkX", "getChunkX", "chunkZ", "getChunkZ", "getWorld", "()Lorg/bukkit/World;", "getX", "getY", "getZ", "asBukkit", "equals", "", "other", "hashCode", "isOutOfBounds", "medianOf", "minus", "Lde/md5lukas/waypoints/pointers/path/world/Offset;", "octileDistance", "", "plus", "offset", "dx", "dy", "dz", "toString", "", "Companion", "pathfinder"})
public final class BlockPosition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    private final int z;
    @NotNull
    private final World world;
    private final int chunkLocalX;
    private final int chunkLocalZ;
    private final int chunkX;
    private final int chunkZ;
    private final long chunkKey;
    public static final double octileD1 = 1.0;
    private static final double octileD2 = Math.sqrt(2.0);
    private static final double octileD3 = Math.sqrt(3.0);

    public BlockPosition(int x, int y, int z, @NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
        this.chunkLocalX = this.x & 0xF;
        this.chunkLocalZ = this.z & 0xF;
        this.chunkX = this.x >> 4;
        this.chunkZ = this.z >> 4;
        this.chunkKey = Companion.getChunkKey(this.chunkX, this.chunkZ);
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    public BlockPosition(@NotNull Location bukkitLocation) {
        Intrinsics.checkNotNullParameter((Object)bukkitLocation, (String)"bukkitLocation");
        int n = bukkitLocation.getBlockX();
        int n2 = bukkitLocation.getBlockY();
        int n3 = bukkitLocation.getBlockZ();
        World world = bukkitLocation.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"bukkitLocation.world");
        this(n, n2, n3, world);
    }

    public final int getChunkLocalX() {
        return this.chunkLocalX;
    }

    public final int getChunkLocalZ() {
        return this.chunkLocalZ;
    }

    public final int getChunkX() {
        return this.chunkX;
    }

    public final int getChunkZ() {
        return this.chunkZ;
    }

    public final long getChunkKey() {
        return this.chunkKey;
    }

    @NotNull
    public final Location asBukkit() {
        return new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
    }

    public final double octileDistance(@NotNull BlockPosition other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)this.world, (Object)other.world)) {
            throw new IllegalArgumentException("Locations must be in the same world");
        }
        int dx = Math.abs(this.x - other.x);
        int dy = Math.abs(this.y - other.y);
        int dz = Math.abs(this.z - other.z);
        int min = Math.min(dx, Math.min(dy, dz));
        int median = this.medianOf(dx, dy, dz);
        int max = Math.max(dx, Math.max(dy, dz));
        return 1.0 * (double)max + (octileD2 - 1.0) * (double)median + (octileD3 - octileD2) * (double)min;
    }

    public final boolean isOutOfBounds() {
        int n = this.world.getMinHeight();
        int n2 = this.world.getMaxHeight();
        int n3 = this.y;
        return !(n <= n3 ? n3 < n2 : false);
    }

    @NotNull
    public final BlockPosition plus(@NotNull Offset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return this.plus(offset.getX(), offset.getY(), offset.getZ());
    }

    @NotNull
    public final BlockPosition plus(int dx, int dy, int dz) {
        return new BlockPosition(this.x + dx, this.y + dy, this.z + dz, this.world);
    }

    @NotNull
    public final Offset minus(@NotNull BlockPosition other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Offset(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type de.md5lukas.pathfinder.world.BlockPosition");
        BlockPosition cfr_ignored_0 = (BlockPosition)other;
        if (this.x != ((BlockPosition)other).x) {
            return false;
        }
        if (this.y != ((BlockPosition)other).y) {
            return false;
        }
        if (this.z != ((BlockPosition)other).z) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.world, (Object)((BlockPosition)other).world);
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        result = 31 * result + this.world.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "PathLocation(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", world=" + this.world + ")";
    }

    private final int medianOf(int x, int y, int z) {
        return Math.max(Math.min(x, y), Math.min(Math.max(x, y), z));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/md5lukas/waypoints/pointers/path/world/BlockPosition$Companion;", "", "()V", "octileD1", "", "octileD2", "octileD3", "getChunkKey", "", "chunkX", "", "chunkZ", "pathfinder"})
    public static final class Companion {
        private Companion() {
        }

        public final long getChunkKey(int chunkX, int chunkZ) {
            return (long)chunkX & 0xFFFFFFFFL | (long)chunkZ << 32;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

