/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers.variants;

import de.md5lukas.waypoints.libs.schedulers.AbstractScheduler;
import de.md5lukas.waypoints.pointers.Pointer;
import de.md5lukas.waypoints.pointers.PointerManager;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.pointers.config.ActionBarConfiguration;
import de.md5lukas.waypoints.pointers.variants.PointerVariant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006#"}, d2={"Lde/md5lukas/waypoints/pointers/variants/ActionBarPointer;", "Lde/md5lukas/waypoints/pointers/Pointer;", "pointerManager", "Lde/md5lukas/waypoints/pointers/PointerManager;", "player", "Lorg/bukkit/entity/Player;", "scheduler", "Lde/md5lukas/waypoints/libs/schedulers/AbstractScheduler;", "<init>", "(Lde/md5lukas/waypoints/pointers/PointerManager;Lorg/bukkit/entity/Player;Lde/md5lukas/schedulers/AbstractScheduler;)V", "config", "Lde/md5lukas/waypoints/pointers/config/ActionBarConfiguration;", "interval", "", "getInterval", "()I", "supportsMultipleTargets", "", "getSupportsMultipleTargets", "()Z", "async", "getAsync", "update", "", "trackable", "Lde/md5lukas/waypoints/pointers/Trackable;", "translatedTarget", "Lorg/bukkit/Location;", "generateDirectionIndicator", "Lnet/kyori/adventure/text/Component;", "angle", "", "deltaAngleToTarget", "location", "target", "pointers"})
@SourceDebugExtension(value={"SMAP\nActionBarPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionBarPointer.kt\nde/md5lukas/waypoints/pointers/variants/ActionBarPointer\n+ 2 Kyori.kt\nde/md5lukas/waypoints/pointers/util/KyoriKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n7#2:123\n7#2:125\n7#2:127\n7#2:129\n7#2:131\n7#2:133\n7#2:135\n1#3:124\n1#3:126\n1#3:128\n1#3:130\n1#3:132\n1#3:134\n1#3:136\n*S KotlinDebug\n*F\n+ 1 ActionBarPointer.kt\nde/md5lukas/waypoints/pointers/variants/ActionBarPointer\n*L\n51#1:123\n55#1:125\n62#1:127\n66#1:129\n79#1:131\n83#1:133\n88#1:135\n51#1:124\n55#1:126\n62#1:128\n66#1:130\n79#1:132\n83#1:134\n88#1:136\n*E\n"})
public final class ActionBarPointer
extends Pointer {
    @NotNull
    private final ActionBarConfiguration config;

    public ActionBarPointer(@NotNull PointerManager pointerManager, @NotNull Player player, @NotNull AbstractScheduler scheduler) {
        Intrinsics.checkNotNullParameter((Object)pointerManager, (String)"pointerManager");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        super(pointerManager, player, scheduler, PointerVariant.ACTION_BAR);
        this.config = pointerManager.getConfiguration$pointers().getActionBar();
    }

    @Override
    public int getInterval() {
        return this.config.getInterval();
    }

    @Override
    public boolean getSupportsMultipleTargets() {
        return false;
    }

    @Override
    public boolean getAsync() {
        return true;
    }

    @Override
    public void update(@NotNull Trackable trackable, @Nullable Location translatedTarget) {
        Component component;
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        Location location = this.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Location playerLocation = location;
        Player player = this.getPlayer();
        if (translatedTarget != null) {
            component = this.config.getShowDistanceEnabled() && this.getPlayer().isSneaking() ? this.getPointerManager().getHooks$pointers().getActionBarHooks().formatDistanceMessage(this.getPlayer(), playerLocation.distance(translatedTarget), playerLocation.getY() - trackable.getLocation().getY()) : this.generateDirectionIndicator(this.deltaAngleToTarget(playerLocation, translatedTarget));
        } else {
            PointerManager.Hooks.ActionBar actionBar = this.getPointerManager().getHooks$pointers().getActionBarHooks();
            Player player2 = this.getPlayer();
            World world = this.getPlayer().getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
            World world2 = trackable.getLocation().getWorld();
            Intrinsics.checkNotNull((Object)world2);
            component = actionBar.formatWrongWorldMessage(player2, world, world2);
        }
        player.sendActionBar(component);
    }

    /*
     * WARNING - void declaration
     */
    private final Component generateDirectionIndicator(double angle) {
        void $this$generateDirectionIndicator_u24lambda_u246_u24lambda_u245;
        TextComponent.Builder $this$generateDirectionIndicator_u24lambda_u246_u24lambda_u244;
        TextComponent.Builder builder2;
        TextComponent.Builder builder3;
        if (angle > (double)this.config.getRange()) {
            void $this$generateDirectionIndicator_u24lambda_u241_u24lambda_u240;
            TextComponent.Builder builder4;
            TextComponent.Builder builder5;
            boolean $i$f$textComponent = false;
            TextComponent.Builder it$iv = builder5 = Component.text();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it$iv);
            TextComponent.Builder $this$generateDirectionIndicator_u24lambda_u241 = it$iv;
            boolean bl2 = false;
            $this$generateDirectionIndicator_u24lambda_u241.style(this.config.getIndicatorColor());
            $this$generateDirectionIndicator_u24lambda_u241.content(this.config.getLeftArrow());
            boolean $i$f$textComponent2 = false;
            TextComponent.Builder it$iv2 = builder4 = Component.text();
            $i$a$-also-KyoriKt$textComponent$1$iv = false;
            Intrinsics.checkNotNull((Object)it$iv2);
            TextComponent.Builder builder6 = it$iv2;
            TextComponent.Builder builder7 = $this$generateDirectionIndicator_u24lambda_u241;
            boolean bl3 = false;
            $this$generateDirectionIndicator_u24lambda_u241_u24lambda_u240.style(this.config.getNormalColor());
            $this$generateDirectionIndicator_u24lambda_u241_u24lambda_u240.content(StringsKt.repeat((CharSequence)this.config.getSection(), (int)this.config.getAmountOfSections()) + this.config.getRightArrow());
            BuildableComponent buildableComponent = builder4.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
            builder7.append((Component)((TextComponent)buildableComponent));
            BuildableComponent buildableComponent2 = builder5.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent2, (String)"build(...)");
            return (Component)((TextComponent)buildableComponent2);
        }
        if (-angle > (double)this.config.getRange()) {
            void $this$generateDirectionIndicator_u24lambda_u243_u24lambda_u242;
            TextComponent.Builder builder8;
            TextComponent.Builder builder9;
            boolean $i$f$textComponent = false;
            TextComponent.Builder it$iv = builder9 = Component.text();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it$iv);
            TextComponent.Builder $this$generateDirectionIndicator_u24lambda_u243 = it$iv;
            boolean bl4 = false;
            $this$generateDirectionIndicator_u24lambda_u243.style(this.config.getNormalColor());
            $this$generateDirectionIndicator_u24lambda_u243.content(this.config.getLeftArrow() + StringsKt.repeat((CharSequence)this.config.getSection(), (int)this.config.getAmountOfSections()));
            boolean $i$f$textComponent3 = false;
            TextComponent.Builder it$iv3 = builder8 = Component.text();
            $i$a$-also-KyoriKt$textComponent$1$iv = false;
            Intrinsics.checkNotNull((Object)it$iv3);
            TextComponent.Builder $this$generateDirectionIndicator_u24lambda_u241_u24lambda_u240 = it$iv3;
            TextComponent.Builder builder10 = $this$generateDirectionIndicator_u24lambda_u243;
            boolean bl5 = false;
            $this$generateDirectionIndicator_u24lambda_u243_u24lambda_u242.style(this.config.getIndicatorColor());
            $this$generateDirectionIndicator_u24lambda_u243_u24lambda_u242.content(this.config.getRightArrow());
            BuildableComponent buildableComponent = builder8.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
            builder10.append((Component)((TextComponent)buildableComponent));
            BuildableComponent buildableComponent3 = builder9.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent3, (String)"build(...)");
            return (Component)((TextComponent)buildableComponent3);
        }
        double percent = -(angle / (double)this.config.getRange());
        int nthSection = 0;
        nthSection = MathKt.roundToInt((double)((double)(this.config.getAmountOfSections() - 1) / (double)2 * percent));
        nthSection += MathKt.roundToInt((double)((double)this.config.getAmountOfSections() / (double)2));
        boolean $i$f$textComponent = false;
        TextComponent.Builder it$iv = builder3 = Component.text();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it$iv);
        TextComponent.Builder $this$generateDirectionIndicator_u24lambda_u246 = it$iv;
        boolean bl6 = false;
        $this$generateDirectionIndicator_u24lambda_u246.style(this.config.getNormalColor());
        $this$generateDirectionIndicator_u24lambda_u246.content(this.config.getLeftArrow() + StringsKt.repeat((CharSequence)this.config.getSection(), (int)(nthSection - 1)));
        boolean $i$f$textComponent4 = false;
        TextComponent.Builder it$iv4 = builder2 = Component.text();
        $i$a$-also-KyoriKt$textComponent$1$iv = false;
        Intrinsics.checkNotNull((Object)it$iv4);
        TextComponent.Builder builder11 = it$iv4;
        TextComponent.Builder builder12 = $this$generateDirectionIndicator_u24lambda_u246;
        boolean bl7 = false;
        $this$generateDirectionIndicator_u24lambda_u246_u24lambda_u244.style(this.config.getIndicatorColor());
        $this$generateDirectionIndicator_u24lambda_u246_u24lambda_u244.content(this.config.getSection());
        BuildableComponent buildableComponent = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
        builder12.append((Component)((TextComponent)buildableComponent));
        $i$f$textComponent4 = false;
        it$iv4 = builder2 = Component.text();
        $i$a$-also-KyoriKt$textComponent$1$iv = false;
        Intrinsics.checkNotNull((Object)it$iv4);
        $this$generateDirectionIndicator_u24lambda_u246_u24lambda_u244 = it$iv4;
        builder12 = $this$generateDirectionIndicator_u24lambda_u246;
        boolean bl8 = false;
        $this$generateDirectionIndicator_u24lambda_u246_u24lambda_u245.content(StringsKt.repeat((CharSequence)this.config.getSection(), (int)(this.config.getAmountOfSections() - nthSection)) + this.config.getRightArrow());
        BuildableComponent buildableComponent4 = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)buildableComponent4, (String)"build(...)");
        builder12.append((Component)((TextComponent)buildableComponent4));
        BuildableComponent buildableComponent5 = builder3.build();
        Intrinsics.checkNotNullExpressionValue((Object)buildableComponent5, (String)"build(...)");
        return (Component)((TextComponent)buildableComponent5);
    }

    private final double deltaAngleToTarget(Location location, Location target) {
        double angle;
        for (double playerAngle = (double)(location.getYaw() + (float)90); playerAngle < 0.0; playerAngle += 360.0) {
        }
        for (angle = playerAngle - (double)de.md5lukas.waypoints.pointers.util.MathKt.getAngleToTarget(location, target) + (double)180; angle > 360.0; angle -= 360.0) {
        }
        if (angle > 180.0) {
            angle = -((double)360 - angle);
        }
        return angle;
    }
}

