/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers.variants;

import de.md5lukas.waypoints.libs.schedulers.AbstractScheduler;
import de.md5lukas.waypoints.pointers.BeaconColor;
import de.md5lukas.waypoints.pointers.Pointer;
import de.md5lukas.waypoints.pointers.PointerManager;
import de.md5lukas.waypoints.pointers.StaticTrackable;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.pointers.config.BeaconConfiguration;
import de.md5lukas.waypoints.pointers.util.SpigotKt;
import de.md5lukas.waypoints.pointers.variants.PointerVariant;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0016J\u001a\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0016J\u001a\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\u001aH\u0002J \u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0011H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/md5lukas/waypoints/pointers/variants/BeaconPointer;", "Lde/md5lukas/waypoints/pointers/Pointer;", "pointerManager", "Lde/md5lukas/waypoints/pointers/PointerManager;", "player", "Lorg/bukkit/entity/Player;", "scheduler", "Lde/md5lukas/waypoints/libs/schedulers/AbstractScheduler;", "<init>", "(Lde/md5lukas/waypoints/pointers/PointerManager;Lorg/bukkit/entity/Player;Lde/md5lukas/schedulers/AbstractScheduler;)V", "config", "Lde/md5lukas/waypoints/pointers/config/BeaconConfiguration;", "interval", "", "getInterval", "()I", "supportsMultipleTargets", "", "getSupportsMultipleTargets", "()Z", "beacon", "Lorg/bukkit/block/data/BlockData;", "Lorg/jetbrains/annotations/NotNull;", "activeBeacons", "", "Lde/md5lukas/waypoints/pointers/Trackable;", "Lorg/bukkit/Location;", "update", "", "trackable", "translatedTarget", "hide", "hide0", "lastBeaconPosition", "sendBeacon", "beaconBase", "create", "pointers"})
public final class BeaconPointer
extends Pointer {
    @NotNull
    private final BeaconConfiguration config;
    @NotNull
    private final BlockData beacon;
    @NotNull
    private final Map<Trackable, Location> activeBeacons;

    public BeaconPointer(@NotNull PointerManager pointerManager, @NotNull Player player, @NotNull AbstractScheduler scheduler) {
        Intrinsics.checkNotNullParameter((Object)pointerManager, (String)"pointerManager");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        super(pointerManager, player, scheduler, PointerVariant.BEACON);
        this.config = pointerManager.getConfiguration$pointers().getBeacon();
        BlockData blockData = Material.BEACON.createBlockData();
        Intrinsics.checkNotNullExpressionValue((Object)blockData, (String)"createBlockData(...)");
        this.beacon = blockData;
        this.activeBeacons = new HashMap();
    }

    @Override
    public int getInterval() {
        return this.config.getInterval();
    }

    @Override
    public boolean getSupportsMultipleTargets() {
        return true;
    }

    @Override
    public void update(@NotNull Trackable trackable, @Nullable Location translatedTarget) {
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        if (!(trackable instanceof StaticTrackable)) {
            return;
        }
        if (translatedTarget != null) {
            double distance = this.getPlayer().getLocation().distanceSquared(translatedTarget);
            if (distance >= (double)this.config.getMinDistanceSquared() && distance < (double)this.config.getMaxDistanceSquared()) {
                Location location = SpigotKt.getHighestBlock(translatedTarget).getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
                Location beaconBase = location;
                Location lastBeaconPosition = this.activeBeacons.get(trackable);
                if (lastBeaconPosition != null && !SpigotKt.blockEquals(lastBeaconPosition, beaconBase)) {
                    this.hide0(trackable, lastBeaconPosition);
                }
                this.activeBeacons.put(trackable, beaconBase);
                this.sendBeacon(beaconBase, trackable, true);
            } else {
                this.hide(trackable, translatedTarget);
            }
        }
    }

    @Override
    public void hide(@NotNull Trackable trackable, @Nullable Location translatedTarget) {
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        if (!(trackable instanceof StaticTrackable)) {
            return;
        }
        this.hide0(trackable, this.activeBeacons.remove(trackable));
    }

    private final void hide0(Trackable trackable, Location lastBeaconPosition) {
        if (lastBeaconPosition != null && Intrinsics.areEqual((Object)this.getPlayer().getWorld(), (Object)lastBeaconPosition.getWorld())) {
            this.sendBeacon(lastBeaconPosition, trackable, false);
        }
    }

    private final void sendBeacon(Location beaconBase, Trackable trackable, boolean create) {
        Location location = beaconBase.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
        Location loc = location;
        World world = loc.getWorld();
        Intrinsics.checkNotNull((Object)world);
        World world2 = world;
        loc.setY((double)Math.max(loc.getBlockY(), world2.getMinHeight() + 2));
        if (create) {
            Player player = this.getPlayer();
            Object object = trackable instanceof StaticTrackable ? (StaticTrackable)trackable : null;
            if ((object == null || (object = object.getBeaconColor()) == null) && (object = this.config.getDefaultColor(trackable)) == null) {
                object = BeaconColor.CLEAR;
            }
            player.sendBlockChange(loc, ((BeaconColor)((Object)object)).getBlockData());
        } else {
            SpigotKt.sendActualBlock(this.getPlayer(), loc);
        }
        double d = loc.getY();
        loc.setY(d + -1.0);
        if (create) {
            this.getPlayer().sendBlockChange(loc, this.beacon);
        } else {
            SpigotKt.sendActualBlock(this.getPlayer(), loc);
        }
        d = loc.getY();
        loc.setY(d + -1.0);
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                loc.add((double)x, 0.0, (double)z);
                if (create) {
                    this.getPlayer().sendBlockChange(loc, this.config.getBaseBlock());
                } else {
                    SpigotKt.sendActualBlock(this.getPlayer(), loc);
                }
                loc.subtract((double)x, 0.0, (double)z);
            }
        }
    }
}

