/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers.variants;

import de.md5lukas.waypoints.libs.schedulers.AbstractScheduler;
import de.md5lukas.waypoints.pointers.Pointer;
import de.md5lukas.waypoints.pointers.PointerManager;
import de.md5lukas.waypoints.pointers.StaticTrackable;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.pointers.config.BlinkingBlockConfiguration;
import de.md5lukas.waypoints.pointers.util.SpigotKt;
import de.md5lukas.waypoints.pointers.variants.PointerVariant;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u0018H\u0016J\u001a\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u0018H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/md5lukas/waypoints/pointers/variants/BlinkingBlockPointer;", "Lde/md5lukas/waypoints/pointers/Pointer;", "pointerManager", "Lde/md5lukas/waypoints/pointers/PointerManager;", "player", "Lorg/bukkit/entity/Player;", "scheduler", "Lde/md5lukas/waypoints/libs/schedulers/AbstractScheduler;", "<init>", "(Lde/md5lukas/waypoints/pointers/PointerManager;Lorg/bukkit/entity/Player;Lde/md5lukas/schedulers/AbstractScheduler;)V", "config", "Lde/md5lukas/waypoints/pointers/config/BlinkingBlockConfiguration;", "interval", "", "getInterval", "()I", "supportsMultipleTargets", "", "getSupportsMultipleTargets", "()Z", "counters", "", "Lde/md5lukas/waypoints/pointers/Trackable;", "lastLocations", "Lorg/bukkit/Location;", "update", "", "trackable", "translatedTarget", "hide", "pointers"})
public final class BlinkingBlockPointer
extends Pointer {
    @NotNull
    private final BlinkingBlockConfiguration config;
    @NotNull
    private final Map<Trackable, Integer> counters;
    @NotNull
    private final Map<Trackable, Location> lastLocations;

    public BlinkingBlockPointer(@NotNull PointerManager pointerManager, @NotNull Player player, @NotNull AbstractScheduler scheduler) {
        Intrinsics.checkNotNullParameter((Object)pointerManager, (String)"pointerManager");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        super(pointerManager, player, scheduler, PointerVariant.BLINKING_BLOCK);
        this.config = pointerManager.getConfiguration$pointers().getBlinkingBlock();
        this.counters = new HashMap();
        this.lastLocations = new HashMap();
    }

    @Override
    public int getInterval() {
        return this.config.getInterval();
    }

    @Override
    public boolean getSupportsMultipleTargets() {
        return true;
    }

    @Override
    public void update(@NotNull Trackable trackable, @Nullable Location translatedTarget) {
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        if (!(trackable instanceof StaticTrackable)) {
            return;
        }
        if (translatedTarget != null) {
            double distance = this.getPlayer().getLocation().distanceSquared(translatedTarget);
            if (distance >= (double)this.config.getMinDistanceSquared() && distance < (double)this.config.getMaxDistanceSquared()) {
                Integer n = this.counters.compute(trackable, (arg_0, arg_1) -> BlinkingBlockPointer.update$lambda$1((arg_0, arg_1) -> BlinkingBlockPointer.update$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
                Intrinsics.checkNotNull((Object)n);
                int currentCounter = ((Number)n).intValue();
                this.lastLocations.put(trackable, translatedTarget);
                this.getPlayer().sendBlockChange(translatedTarget, this.config.getBlockDataSequence()[currentCounter]);
            } else {
                this.hide(trackable, translatedTarget);
            }
        } else {
            this.hide(trackable, null);
        }
    }

    @Override
    public void hide(@NotNull Trackable trackable, @Nullable Location translatedTarget) {
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        if (!(trackable instanceof StaticTrackable)) {
            return;
        }
        Location lastLocation = this.lastLocations.remove(trackable);
        this.counters.remove(trackable);
        if (lastLocation != null) {
            SpigotKt.sendActualBlock(this.getPlayer(), lastLocation);
        }
    }

    private static final Integer update$lambda$0(BlinkingBlockPointer this$0, Trackable trackable, Integer count) {
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"<unused var>");
        return count == null ? Integer.valueOf(0) : Integer.valueOf((count + 1) % this$0.config.getBlockDataSequence().length);
    }

    private static final Integer update$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }
}

