/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers.variants;

import de.md5lukas.waypoints.libs.schedulers.AbstractScheduler;
import de.md5lukas.waypoints.pointers.BeaconColor;
import de.md5lukas.waypoints.pointers.Pointer;
import de.md5lukas.waypoints.pointers.PointerManager;
import de.md5lukas.waypoints.pointers.StaticTrackable;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.pointers.config.BossBarConfiguration;
import de.md5lukas.waypoints.pointers.util.MathKt;
import de.md5lukas.waypoints.pointers.variants.PointerVariant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.HSVLike;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010#\u001a\u00020$H\u0016J\u001a\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010(\u001a\u00020$H\u0016J\u001a\u0010)\u001a\u00020$2\u0006\u0010&\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\"H\u0016J\u001c\u0010*\u001a\u00020\u0017*\u00020\u00172\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\rH\u0002J\u0015\u0010-\u001a\u00070.\u00a2\u0006\u0002\b/2\u0006\u00100\u001a\u000201H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lde/md5lukas/waypoints/pointers/variants/BossBarPointer;", "Lde/md5lukas/waypoints/pointers/Pointer;", "pointerManager", "Lde/md5lukas/waypoints/pointers/PointerManager;", "player", "Lorg/bukkit/entity/Player;", "scheduler", "Lde/md5lukas/waypoints/libs/schedulers/AbstractScheduler;", "<init>", "(Lde/md5lukas/waypoints/pointers/PointerManager;Lorg/bukkit/entity/Player;Lde/md5lukas/schedulers/AbstractScheduler;)V", "config", "Lde/md5lukas/waypoints/pointers/config/BossBarConfiguration;", "interval", "", "getInterval", "()I", "supportsMultipleTargets", "", "getSupportsMultipleTargets", "()Z", "async", "getAsync", "rawTitle", "", "getRawTitle", "()Ljava/lang/String;", "bossBar", "Lnet/kyori/adventure/bossbar/BossBar;", "counter", "targetData", "", "Lde/md5lukas/waypoints/pointers/Trackable;", "Lde/md5lukas/waypoints/pointers/variants/BossBarPointer$TargetData;", "playerLocation", "Lorg/bukkit/Location;", "preUpdates", "", "update", "trackable", "translatedTarget", "postUpdates", "hide", "loopingSubstring", "size", "offset", "randomColor", "Lnet/kyori/adventure/text/format/TextColor;", "Lorg/jetbrains/annotations/NotNull;", "seed", "", "TargetData", "pointers"})
@SourceDebugExtension(value={"SMAP\nBossBarPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BossBarPointer.kt\nde/md5lukas/waypoints/pointers/variants/BossBarPointer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Kyori.kt\nde/md5lukas/waypoints/pointers/util/KyoriKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n126#2:146\n153#2,3:147\n1056#3:150\n1869#3:153\n1870#3:156\n7#4:151\n7#4:154\n1#5:152\n1#5:155\n1#5:157\n*S KotlinDebug\n*F\n+ 1 BossBarPointer.kt\nde/md5lukas/waypoints/pointers/variants/BossBarPointer\n*L\n94#1:146\n94#1:147,3\n101#1:150\n107#1:153\n107#1:156\n104#1:151\n114#1:154\n104#1:152\n114#1:155\n*E\n"})
public final class BossBarPointer
extends Pointer {
    @NotNull
    private final BossBarConfiguration config;
    @Nullable
    private BossBar bossBar;
    private int counter;
    @NotNull
    private final Map<Trackable, TargetData> targetData;
    private Location playerLocation;

    public BossBarPointer(@NotNull PointerManager pointerManager, @NotNull Player player, @NotNull AbstractScheduler scheduler) {
        Intrinsics.checkNotNullParameter((Object)pointerManager, (String)"pointerManager");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        super(pointerManager, player, scheduler, PointerVariant.BOSS_BAR);
        this.config = pointerManager.getConfiguration$pointers().getBossBar();
        this.targetData = new LinkedHashMap();
    }

    @Override
    public int getInterval() {
        return this.config.getInterval();
    }

    @Override
    public boolean getSupportsMultipleTargets() {
        return true;
    }

    @Override
    public boolean getAsync() {
        return true;
    }

    private final String getRawTitle() {
        return this.config.getTitle();
    }

    @Override
    public void preUpdates() {
        Location location = this.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        this.playerLocation = location;
    }

    @Override
    public void update(@NotNull Trackable trackable, @Nullable Location translatedTarget) {
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        if (translatedTarget == null) {
            this.hide(trackable, null);
            return;
        }
        TargetData targetData = this.targetData.computeIfAbsent(trackable, arg_0 -> BossBarPointer.update$lambda$1(arg_0 -> BossBarPointer.update$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)targetData, (String)"computeIfAbsent(...)");
        TargetData data = targetData;
        if (this.counter == 0) {
            Location location = this.playerLocation;
            if (location == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playerLocation");
                location = null;
            }
            data.setAngle(MathKt.normalizeAngleTo360(MathKt.getAngleToTarget(location, translatedTarget) - (float)90));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postUpdates() {
        block6: {
            void $this$postUpdates_u24lambda_u248;
            void $this$sortedBy$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object object;
            if (this.targetData.isEmpty()) {
                BossBar bossBar = this.bossBar;
                if (bossBar != null) {
                    BossBar it = bossBar;
                    boolean bl = false;
                    this.getPlayer().hideBossBar(it);
                    this.bossBar = null;
                }
                return;
            }
            if (this.bossBar == null) {
                void it;
                BossBar bossBar;
                BossBar bossBar2 = bossBar = BossBar.bossBar((Component)((Component)Component.empty()), (float)1.0f, (BossBar.Color)this.config.getBarColor(), (BossBar.Overlay)this.config.getBarStyle());
                object = this;
                boolean bl = false;
                this.getPlayer().showBossBar((BossBar)it);
                ((BossBarPointer)object).bossBar = bossBar;
            }
            this.counter = (this.counter + 1) % this.config.getRecalculateEveryNthInterval();
            Location location = this.playerLocation;
            if (location == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playerLocation");
                location = null;
            }
            float playerAngle = MathKt.normalizeAngleTo360(location.getYaw());
            int offset = kotlin.math.MathKt.roundToInt((float)(playerAngle / (float)360 * (float)this.getRawTitle().length()));
            String orientedTitle = this.loopingSubstring(this.config.getTitle(), this.getRawTitle().length() - 1, offset);
            Map<Trackable, TargetData> map = this.targetData;
            boolean $i$f$map = false;
            TextComponent.Builder builder2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            TextComponent.Builder builder3 = $this$mapTo$iv$iv.entrySet().iterator();
            while (builder3.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = builder3.next();
                object = destination$iv$iv;
                boolean bl = false;
                TargetData data = (TargetData)entry.getValue();
                int indicatorIndex = kotlin.math.MathKt.roundToInt((float)(data.getAngle() / (float)360 * (float)this.getRawTitle().length())) - 1;
                object.add(TuplesKt.to((Object)Math.floorMod(indicatorIndex - offset, this.getRawTitle().length()), (Object)data.getColor()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List trackableIndices = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getFirst();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
                }
            });
            BossBar bossBar = this.bossBar;
            if (bossBar == null) break block6;
            boolean $i$f$textComponent = false;
            TextComponent.Builder it$iv = builder2 = Component.text();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it$iv);
            builder3 = it$iv;
            object = bossBar;
            boolean bl2 = false;
            $this$postUpdates_u24lambda_u248.style(this.config.getNormalColor());
            int lastIndex = 0;
            Iterable $this$forEach$iv = trackableIndices;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$postUpdates_u24lambda_u248_u24lambda_u247_u24lambda_u246;
                TextComponent.Builder builder4;
                Pair pair = (Pair)element$iv;
                boolean bl3 = false;
                int index = ((Number)pair.component1()).intValue();
                TextColor color = (TextColor)pair.component2();
                if (lastIndex > index) continue;
                String string = orientedTitle.substring(lastIndex, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$postUpdates_u24lambda_u248.append((Component)Component.text((String)string));
                lastIndex = index + 1;
                boolean $i$f$textComponent2 = false;
                TextComponent.Builder it$iv2 = builder4 = Component.text();
                $i$a$-also-KyoriKt$textComponent$1$iv = false;
                Intrinsics.checkNotNull((Object)it$iv2);
                TextComponent.Builder builder5 = it$iv2;
                void var26_37 = $this$postUpdates_u24lambda_u248;
                boolean bl4 = false;
                $this$postUpdates_u24lambda_u248_u24lambda_u247_u24lambda_u246.style(this.config.getIndicatorStyle());
                $this$postUpdates_u24lambda_u248_u24lambda_u247_u24lambda_u246.color(color);
                $this$postUpdates_u24lambda_u248_u24lambda_u247_u24lambda_u246.content(this.config.getIndicator());
                BuildableComponent buildableComponent = builder4.build();
                Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
                var26_37.append((Component)((TextComponent)buildableComponent));
            }
            String string = orientedTitle.substring(Math.min(orientedTitle.length(), lastIndex));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$postUpdates_u24lambda_u248.append((Component)Component.text((String)string));
            BuildableComponent buildableComponent = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
            object.name((Component)((TextComponent)buildableComponent));
        }
    }

    @Override
    public void hide(@NotNull Trackable trackable, @Nullable Location translatedTarget) {
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        this.targetData.remove(trackable);
        if (this.targetData.isEmpty()) {
            BossBar bossBar = this.bossBar;
            if (bossBar != null) {
                BossBar it = bossBar;
                boolean bl = false;
                this.getPlayer().hideBossBar(it);
            }
            this.bossBar = null;
        }
    }

    private final String loopingSubstring(String $this$loopingSubstring, int size, int offset) {
        int modOffset = Math.floorMod(offset, $this$loopingSubstring.length());
        int overhang = Math.max(0, size + modOffset - $this$loopingSubstring.length());
        String string = $this$loopingSubstring.substring(modOffset, Math.min($this$loopingSubstring.length(), modOffset + size));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = $this$loopingSubstring.substring(0, overhang);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string + string2;
    }

    private final TextColor randomColor(long seed) {
        TextColor textColor = TextColor.color((HSVLike)HSVLike.hsvLike((float)RandomKt.Random((long)seed).nextFloat(), (float)1.0f, (float)1.0f));
        Intrinsics.checkNotNullExpressionValue((Object)textColor, (String)"color(...)");
        return textColor;
    }

    private static final TargetData update$lambda$0(BossBarPointer this$0, Trackable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it instanceof StaticTrackable ? (StaticTrackable)it : null;
        if (object == null || (object = object.getBeaconColor()) == null || (object = ((BeaconColor)((Object)object)).getTextColor()) == null) {
            object = this$0.randomColor(it.getSeed());
        }
        return new TargetData(0.0f, (TextColor)object);
    }

    private static final TargetData update$lambda$1(Function1 $tmp0, Object p0) {
        return (TargetData)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lde/md5lukas/waypoints/pointers/variants/BossBarPointer$TargetData;", "", "angle", "", "color", "Lnet/kyori/adventure/text/format/TextColor;", "<init>", "(FLnet/kyori/adventure/text/format/TextColor;)V", "getAngle", "()F", "setAngle", "(F)V", "getColor", "()Lnet/kyori/adventure/text/format/TextColor;", "pointers"})
    private static final class TargetData {
        private float angle;
        @NotNull
        private final TextColor color;

        public TargetData(float angle, @NotNull TextColor color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.angle = angle;
            this.color = color;
        }

        public final float getAngle() {
            return this.angle;
        }

        public final void setAngle(float f) {
            this.angle = f;
        }

        @NotNull
        public final TextColor getColor() {
            return this.color;
        }
    }
}

