/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers.variants;

import de.md5lukas.waypoints.libs.schedulers.AbstractScheduler;
import de.md5lukas.waypoints.pointers.Pointer;
import de.md5lukas.waypoints.pointers.PointerManager;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.pointers.config.HologramConfiguration;
import de.md5lukas.waypoints.pointers.util.SpigotKt;
import de.md5lukas.waypoints.pointers.variants.PointerVariant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001&B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00182\b\u0010\"\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010#\u001a\u00020\u001fH\u0016J\u001a\u0010$\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00182\b\u0010\"\u001a\u0004\u0018\u00010\u001bH\u0016J\u001a\u0010%\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00182\b\u0010\"\u001a\u0004\u0018\u00010\u001bH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\b\u0012\u00060\u0019R\u00020\u00000\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/md5lukas/waypoints/pointers/variants/HologramPointer;", "Lde/md5lukas/waypoints/pointers/Pointer;", "pointerManager", "Lde/md5lukas/waypoints/pointers/PointerManager;", "player", "Lorg/bukkit/entity/Player;", "scheduler", "Lde/md5lukas/waypoints/libs/schedulers/AbstractScheduler;", "<init>", "(Lde/md5lukas/waypoints/pointers/PointerManager;Lorg/bukkit/entity/Player;Lde/md5lukas/schedulers/AbstractScheduler;)V", "config", "Lde/md5lukas/waypoints/pointers/config/HologramConfiguration;", "interval", "", "getInterval", "()I", "supportsMultipleTargets", "", "getSupportsMultipleTargets", "()Z", "async", "getAsync", "activeHolograms", "", "Lde/md5lukas/waypoints/pointers/Trackable;", "Lde/md5lukas/waypoints/pointers/variants/HologramPointer$Hologram;", "playerEyes", "Lorg/bukkit/Location;", "velocityOffset", "Lorg/bukkit/util/Vector;", "preUpdates", "", "update", "trackable", "translatedTarget", "postUpdates", "hide", "immediateCleanup", "Hologram", "pointers"})
@SourceDebugExtension(value={"SMAP\nHologramPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HologramPointer.kt\nde/md5lukas/waypoints/pointers/variants/HologramPointer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n1869#2,2:210\n*S KotlinDebug\n*F\n+ 1 HologramPointer.kt\nde/md5lukas/waypoints/pointers/variants/HologramPointer\n*L\n88#1:210,2\n*E\n"})
public final class HologramPointer
extends Pointer {
    @NotNull
    private final HologramConfiguration config;
    @NotNull
    private final Map<Trackable, Hologram> activeHolograms;
    private Location playerEyes;
    private Vector velocityOffset;

    public HologramPointer(@NotNull PointerManager pointerManager, @NotNull Player player, @NotNull AbstractScheduler scheduler) {
        Intrinsics.checkNotNullParameter((Object)pointerManager, (String)"pointerManager");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        super(pointerManager, player, scheduler, PointerVariant.HOLOGRAM);
        this.config = pointerManager.getConfiguration$pointers().getHologram();
        this.activeHolograms = new ConcurrentHashMap();
    }

    @Override
    public int getInterval() {
        return this.config.getInterval();
    }

    @Override
    public boolean getSupportsMultipleTargets() {
        return true;
    }

    @Override
    public boolean getAsync() {
        return true;
    }

    @Override
    public void preUpdates() {
        Location location = this.getPlayer().getEyeLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getEyeLocation(...)");
        this.playerEyes = location;
        Vector vector = this.getPlayer().getVelocity().setY(0).multiply(this.getInterval());
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"multiply(...)");
        this.velocityOffset = vector;
    }

    @Override
    public void update(@NotNull Trackable trackable, @Nullable Location translatedTarget) {
        Location location;
        double distanceSquared;
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        if (translatedTarget == null) {
            return;
        }
        Component hologramText = trackable.getHologramText(this.getPlayer(), translatedTarget);
        if (hologramText == null) {
            return;
        }
        Location location2 = translatedTarget.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"clone(...)");
        Location hologramTarget = location2;
        hologramTarget.setY(hologramTarget.getY() + this.config.getHologramHeightOffset());
        Location location3 = this.playerEyes;
        if (location3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playerEyes");
            location3 = null;
        }
        if ((distanceSquared = location3.distanceSquared(translatedTarget)) <= (double)this.config.getDistanceFromPlayerSquared()) {
            v2 = hologramTarget;
        } else {
            Location location4 = this.playerEyes;
            if (location4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playerEyes");
                location4 = null;
            }
            Vector vector = location4.toVector();
            Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"toVector(...)");
            Vector pVec = vector;
            Vector vector2 = hologramTarget.toVector();
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"toVector(...)");
            Vector tVec = vector2;
            Vector vector3 = SpigotKt.minus(tVec, pVec).normalize();
            Intrinsics.checkNotNullExpressionValue((Object)vector3, (String)"normalize(...)");
            Vector direction = vector3;
            Vector vector4 = pVec.add(direction.multiply(this.config.getDistanceFromPlayer()));
            Vector vector5 = this.velocityOffset;
            if (vector5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityOffset");
                vector5 = null;
            }
            Vector vector6 = vector4.add(vector5);
            Location location5 = this.playerEyes;
            if (location5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playerEyes");
                location5 = null;
            }
            World world = location5.getWorld();
            Intrinsics.checkNotNull((Object)world);
            Location location6 = vector6.toLocation(world);
            Intrinsics.checkNotNull((Object)location6);
            v2 = location = location6;
        }
        if (this.activeHolograms.containsKey(trackable)) {
            Hologram hologram = this.activeHolograms.get(trackable);
            Intrinsics.checkNotNull((Object)hologram);
            Hologram hologram2 = hologram;
            hologram2.setLocation(location);
            hologram2.setText(hologramText);
        } else {
            this.activeHolograms.put(trackable, new Hologram(trackable, location, hologramText));
        }
    }

    @Override
    public void postUpdates() {
        AbstractScheduler.schedule$default(this.getScheduler(), null, () -> HologramPointer.postUpdates$lambda$0(this), 1, null);
    }

    @Override
    public void hide(@NotNull Trackable trackable, @Nullable Location translatedTarget) {
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        AbstractScheduler.schedule$default(this.getScheduler(), null, () -> HologramPointer.hide$lambda$1(this, trackable), 1, null);
    }

    @Override
    public void immediateCleanup(@NotNull Trackable trackable, @Nullable Location translatedTarget) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
            Hologram hologram = this.activeHolograms.remove(trackable);
            if (hologram == null) break block0;
            hologram.remove();
        }
    }

    private static final void postUpdates$lambda$0(HologramPointer this$0) {
        Iterable $this$forEach$iv = this$0.activeHolograms.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Hologram p0 = (Hologram)element$iv;
            boolean bl = false;
            p0.update();
        }
    }

    private static final void hide$lambda$1(HologramPointer this$0, Trackable $trackable) {
        block0: {
            Hologram hologram = this$0.activeHolograms.remove($trackable);
            if (hologram == null) break block0;
            hologram.remove();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/md5lukas/waypoints/pointers/variants/HologramPointer$Hologram;", "", "trackable", "Lde/md5lukas/waypoints/pointers/Trackable;", "location", "Lorg/bukkit/Location;", "text", "Lnet/kyori/adventure/text/Component;", "<init>", "(Lde/md5lukas/waypoints/pointers/variants/HologramPointer;Lde/md5lukas/waypoints/pointers/Trackable;Lorg/bukkit/Location;Lnet/kyori/adventure/text/Component;)V", "getLocation", "()Lorg/bukkit/Location;", "setLocation", "(Lorg/bukkit/Location;)V", "getText", "()Lnet/kyori/adventure/text/Component;", "setText", "(Lnet/kyori/adventure/text/Component;)V", "textDisplay", "Lorg/bukkit/entity/TextDisplay;", "itemDisplay", "Lorg/bukkit/entity/ItemDisplay;", "update", "", "remove", "pointers"})
    @SourceDebugExtension(value={"SMAP\nHologramPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HologramPointer.kt\nde/md5lukas/waypoints/pointers/variants/HologramPointer$Hologram\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1#2:210\n*E\n"})
    private final class Hologram {
        @NotNull
        private final Trackable trackable;
        @NotNull
        private Location location;
        @NotNull
        private Component text;
        @Nullable
        private TextDisplay textDisplay;
        @Nullable
        private ItemDisplay itemDisplay;

        public Hologram(@NotNull Trackable trackable, @NotNull Location location, Component text) {
            Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.trackable = trackable;
            this.location = location;
            this.text = text;
        }

        @NotNull
        public final Location getLocation() {
            return this.location;
        }

        public final void setLocation(@NotNull Location location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"<set-?>");
            this.location = location;
        }

        @NotNull
        public final Component getText() {
            return this.text;
        }

        public final void setText(@NotNull Component component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"<set-?>");
            this.text = component;
        }

        /*
         * WARNING - void declaration
         */
        public final void update() {
            void it;
            TextDisplay textCapture = this.textDisplay;
            ItemDisplay itemCapture = this.itemDisplay;
            if (textCapture != null && !HologramPointer.this.getServer().isOwnedByCurrentRegion((Entity)textCapture) || itemCapture != null && !HologramPointer.this.getServer().isOwnedByCurrentRegion((Entity)itemCapture)) {
                TextDisplay textDisplay = textCapture;
                if (textDisplay != null) {
                    SpigotKt.safeRemove((Entity)textDisplay, HologramPointer.this.getPointerManager().getPlugin$pointers());
                }
                ItemDisplay itemDisplay = itemCapture;
                if (itemDisplay != null) {
                    SpigotKt.safeRemove((Entity)itemDisplay, HologramPointer.this.getPointerManager().getPlugin$pointers());
                }
                this.textDisplay = null;
                this.itemDisplay = null;
            } else if (textCapture != null && textCapture.isValid()) {
                ItemDisplay itemDisplay = itemCapture;
                if (!(itemDisplay != null ? !itemDisplay.isValid() : false)) {
                    CompletableFuture itemTeleport;
                    textCapture.text(this.text);
                    CompletableFuture<Void> completableFuture = textCapture.teleportAsync(this.location);
                    Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"teleportAsync(...)");
                    CompletableFuture<Void> textTeleport = completableFuture;
                    ItemDisplay itemDisplay2 = itemCapture;
                    CompletableFuture completableFuture2 = itemTeleport = itemDisplay2 != null ? itemDisplay2.teleportAsync(this.location) : null;
                    if (!HologramPointer.this.getPlayer().canSee((Entity)textCapture) || itemCapture != null && !HologramPointer.this.getPlayer().canSee((Entity)itemCapture)) {
                        CompletableFuture<Void> completableFuture3;
                        if (itemTeleport == null) {
                            completableFuture3 = textTeleport;
                        } else {
                            CompletableFuture[] completableFutureArray = new CompletableFuture[]{textTeleport, itemTeleport};
                            completableFuture3 = CompletableFuture.allOf(completableFutureArray);
                        }
                        CompletableFuture<Void> combinedFuture = completableFuture3;
                        combinedFuture.thenRunAsync(() -> Hologram.update$lambda$0(HologramPointer.this, textCapture, itemCapture), HologramPointer.this.getSyncExecutor());
                    }
                    return;
                }
            }
            World world = HologramPointer.this.getPlayer().getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
            World world2 = world;
            TextDisplay textDisplay = textCapture;
            if (textDisplay != null) {
                SpigotKt.safeRemove((Entity)textDisplay, HologramPointer.this.getPointerManager().getPlugin$pointers());
            }
            ItemDisplay itemDisplay = itemCapture;
            if (itemDisplay != null) {
                SpigotKt.safeRemove((Entity)itemDisplay, HologramPointer.this.getPointerManager().getPlugin$pointers());
            }
            Entity entity = world2.spawn(this.location, TextDisplay.class, arg_0 -> Hologram.update$lambda$2(arg_0 -> Hologram.update$lambda$1(HologramPointer.this, this, arg_0), arg_0));
            HologramPointer hologramPointer = HologramPointer.this;
            Object object = (TextDisplay)entity;
            Hologram hologram = this;
            boolean bl2 = false;
            hologramPointer.getPlayer().showEntity(hologramPointer.getPointerManager().getPlugin$pointers(), (Entity)it);
            hologram.textDisplay = (TextDisplay)entity;
            if (HologramPointer.this.config.getIconEnabled()) {
                ItemDisplay itemDisplay3;
                Hologram hologram2 = this;
                ItemStack itemStack = this.trackable.getHologramItem();
                if (itemStack != null) {
                    void itemStack2;
                    hologramPointer = itemStack;
                    object = HologramPointer.this;
                    HologramPointer bl2 = hologramPointer;
                    hologram = hologram2;
                    boolean bl3 = false;
                    Entity entity2 = world2.spawn(this.location, ItemDisplay.class, arg_0 -> Hologram.update$lambda$7$lambda$5(arg_0 -> Hologram.update$lambda$7$lambda$4((HologramPointer)object, (ItemStack)itemStack2, arg_0), arg_0));
                    ItemDisplay it2 = (ItemDisplay)entity2;
                    boolean bl4 = false;
                    ((HologramPointer)object).getPlayer().showEntity(((HologramPointer)object).getPointerManager().getPlugin$pointers(), (Entity)it2);
                    itemDisplay3 = (ItemDisplay)entity2;
                    hologram2 = hologram;
                } else {
                    itemDisplay3 = null;
                }
                hologram2.itemDisplay = itemDisplay3;
            }
        }

        public final void remove() {
            block1: {
                TextDisplay textDisplay = this.textDisplay;
                if (textDisplay != null) {
                    SpigotKt.safeRemove((Entity)textDisplay, HologramPointer.this.getPointerManager().getPlugin$pointers());
                }
                ItemDisplay itemDisplay = this.itemDisplay;
                if (itemDisplay == null) break block1;
                SpigotKt.safeRemove((Entity)itemDisplay, HologramPointer.this.getPointerManager().getPlugin$pointers());
            }
        }

        private static final void update$lambda$0(HologramPointer this$0, TextDisplay $textCapture, ItemDisplay $itemCapture) {
            if (!this$0.getPlayer().canSee((Entity)$textCapture)) {
                this$0.getPlayer().showEntity(this$0.getPointerManager().getPlugin$pointers(), (Entity)$textCapture);
            }
            if ($itemCapture != null && !this$0.getPlayer().canSee((Entity)$itemCapture)) {
                this$0.getPlayer().showEntity(this$0.getPointerManager().getPlugin$pointers(), (Entity)$itemCapture);
            }
        }

        private static final Unit update$lambda$1(HologramPointer this$0, Hologram this$1, TextDisplay it) {
            it.setPersistent(false);
            it.setVisibleByDefault(false);
            it.setTeleportDuration(this$0.getInterval());
            it.setBillboard(Display.Billboard.CENTER);
            it.text(this$1.text);
            it.setDefaultBackground(true);
            it.setSeeThrough(true);
            return Unit.INSTANCE;
        }

        private static final void update$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit update$lambda$7$lambda$4(HologramPointer this$0, ItemStack $itemStack, ItemDisplay it) {
            it.setPersistent(false);
            it.setVisibleByDefault(false);
            it.setTeleportDuration(this$0.getInterval());
            it.setItemStack($itemStack);
            boolean isBlock = $itemStack.getType().isBlock();
            it.setBillboard(isBlock ? Display.Billboard.FIXED : Display.Billboard.CENTER);
            it.setTransformation(new Transformation(new Vector3f(0.0f, this$0.config.getIconOffset(), 0.0f), new AxisAngle4f(), new Vector3f(isBlock ? 1.0f : 0.6f), new AxisAngle4f()));
            it.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.FIXED);
            return Unit.INSTANCE;
        }

        private static final void update$lambda$7$lambda$5(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }
}

