/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers.variants;

import de.md5lukas.waypoints.libs.schedulers.AbstractScheduler;
import de.md5lukas.waypoints.pointers.Pointer;
import de.md5lukas.waypoints.pointers.PointerManager;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.pointers.config.ParticleConfiguration;
import de.md5lukas.waypoints.pointers.util.SpigotKt;
import de.md5lukas.waypoints.pointers.variants.PointerVariant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lde/md5lukas/waypoints/pointers/variants/ParticlePointer;", "Lde/md5lukas/waypoints/pointers/Pointer;", "pointerManager", "Lde/md5lukas/waypoints/pointers/PointerManager;", "player", "Lorg/bukkit/entity/Player;", "scheduler", "Lde/md5lukas/waypoints/libs/schedulers/AbstractScheduler;", "<init>", "(Lde/md5lukas/waypoints/pointers/PointerManager;Lorg/bukkit/entity/Player;Lde/md5lukas/schedulers/AbstractScheduler;)V", "config", "Lde/md5lukas/waypoints/pointers/config/ParticleConfiguration;", "interval", "", "getInterval", "()I", "supportsMultipleTargets", "", "getSupportsMultipleTargets", "()Z", "update", "", "trackable", "Lde/md5lukas/waypoints/pointers/Trackable;", "translatedTarget", "Lorg/bukkit/Location;", "pointers"})
public final class ParticlePointer
extends Pointer {
    @NotNull
    private final ParticleConfiguration config;

    public ParticlePointer(@NotNull PointerManager pointerManager, @NotNull Player player, @NotNull AbstractScheduler scheduler) {
        Intrinsics.checkNotNullParameter((Object)pointerManager, (String)"pointerManager");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        super(pointerManager, player, scheduler, PointerVariant.PARTICLE);
        this.config = pointerManager.getConfiguration$pointers().getParticle();
    }

    @Override
    public int getInterval() {
        return this.config.getInterval();
    }

    @Override
    public boolean getSupportsMultipleTargets() {
        return true;
    }

    @Override
    public void update(@NotNull Trackable trackable, @Nullable Location translatedTarget) {
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        if (translatedTarget != null) {
            Location location = this.getPlayer().getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
            Location pLoc = location;
            Vector vector = translatedTarget.toVector().subtract(pLoc.toVector());
            Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"subtract(...)");
            Vector dir = vector;
            if (!this.config.getShowVerticalDirection()) {
                dir.setY(0.0);
            }
            Vector vector2 = dir.normalize().multiply(this.config.getLength());
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"multiply(...)");
            dir = vector2;
            dir = SpigotKt.div(dir, this.config.getAmount());
            int n = this.config.getAmount();
            for (int i2 = 0; i2 < n; ++i2) {
                double y = this.config.getHeightOffset();
                if (this.config.getShowVerticalDirection()) {
                    y += dir.getY() * (double)i2;
                }
                this.getPlayer().spawnParticle(this.config.getParticle(), pLoc.getX() + dir.getX() * (double)i2, pLoc.getY() + y, pLoc.getZ() + dir.getZ() * (double)i2, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

