/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.pointers.variants;

import de.md5lukas.waypoints.libs.schedulers.AbstractScheduler;
import de.md5lukas.waypoints.libs.schedulers.Schedulers;
import de.md5lukas.waypoints.pointers.Pointer;
import de.md5lukas.waypoints.pointers.PointerManager;
import de.md5lukas.waypoints.pointers.StaticTrackable;
import de.md5lukas.waypoints.pointers.Trackable;
import de.md5lukas.waypoints.pointers.config.TrailConfiguration;
import de.md5lukas.waypoints.pointers.path.PathResult;
import de.md5lukas.waypoints.pointers.path.PathSuccess;
import de.md5lukas.waypoints.pointers.path.Pathfinder;
import de.md5lukas.waypoints.pointers.path.behaviour.BasicPlayerPathingStrategy;
import de.md5lukas.waypoints.pointers.path.behaviour.ConstantFWeigher;
import de.md5lukas.waypoints.pointers.util.SpigotKt;
import de.md5lukas.waypoints.pointers.variants.PointerVariant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u001aH\u0016J\u001a\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u001aH\u0016J\f\u0010#\u001a\u00020\u001a*\u00020\u001aH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/md5lukas/waypoints/pointers/variants/TrailPointer;", "Lde/md5lukas/waypoints/pointers/Pointer;", "pointerManager", "Lde/md5lukas/waypoints/pointers/PointerManager;", "player", "Lorg/bukkit/entity/Player;", "scheduler", "Lde/md5lukas/waypoints/libs/schedulers/AbstractScheduler;", "<init>", "(Lde/md5lukas/waypoints/pointers/PointerManager;Lorg/bukkit/entity/Player;Lde/md5lukas/schedulers/AbstractScheduler;)V", "config", "Lde/md5lukas/waypoints/pointers/config/TrailConfiguration;", "interval", "", "getInterval", "()I", "supportsMultipleTargets", "", "getSupportsMultipleTargets", "()Z", "highlightCounter", "pathfinder", "Lde/md5lukas/waypoints/pointers/path/Pathfinder;", "pathfinder$1", "locationTrail", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lorg/bukkit/Location;", "lastFuture", "Ljava/util/concurrent/CompletableFuture;", "update", "", "trackable", "Lde/md5lukas/waypoints/pointers/Trackable;", "translatedTarget", "hide", "toCenterLocation0", "Companion", "pointers"})
@SourceDebugExtension(value={"SMAP\nTrailPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrailPointer.kt\nde/md5lukas/waypoints/pointers/variants/TrailPointer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1740#2,3:193\n1878#2,3:196\n1563#2:199\n1634#2,3:200\n388#2,7:203\n1583#2,11:210\n1878#2,2:221\n1880#2:224\n1594#2:225\n1#3:223\n*S KotlinDebug\n*F\n+ 1 TrailPointer.kt\nde/md5lukas/waypoints/pointers/variants/TrailPointer\n*L\n93#1:193,3\n154#1:196,3\n108#1:199\n108#1:200,3\n126#1:203,7\n135#1:210,11\n135#1:221,2\n135#1:224\n135#1:225\n135#1:223\n*E\n"})
public final class TrailPointer
extends Pointer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TrailConfiguration config;
    private int highlightCounter;
    @NotNull
    private final Pathfinder pathfinder$1;
    @NotNull
    private final CopyOnWriteArrayList<Location> locationTrail;
    @NotNull
    private CompletableFuture<?> lastFuture;
    @NotNull
    private static final Object pathfinderLock = new Object();
    @Nullable
    private static Pathfinder pathfinder;

    public TrailPointer(@NotNull PointerManager pointerManager, @NotNull Player player, @NotNull AbstractScheduler scheduler) {
        Intrinsics.checkNotNullParameter((Object)pointerManager, (String)"pointerManager");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        super(pointerManager, player, scheduler, PointerVariant.TRAIL);
        this.config = pointerManager.getConfiguration$pointers().getTrail();
        this.pathfinder$1 = Companion.getPathfinder(pointerManager.getPlugin$pointers(), this.config);
        this.locationTrail = new CopyOnWriteArrayList();
        CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        this.lastFuture = completableFuture;
    }

    @Override
    public int getInterval() {
        return this.config.getInterval();
    }

    @Override
    public boolean getSupportsMultipleTargets() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(@NotNull Trackable trackable, @Nullable Location translatedTarget) {
        block15: {
            Object $this$all$iv;
            block17: {
                block16: {
                    boolean bl;
                    block14: {
                        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
                        if (translatedTarget == null || !(trackable instanceof StaticTrackable)) {
                            return;
                        }
                        if (this.getPlayer().getWorld() != translatedTarget.getWorld()) {
                            this.hide(trackable, translatedTarget);
                            return;
                        }
                        if (!this.lastFuture.isDone()) break block15;
                        Location location = (Location)CollectionsKt.firstOrNull((List)this.locationTrail);
                        if (this.getPlayer().getWorld() != (location != null ? location.getWorld() : null)) break block16;
                        $this$all$iv = this.locationTrail;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            Iterator iterator = $this$all$iv.iterator();
                            while (iterator.hasNext()) {
                                Object element$iv = iterator.next();
                                Location it = (Location)element$iv;
                                boolean bl2 = false;
                                double squared = this.getPlayer().getLocation().distanceSquared(it);
                                boolean outOfReach = squared >= (double)this.config.getPathInvalidationDistanceSquared();
                                if (outOfReach) continue;
                                bl = false;
                                break block14;
                            }
                            bl = true;
                        }
                    }
                    if (bl) break block16;
                    if (this.locationTrail.size() != 1) break block17;
                    Object object = CollectionsKt.last((List)this.locationTrail);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
                    if (SpigotKt.blockEquals((Location)object, translatedTarget)) break block17;
                }
                this.locationTrail.clear();
            }
            if (this.locationTrail.isEmpty()) {
                Location location = this.getPlayer().getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
                $this$all$iv = ((CompletableFuture)this.pathfinder$1.findPath(location, translatedTarget).thenApply(arg_0 -> TrailPointer.update$lambda$3(arg_0 -> TrailPointer.update$lambda$2(this, arg_0), arg_0))).exceptionally(arg_0 -> TrailPointer.update$lambda$4(this, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)$this$all$iv, (String)"exceptionally(...)");
                this.lastFuture = $this$all$iv;
            } else {
                Location last = (Location)CollectionsKt.last((List)this.locationTrail);
                Intrinsics.checkNotNull((Object)last);
                if (!SpigotKt.blockEquals(last, translatedTarget) && (this.getPlayer().getWorld() != last.getWorld() || this.getPlayer().getLocation().distanceSquared(last) < (double)this.config.getPathCalculateAheadDistanceSquared())) {
                    CompletionStage $i$f$all = ((CompletableFuture)this.pathfinder$1.findPath(last, translatedTarget).thenApply(arg_0 -> TrailPointer.update$lambda$8(arg_0 -> TrailPointer.update$lambda$7(this, arg_0), arg_0))).exceptionally(arg_0 -> TrailPointer.update$lambda$9(this, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$all, (String)"exceptionally(...)");
                    this.lastFuture = $i$f$all;
                }
            }
        }
        Iterable $this$forEachIndexed$iv = this.locationTrail;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void location;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Location squared = (Location)item$iv;
            int index = n;
            boolean bl = false;
            boolean isHighlight = (index - this.highlightCounter) % this.config.getHighlightDistance() == 0;
            this.getPlayer().spawnParticle(isHighlight ? this.config.getParticleHighlight() : this.config.getParticleNormal(), (Location)location, isHighlight ? (int)Math.ceil((double)this.config.getParticleAmount() * 1.5) : this.config.getParticleAmount(), this.config.getParticleSpread(), this.config.getParticleSpread(), this.config.getParticleSpread(), 0.0);
        }
        this.highlightCounter = (this.highlightCounter + 1) % this.config.getHighlightDistance();
    }

    @Override
    public void hide(@NotNull Trackable trackable, @Nullable Location translatedTarget) {
        Intrinsics.checkNotNullParameter((Object)trackable, (String)"trackable");
        this.locationTrail.clear();
        this.highlightCounter = 0;
        this.lastFuture.cancel(true);
    }

    private final Location toCenterLocation0(Location $this$toCenterLocation0) {
        $this$toCenterLocation0.setX($this$toCenterLocation0.getX() + 0.5);
        $this$toCenterLocation0.setY($this$toCenterLocation0.getY() + 0.5);
        $this$toCenterLocation0.setZ($this$toCenterLocation0.getZ() + 0.5);
        return $this$toCenterLocation0;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit update$lambda$2(TrailPointer this$0, PathResult result) {
        if (result instanceof PathSuccess) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((PathSuccess)result).getPath();
            CopyOnWriteArrayList<Location> copyOnWriteArrayList = this$0.locationTrail;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Location location = (Location)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this$0.toCenterLocation0((Location)it));
            }
            copyOnWriteArrayList.addAll((List)destination$iv$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$3(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit update$lambda$4(TrailPointer this$0, Throwable it) {
        this$0.getPointerManager().getPlugin$pointers().getSLF4JLogger().error("Couldn't calculate path", it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object update$lambda$7(TrailPointer this$0, PathResult result) {
        Object object;
        if (result instanceof PathSuccess) {
            void $this$mapIndexedNotNullTo$iv$iv;
            void $this$mapIndexedNotNull$iv;
            int lastIndex;
            ListIterator iterator$iv;
            Iterable $this$indexOfLast$iv;
            block6: {
                int n;
                $this$indexOfLast$iv = this$0.locationTrail;
                boolean $i$f$indexOfLast = false;
                iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Location it = (Location)iterator$iv.previous();
                    boolean bl = false;
                    boolean bl2 = this$0.getPlayer().getWorld() != it.getWorld() || this$0.getPlayer().getLocation().distanceSquared(it) >= (double)this$0.config.getRetainMaxPlayerDistanceSquared();
                    if (!bl2) continue;
                    n = iterator$iv.nextIndex();
                    break block6;
                }
                n = lastIndex = -1;
            }
            if (lastIndex > 0) {
                this$0.locationTrail.subList(0, lastIndex).clear();
            }
            $this$indexOfLast$iv = ((PathSuccess)result).getPath();
            CopyOnWriteArrayList<Location> copyOnWriteArrayList = this$0.locationTrail;
            boolean $i$f$mapIndexedNotNull = false;
            iterator$iv = $this$mapIndexedNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapIndexedNotNullTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                Location it$iv$iv;
                void pathPosition;
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                Location location = (Location)element$iv$iv;
                int index = index$iv$iv;
                boolean bl3 = false;
                if ((index == 0 ? null : this$0.toCenterLocation0((Location)pathPosition)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object = copyOnWriteArrayList.addAll((List)destination$iv$iv);
        } else {
            this$0.locationTrail.clear();
            object = Unit.INSTANCE;
        }
        return object;
    }

    private static final Object update$lambda$8(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    private static final Unit update$lambda$9(TrailPointer this$0, Throwable it) {
        this$0.getPointerManager().getPlugin$pointers().getSLF4JLogger().error("Couldn't calculate path", it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/md5lukas/waypoints/pointers/variants/TrailPointer$Companion;", "", "<init>", "()V", "pathfinderLock", "pathfinder", "Lde/md5lukas/waypoints/pointers/path/Pathfinder;", "getPathfinder", "plugin", "Lorg/bukkit/plugin/Plugin;", "config", "Lde/md5lukas/waypoints/pointers/config/TrailConfiguration;", "resetPathfinder", "", "pointers"})
    @SourceDebugExtension(value={"SMAP\nTrailPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrailPointer.kt\nde/md5lukas/waypoints/pointers/variants/TrailPointer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1#2:193\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Pathfinder getPathfinder(@NotNull Plugin plugin, @NotNull TrailConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Pathfinder pathfinder = pathfinder;
            if (pathfinder != null) {
                Pathfinder it = pathfinder;
                boolean bl = false;
                return it;
            }
            Object object = pathfinderLock;
            synchronized (object) {
                block5: {
                    boolean bl = false;
                    Pathfinder pathfinder2 = pathfinder;
                    if (pathfinder2 == null) break block5;
                    Pathfinder it = pathfinder2;
                    boolean bl2 = false;
                    Pathfinder pathfinder3 = it;
                    return pathfinder3;
                }
                TrailConfiguration $this$getPathfinder_u24lambda_u243_u24lambda_u242 = config;
                boolean bl = false;
                Pathfinder pathfinder4 = new Pathfinder(plugin, Schedulers.INSTANCE.global(plugin).asExecutor(true), $this$getPathfinder_u24lambda_u243_u24lambda_u242.getPathingMaxIterations(), $this$getPathfinder_u24lambda_u243_u24lambda_u242.getPathingMaxLength(), new BasicPlayerPathingStrategy($this$getPathfinder_u24lambda_u243_u24lambda_u242.getPathingSwimPenalty() > 0.0, $this$getPathfinder_u24lambda_u243_u24lambda_u242.getPathingSwimPenalty()), false, $this$getPathfinder_u24lambda_u243_u24lambda_u242.getPathingAllowChunkLoading(), $this$getPathfinder_u24lambda_u243_u24lambda_u242.getPathingAllowChunkGeneration(), false, null, new ConstantFWeigher($this$getPathfinder_u24lambda_u243_u24lambda_u242.getPathingHeuristicWeight()), 0L, 2848, null);
                TrailPointer.pathfinder = pathfinder4;
                Pathfinder pathfinder5 = pathfinder4;
                return pathfinder5;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void resetPathfinder() {
            Object object = pathfinderLock;
            synchronized (object) {
                boolean bl = false;
                TrailPointer.pathfinder = null;
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

