/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.util;

import de.md5lukas.waypoints.util.Expression;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/md5lukas/waypoints/util/MathParser;", "", "str", "", "variables", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "pos", "", "ch", "", "nextChar", "", "eat", "", "charToEat", "parse", "Lde/md5lukas/waypoints/util/Expression;", "parseExpression", "parseTerm", "parseFactor", "Companion", "utils"})
public final class MathParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String str;
    @NotNull
    private final List<String> variables;
    private int pos;
    private char ch;

    private MathParser(String str, List<String> variables) {
        this.str = str;
        this.variables = variables;
        this.pos = -1;
    }

    private final void nextChar() {
        ++this.pos;
        this.ch = this.pos < this.str.length() ? this.str.charAt(this.pos) : (char)'\u0000';
    }

    private final boolean eat(char charToEat) {
        while (this.ch == ' ') {
            this.nextChar();
        }
        if (this.ch == charToEat) {
            this.nextChar();
            return true;
        }
        return false;
    }

    @NotNull
    public final Expression parse() {
        this.nextChar();
        Expression x = this.parseExpression();
        if (this.pos < this.str.length()) {
            throw new RuntimeException("Unexpected: '" + this.ch + "'");
        }
        return x;
    }

    private final Expression parseExpression() {
        Expression x = this.parseTerm();
        while (true) {
            Expression expression;
            if (this.eat('+')) {
                a = x;
                b = this.parseTerm();
                expression = arg_0 -> MathParser.parseExpression$lambda$0(a, b, arg_0);
            } else if (this.eat('-')) {
                a = x;
                b = this.parseTerm();
                expression = arg_0 -> MathParser.parseExpression$lambda$1(a, b, arg_0);
            } else {
                return x;
            }
            x = expression;
        }
    }

    private final Expression parseTerm() {
        Expression x = this.parseFactor();
        while (true) {
            Expression expression;
            if (this.eat('*')) {
                a = x;
                b = this.parseFactor();
                expression = arg_0 -> MathParser.parseTerm$lambda$2(a, b, arg_0);
            } else if (this.eat('/')) {
                a = x;
                b = this.parseFactor();
                expression = arg_0 -> MathParser.parseTerm$lambda$3(a, b, arg_0);
            } else {
                return x;
            }
            x = expression;
        }
    }

    private final Expression parseFactor() {
        Expression x;
        block22: {
            block24: {
                Expression expression;
                block26: {
                    String name;
                    block25: {
                        int startPos;
                        block23: {
                            block21: {
                                if (this.eat('+')) {
                                    return this.parseFactor();
                                }
                                if (this.eat('-')) {
                                    Expression a = this.parseFactor();
                                    return arg_0 -> MathParser.parseFactor$lambda$4(a, arg_0);
                                }
                                x = null;
                                startPos = this.pos;
                                if (!this.eat('(')) break block21;
                                x = this.parseExpression();
                                this.eat(')');
                                break block22;
                            }
                            char c = this.ch;
                            boolean bl = '0' <= c ? c < ':' : false;
                            if (!bl && this.ch != '.') break block23;
                            while (true) {
                                boolean bl2 = '0' <= (c = this.ch) ? c < ':' : false;
                                if (!bl2 && this.ch != '.') break;
                                this.nextChar();
                            }
                            String string = this.str.substring(startPos, this.pos);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            double parsedX = Double.parseDouble(string);
                            x = arg_0 -> MathParser.parseFactor$lambda$5(parsedX, arg_0);
                            break block22;
                        }
                        char parsedX = this.ch;
                        boolean bl = 'a' <= parsedX ? parsedX < '{' : false;
                        if (!bl) break block24;
                        while (true) {
                            boolean bl3 = 'a' <= (parsedX = this.ch) ? parsedX < '{' : false;
                            if (!bl3) break;
                            this.nextChar();
                        }
                        String string = this.str.substring(startPos, this.pos);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        name = string;
                        if (!this.variables.contains(name)) break block25;
                        expression = arg_0 -> MathParser.parseFactor$lambda$6(name, arg_0);
                        break block26;
                    }
                    Expression a = this.parseFactor();
                    switch (name) {
                        case "sqrt": {
                            expression = arg_0 -> MathParser.parseFactor$lambda$7(a, arg_0);
                            break;
                        }
                        case "sin": {
                            expression = arg_0 -> MathParser.parseFactor$lambda$8(a, arg_0);
                            break;
                        }
                        case "cos": {
                            expression = arg_0 -> MathParser.parseFactor$lambda$9(a, arg_0);
                            break;
                        }
                        case "tan": {
                            expression = arg_0 -> MathParser.parseFactor$lambda$10(a, arg_0);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown function: " + name);
                        }
                    }
                }
                x = expression;
                break block22;
            }
            throw new RuntimeException("Unexpected: '" + this.ch + "'");
        }
        if (this.eat('^')) {
            Expression a = x;
            Expression b = this.parseFactor();
            x = arg_0 -> MathParser.parseFactor$lambda$11(a, b, arg_0);
        }
        return x;
    }

    private static final double parseExpression$lambda$0(Expression $a, Expression $b, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $a.eval(it) + $b.eval(it);
    }

    private static final double parseExpression$lambda$1(Expression $a, Expression $b, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $a.eval(it) - $b.eval(it);
    }

    private static final double parseTerm$lambda$2(Expression $a, Expression $b, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $a.eval(it) * $b.eval(it);
    }

    private static final double parseTerm$lambda$3(Expression $a, Expression $b, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $a.eval(it) / $b.eval(it);
    }

    private static final double parseFactor$lambda$4(Expression $a, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return -$a.eval(it);
    }

    private static final double parseFactor$lambda$5(double $parsedX, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $parsedX;
    }

    private static final double parseFactor$lambda$6(String $name, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Double d = (Double)it.get($name);
        if (d == null) {
            throw new IllegalArgumentException("Missing variable with the name " + $name);
        }
        return d;
    }

    private static final double parseFactor$lambda$7(Expression $a, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Math.sqrt($a.eval(it));
    }

    private static final double parseFactor$lambda$8(Expression $a, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Math.sin($a.eval(it));
    }

    private static final double parseFactor$lambda$9(Expression $a, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Math.cos($a.eval(it));
    }

    private static final double parseFactor$lambda$10(Expression $a, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Math.tan($a.eval(it));
    }

    private static final double parseFactor$lambda$11(Expression $a, Expression $b, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Math.pow($a.eval(it), $b.eval(it));
    }

    public /* synthetic */ MathParser(String str, List variables, DefaultConstructorMarker $constructor_marker) {
        this(str, variables);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\t\"\u00020\u0007\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lde/md5lukas/waypoints/util/MathParser$Companion;", "", "<init>", "()V", "parse", "Lde/md5lukas/waypoints/util/Expression;", "expression", "", "variables", "", "(Ljava/lang/String;[Ljava/lang/String;)Lde/md5lukas/waypoints/util/Expression;", "utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Expression parse(@NotNull String expression, String ... variables) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
            return new MathParser(expression, CollectionsKt.listOf((Object[])Arrays.copyOf(variables, variables.length)), null).parse();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

