/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.util;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\b\b\u0002\u0010\u0015\u001a\u00020\u0007\u001a\u0016\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0005\"(\u0010\b\u001a\u00020\u0007*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"parseLocationString", "Lorg/bukkit/Location;", "player", "Lorg/bukkit/entity/Player;", "input", "", "value", "", "amountClamped", "Lorg/bukkit/inventory/ItemStack;", "getAmountClamped", "(Lorg/bukkit/inventory/ItemStack;)I", "setAmountClamped", "(Lorg/bukkit/inventory/ItemStack;I)V", "parsedVersion", "", "minecraftVersionAtLeast", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "minor", "patch", "createCustomPlayerHead", "textureId", "utils"})
@SourceDebugExtension(value={"SMAP\nSpigotHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpigotHelper.kt\nde/md5lukas/waypoints/util/SpigotHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Items.kt\nde/md5lukas/commons/paper/ItemsKt\n*L\n1#1,57:1\n1878#2,3:58\n31#3,2:61\n*S KotlinDebug\n*F\n+ 1 SpigotHelper.kt\nde/md5lukas/waypoints/util/SpigotHelperKt\n*L\n38#1:58,3\n54#1:61,2\n*E\n"})
public final class SpigotHelperKt {
    private static int[] parsedVersion;

    @Nullable
    public static final Location parseLocationString(@NotNull Player player, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Object object = new char[]{' '};
        List parts = StringsKt.split$default((CharSequence)input, (char[])object, (boolean)false, (int)0, (int)6, null);
        if (parts.size() != 3) {
            return null;
        }
        try {
            object = new Location(player.getWorld(), Double.parseDouble((String)parts.get(0)), Double.parseDouble((String)parts.get(1)), Double.parseDouble((String)parts.get(2)));
        }
        catch (NumberFormatException numberFormatException) {
            object = null;
        }
        return object;
    }

    public static final int getAmountClamped(@NotNull ItemStack $this$amountClamped) {
        Intrinsics.checkNotNullParameter((Object)$this$amountClamped, (String)"<this>");
        return $this$amountClamped.getAmount();
    }

    public static final void setAmountClamped(@NotNull ItemStack $this$amountClamped, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$amountClamped, (String)"<this>");
        $this$amountClamped.setAmount(RangesKt.coerceIn((int)value, (int)1, (int)$this$amountClamped.getMaxStackSize()));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean minecraftVersionAtLeast(@NotNull Plugin plugin, int minor, int patch) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        if (parsedVersion == null) {
            parsedVersion = new int[3];
            String string = plugin.getServer().getMinecraftVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMinecraftVersion(...)");
            char[] cArray = new char[]{'.'};
            Iterable $this$forEachIndexed$iv = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void s;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv;
                int index = n;
                boolean bl = false;
                int[] nArray = parsedVersion;
                if (parsedVersion == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parsedVersion");
                    nArray = null;
                }
                nArray[index] = Integer.parseInt((String)s);
            }
        }
        int[] nArray = parsedVersion;
        if (parsedVersion == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parsedVersion");
            nArray = null;
        }
        if (nArray[1] < minor) return false;
        int[] nArray2 = parsedVersion;
        if (parsedVersion == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parsedVersion");
            nArray2 = null;
        }
        if (nArray2[2] < patch) return false;
        return true;
    }

    public static /* synthetic */ boolean minecraftVersionAtLeast$default(Plugin plugin, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return SpigotHelperKt.minecraftVersionAtLeast(plugin, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ItemStack createCustomPlayerHead(@NotNull Plugin plugin, @NotNull String textureId) {
        void $this$editMeta$iv;
        ItemStack stack;
        ItemStack it;
        PlayerTextures playerTextures;
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)textureId, (String)"textureId");
        PlayerProfile playerProfile = plugin.getServer().createProfile(UUID.randomUUID(), "CUSTOM_HEAD");
        Intrinsics.checkNotNullExpressionValue((Object)playerProfile, (String)"createProfile(...)");
        PlayerProfile profile = playerProfile;
        PlayerTextures playerTextures2 = playerTextures = profile.getTextures();
        PlayerProfile playerProfile2 = profile;
        boolean bl = false;
        it.setSkin(URI.create("https://textures.minecraft.net/texture/" + textureId).toURL());
        playerProfile2.setTextures(playerTextures);
        it = stack = new ItemStack(Material.PLAYER_HEAD);
        Function1 block$iv = arg_0 -> SpigotHelperKt.createCustomPlayerHead$lambda$2(profile, arg_0);
        boolean $i$f$editMeta = false;
        Function1 function1 = block$iv;
        $this$editMeta$iv.editMeta(SkullMeta.class, new Consumer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void accept(Object p0) {
                this.function.invoke(p0);
            }
        });
        return stack;
    }

    private static final Unit createCustomPlayerHead$lambda$2(PlayerProfile $profile, SkullMeta $this$editMeta) {
        Intrinsics.checkNotNullParameter((Object)$this$editMeta, (String)"$this$editMeta");
        $this$editMeta.setPlayerProfile($profile);
        return Unit.INSTANCE;
    }
}

