/*
 * Decompiled with CFR 0.152.
 */
package de.md5lukas.waypoints.util;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import de.md5lukas.waypoints.WaypointsPlugin;
import de.md5lukas.waypoints.lang.Translation;
import de.md5lukas.waypoints.libs.commons.paper.KyoriKt;
import de.md5lukas.waypoints.libs.commons.paper.PluginKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001cB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lde/md5lukas/waypoints/util/UpdateChecker;", "Ljava/lang/Runnable;", "Lorg/bukkit/event/Listener;", "plugin", "Lde/md5lukas/waypoints/WaypointsPlugin;", "owner", "", "repository", "<init>", "(Lde/md5lukas/waypoints/WaypointsPlugin;Ljava/lang/String;Ljava/lang/String;)V", "notified", "", "Ljava/util/UUID;", "message", "Lnet/kyori/adventure/text/Component;", "run", "", "onJoin", "e", "Lorg/bukkit/event/player/PlayerJoinEvent;", "latestRelease", "Lde/md5lukas/waypoints/util/UpdateChecker$LatestReleasesResponse;", "getLatestRelease", "()Lde/md5lukas/waypoints/util/UpdateChecker$LatestReleasesResponse;", "isLatestNewer", "", "current", "latest", "LatestReleasesResponse", "waypoints"})
@SourceDebugExtension(value={"SMAP\nUpdateChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateChecker.kt\nde/md5lukas/waypoints/util/UpdateChecker\n+ 2 Kyori.kt\nde/md5lukas/commons/paper/KyoriKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n23#2:117\n1878#3,2:118\n1880#3:121\n1#4:120\n*S KotlinDebug\n*F\n+ 1 UpdateChecker.kt\nde/md5lukas/waypoints/util/UpdateChecker\n*L\n44#1:117\n98#1:118,2\n98#1:121\n*E\n"})
public final class UpdateChecker
implements Runnable,
Listener {
    @NotNull
    private final WaypointsPlugin plugin;
    @NotNull
    private final String owner;
    @NotNull
    private final String repository;
    @NotNull
    private final Set<UUID> notified;
    private Component message;

    public UpdateChecker(@NotNull WaypointsPlugin plugin, @NotNull String owner, @NotNull String repository) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.plugin = plugin;
        this.owner = owner;
        this.repository = repository;
        this.notified = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        LatestReleasesResponse latestData = this.getLatestRelease();
        if (latestData == null) {
            this.plugin.getComponentLogger().warn(this.plugin.getTranslations().getUPDATE_COULD_NOT_CHECK().getText());
            return;
        }
        String string = this.plugin.getPluginMeta().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
        if (this.isLatestNewer(string, StringsKt.removePrefix((String)latestData.getTagName(), (CharSequence)"v"))) {
            void $this$run_u24lambda_u240;
            TextComponent.Builder builder2;
            Translation translation = this.plugin.getTranslations().getUPDATE_NEW_VERSION_AVAILABLE();
            TagResolver[] tagResolverArray = new TagResolver[2];
            tagResolverArray[0] = KyoriKt.placeholder("latest", latestData.getTagName());
            boolean $i$f$textComponent = false;
            TextComponent.Builder builder3 = Component.text();
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"text()");
            TextComponent.Builder builder4 = builder2 = builder3;
            String string2 = "link";
            int n = 1;
            TagResolver[] tagResolverArray2 = tagResolverArray;
            Translation translation2 = translation;
            boolean bl = false;
            $this$run_u24lambda_u240.content(latestData.getHtmlUrl());
            $this$run_u24lambda_u240.clickEvent(ClickEvent.openUrl((String)latestData.getHtmlUrl()));
            Unit unit = Unit.INSTANCE;
            BuildableComponent buildableComponent = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"text().apply(builder).build()");
            tagResolverArray2[n] = KyoriKt.placeholder(string2, (Component)((TextComponent)buildableComponent));
            Component message = translation2.withReplacements(tagResolverArray);
            this.plugin.getComponentLogger().info(message);
            Component component = this.plugin.getTranslations().getPREFIX().getText().append(message);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"append(...)");
            this.message = component;
            PluginKt.registerEvents((Plugin)this.plugin, this);
        } else {
            this.plugin.getComponentLogger().info(this.plugin.getTranslations().getUPDATE_USING_LATEST_VERSION().getText());
        }
    }

    @EventHandler
    public final void onJoin(@NotNull PlayerJoinEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.notified.contains(e.getPlayer().getUniqueId()) && e.getPlayer().hasPermission("waypoints.updateNotification")) {
            Player player = e.getPlayer();
            Component component = this.message;
            if (component == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"message");
                component = null;
            }
            player.sendMessage(component);
            ((Collection)this.notified).add(e.getPlayer().getUniqueId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LatestReleasesResponse getLatestRelease() {
        LatestReleasesResponse latestReleasesResponse;
        Object object;
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.github.com/repos/" + this.owner + "/" + this.repository + "/releases/latest")).header("Accept", "application/vnd.github+json").header("X-GitHub-Api-Version", " 2022-11-28").header("User-Agent", "Plugin Update Checker (" + this.plugin.getPluginMeta().getDisplayName() + ")").GET().build();
        try {
            object = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (Exception e) {
            return null;
        }
        HttpResponse<InputStream> response = object;
        if (response.statusCode() != 200) {
            return null;
        }
        InputStream inputStream = response.body();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"body(...)");
        object = inputStream;
        Object object2 = Charsets.UTF_8;
        object = new InputStreamReader((InputStream)object, (Charset)object2);
        object2 = null;
        try {
            InputStreamReader it = (InputStreamReader)object;
            boolean bl = false;
            latestReleasesResponse = (LatestReleasesResponse)new Gson().fromJson((Reader)it, LatestReleasesResponse.class);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return latestReleasesResponse;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isLatestNewer(String current, String latest) {
        Regex regex = new Regex("\\D+");
        CharSequence charSequence = current;
        int n = 0;
        List currentParts = regex.split(charSequence, n);
        CharSequence charSequence2 = latest;
        int n2 = 0;
        List latestParts = regex.split(charSequence2, n2);
        Iterable $this$forEachIndexed$iv = latestParts;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void latestPart;
            Object object;
            int n3;
            if ((n3 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n3;
            boolean bl = false;
            List list = currentParts;
            boolean bl2 = 0 <= index ? index < list.size() : false;
            if (bl2) {
                object = list.get(index);
            } else {
                int it = index;
                boolean bl3 = false;
                object = "0";
            }
            Integer n4 = StringsKt.toIntOrNull((String)latestPart);
            int comparison = Intrinsics.compare((int)Integer.parseInt((String)object), (int)(n4 != null ? n4 : 0));
            if (comparison > 0) {
                return false;
            }
            if (comparison >= 0) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lde/md5lukas/waypoints/util/UpdateChecker$LatestReleasesResponse;", "", "tagName", "", "htmlUrl", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getTagName", "()Ljava/lang/String;", "getHtmlUrl", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "waypoints"})
    private static final class LatestReleasesResponse {
        @SerializedName(value="tag_name")
        @NotNull
        private final String tagName;
        @SerializedName(value="html_url")
        @NotNull
        private final String htmlUrl;

        public LatestReleasesResponse(@NotNull String tagName, @NotNull String htmlUrl) {
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            Intrinsics.checkNotNullParameter((Object)htmlUrl, (String)"htmlUrl");
            this.tagName = tagName;
            this.htmlUrl = htmlUrl;
        }

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }

        @NotNull
        public final String getHtmlUrl() {
            return this.htmlUrl;
        }

        @NotNull
        public final String component1() {
            return this.tagName;
        }

        @NotNull
        public final String component2() {
            return this.htmlUrl;
        }

        @NotNull
        public final LatestReleasesResponse copy(@NotNull String tagName, @NotNull String htmlUrl) {
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            Intrinsics.checkNotNullParameter((Object)htmlUrl, (String)"htmlUrl");
            return new LatestReleasesResponse(tagName, htmlUrl);
        }

        public static /* synthetic */ LatestReleasesResponse copy$default(LatestReleasesResponse latestReleasesResponse, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = latestReleasesResponse.tagName;
            }
            if ((n & 2) != 0) {
                string2 = latestReleasesResponse.htmlUrl;
            }
            return latestReleasesResponse.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "LatestReleasesResponse(tagName=" + this.tagName + ", htmlUrl=" + this.htmlUrl + ")";
        }

        public int hashCode() {
            int result = this.tagName.hashCode();
            result = result * 31 + this.htmlUrl.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LatestReleasesResponse)) {
                return false;
            }
            LatestReleasesResponse latestReleasesResponse = (LatestReleasesResponse)other;
            if (!Intrinsics.areEqual((Object)this.tagName, (Object)latestReleasesResponse.tagName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.htmlUrl, (Object)latestReleasesResponse.htmlUrl);
        }
    }
}

