/*
 * Decompiled with CFR 0.152.
 */
package io.github.blobanium.mcbrowser.feature.specialbutton;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.blobanium.mcbrowser.MCBrowser;
import io.github.blobanium.mcbrowser.feature.specialbutton.SpecialButtonActions;
import io.github.blobanium.mcbrowser.util.TabManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3797;
import net.minecraft.class_5250;
import org.apache.commons.io.FileUtils;

public class SpecialButtonAction {
    public static final byte START_DL_DESCRIPTION = 0;
    public static final byte END_DL_DESCRIPTION = 1;

    public static void downloadModrinthMod() {
        SpecialButtonAction.downloadModrinth(SpecialButtonActions.MODRINTH_MOD);
    }

    public static void downloadModrinthRP() {
        SpecialButtonAction.downloadModrinth(SpecialButtonActions.MODRINTH_RP);
    }

    private static void downloadModrinth(SpecialButtonActions action) {
        MCBrowser.sendToastMessage((class_2561)class_2561.method_43471((String)"mcbrowser.download.toast.started"), (class_2561)SpecialButtonActionSwitches.getTranslation((byte)0, action));
        CompletableFuture.runAsync(() -> {
            try {
                URL url = SpecialButtonActionSwitches.getTargetURL(action);
                HttpURLConnection http = (HttpURLConnection)url.openConnection();
                http.setRequestMethod("GET");
                http.connect();
                InputStream stream = http.getInputStream();
                String json = new String(stream.readAllBytes());
                http.disconnect();
                Gson gson = new Gson();
                JsonArray array = (JsonArray)gson.fromJson(json, JsonArray.class);
                JsonObject object = array.get(0).getAsJsonObject();
                JsonArray filesArray = object.get("files").getAsJsonArray();
                JsonObject file = filesArray.get(0).getAsJsonObject();
                URL downloadURL = new URI(file.get("url").getAsString()).toURL();
                FileUtils.copyURLToFile((URL)downloadURL, (File)new File(FabricLoader.getInstance().getGameDir().toFile(), SpecialButtonActionSwitches.getTargetDirectory(action) + SpecialButtonAction.cleanseFileUrl(downloadURL.getFile())));
                MCBrowser.sendToastMessage((class_2561)class_2561.method_43471((String)"mcbrowser.download.toast.complete"), (class_2561)SpecialButtonActionSwitches.getTranslation((byte)1, action));
            }
            catch (IOException | URISyntaxException e) {
                MCBrowser.sendToastMessage((class_2561)class_2561.method_43471((String)"mcbrowser.download.toast.failed"), (class_2561)class_2561.method_43471((String)"mcbrowser.download.toast.failed.description"));
                MCBrowser.LOGGER.error("Failed to download file", (Throwable)e);
            }
        });
    }

    private static String cleanseFileUrl(String url) {
        String[] array = url.split("/");
        return array[array.length - 1].replace("%2B", "+");
    }

    public static String getModrinthSlugFromUrl(String url) {
        String string = url.replace("https://modrinth.com/", "");
        string = string.substring(string.indexOf("/") + 1);
        return string.split("/")[0];
    }

    public static class SpecialButtonActionSwitches {
        public static class_5250 getTranslation(byte type, SpecialButtonActions action) {
            return switch (action) {
                case SpecialButtonActions.MODRINTH_MOD -> {
                    switch (type) {
                        case 0: {
                            yield class_2561.method_43471((String)"mcbrowser.download.toast.started.description.mod");
                        }
                        case 1: {
                            yield class_2561.method_43471((String)"mcbrowser.download.toast.complete.description.mod");
                        }
                    }
                    throw new IllegalStateException("Unexpected type value: " + type);
                }
                case SpecialButtonActions.MODRINTH_RP -> {
                    switch (type) {
                        case 0: {
                            yield class_2561.method_43471((String)"mcbrowser.download.toast.started.description.rp");
                        }
                        case 1: {
                            yield class_2561.method_43471((String)"mcbrowser.download.toast.complete.description.rp");
                        }
                    }
                    throw new IllegalStateException("Unexpected type value: " + type);
                }
                default -> throw new IllegalStateException("Unexpected action value: " + String.valueOf((Object)action));
            };
        }

        public static URL getTargetURL(SpecialButtonActions action) throws MalformedURLException, URISyntaxException {
            return switch (action) {
                case SpecialButtonActions.MODRINTH_MOD -> new URI("https://api.modrinth.com/v2/project/" + SpecialButtonAction.getModrinthSlugFromUrl(TabManager.getCurrentUrl()) + "/version?game_versions=[%22" + class_3797.method_16672().comp_4025() + "%22]&loaders=[%22fabric%22]").toURL();
                case SpecialButtonActions.MODRINTH_RP -> new URI("https://api.modrinth.com/v2/project/" + SpecialButtonAction.getModrinthSlugFromUrl(TabManager.getCurrentUrl()) + "/version?game_versions=[%22" + class_3797.method_16672().comp_4025() + "%22]").toURL();
                default -> throw new IllegalStateException("Unexpected action value: " + String.valueOf((Object)action));
            };
        }

        public static String getTargetDirectory(SpecialButtonActions action) {
            return switch (action) {
                default -> throw new MatchException(null, null);
                case SpecialButtonActions.MODRINTH_MOD -> "mods/";
                case SpecialButtonActions.MODRINTH_RP -> "resourcepacks/";
            };
        }
    }
}

