/*
 * Decompiled with CFR 0.152.
 */
package io.github.blobanium.mcbrowser.screen;

import io.github.blobanium.mcbrowser.MCBrowser;
import io.github.blobanium.mcbrowser.config.BrowserAutoConfig;
import io.github.blobanium.mcbrowser.feature.specialbutton.SpecialButtonActions;
import io.github.blobanium.mcbrowser.feature.specialbutton.SpecialButtonHelper;
import io.github.blobanium.mcbrowser.util.BrowserImpl;
import io.github.blobanium.mcbrowser.util.BrowserUtil;
import io.github.blobanium.mcbrowser.util.TabHolder;
import io.github.blobanium.mcbrowser.util.TabManager;
import io.github.blobanium.mcbrowser.util.button.NewTabButton;
import io.github.blobanium.mcbrowser.util.button.ReloadButton;
import io.github.blobanium.mcbrowser.util.button.TabButton;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_7842;

public class BrowserScreen
extends class_437 {
    public static final int BD_OFFSET = 50;
    public class_342 urlBox;
    public class_4185 forwardButton;
    public class_4185 backButton;
    public ReloadButton reloadButton;
    private class_4264[] navigationButtons;
    private class_339[] uiElements;
    private class_339[] zoomElements;
    public ArrayList<TabButton> tabButtons = new ArrayList();
    private NewTabButton newTabButton = null;
    public class_4185 specialButton;
    private class_4185 openInBrowserButton;
    public class_7842 zoomDetails;
    public class_4185 zoomInButton;
    public class_4185 zoomOutButton;
    private int previousLimit;
    private boolean isFpsLowered = false;
    public BrowserImpl currentTab = TabManager.getCurrentTab();

    public BrowserScreen(class_2561 title) {
        super(title);
    }

    public void removeTab(int index) {
        this.method_37066((class_364)this.tabButtons.get(index));
        this.tabButtons.get(index).resetIco();
        this.tabButtons.remove(index);
        this.updateTabButtonsIndexes(index);
        this.updateTabSize();
    }

    public void addTab(int index) {
        TabButton tabButton = new TabButton(50, 10, 100, 15, index);
        this.tabButtons.add(index, tabButton);
        this.updateTabButtonsIndexes(index + 1);
        this.method_25429((class_364)tabButton);
        this.updateTabSize();
    }

    private void updateTabButtonsIndexes(int i) {
        while (i < this.tabButtons.size()) {
            this.tabButtons.get(i).setTab(i);
            ++i;
        }
    }

    private void updateTabSize() {
        if (!this.tabButtons.isEmpty()) {
            int size = Math.min(100, (this.field_22789 - 100 - 15) / this.tabButtons.size() - 5);
            for (TabButton tabButton : this.tabButtons) {
                tabButton.method_25358(Math.max(15, size));
            }
        }
    }

    protected void method_25426() {
        super.method_25426();
        class_310 client = class_310.method_1551();
        BrowserAutoConfig config = MCBrowser.getConfig();
        if (config.limitBrowserFramerate && (Integer)client.field_1690.method_42524().method_41753() > config.browserFPS) {
            this.previousLimit = (Integer)client.field_1690.method_42524().method_41753();
            client.method_61964().method_61938(config.browserFPS);
            this.isFpsLowered = true;
        }
        BrowserUtil.instance = this;
        BrowserUtil.tooltipText = null;
        this.newTabButton = new NewTabButton(50, 10, 15, 15, class_2561.method_30163((String)"+"));
        for (TabHolder tab : TabManager.tabs) {
            int index = TabManager.tabs.indexOf(tab);
            TabButton tabButton = new TabButton(50, 10, 100, 15, index);
            this.tabButtons.add(tabButton);
        }
        for (TabButton tabButton : this.tabButtons) {
            this.method_25429((class_364)tabButton);
        }
        this.updateTabSize();
        this.initElements();
        this.updateWidgets();
    }

    public void initElements() {
        this.urlBox = BrowserUtil.initUrlBox(50, this.field_22789);
        this.backButton = BrowserUtil.initButton(class_2561.method_30163((String)"\u25c0"), button -> this.currentTab.goBack(), 50, 1);
        this.forwardButton = BrowserUtil.initButton(class_2561.method_30163((String)"\u25b6"), button -> this.currentTab.goForward(), 70, 1);
        this.reloadButton = new ReloadButton(90, 30, 15, 15);
        class_4185 homeButton = BrowserUtil.initButton(class_2561.method_30163((String)"\u2302"), button -> BrowserUtil.homeButtonAction(), 110, 1);
        this.specialButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)""), button -> SpecialButtonHelper.onPress(TabManager.getCurrentUrl())).method_46434(50, this.field_22790 - 50 + 5, 150, 15).method_46431();
        this.openInBrowserButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Open In External Browser"), button -> BrowserUtil.openInBrowser()).method_46434(this.field_22789 - 200, this.field_22790 - 50 + 5, 150, 15).method_46431();
        this.zoomDetails = new class_7842((class_2561)BrowserUtil.getZoomLevelText(this.currentTab.getZoomLevel()), class_310.method_1551().field_1772);
        this.zoomDetails.method_48229(this.field_22789 - 50 - this.zoomDetails.method_25368(), 1);
        this.zoomInButton = BrowserUtil.initButton(class_2561.method_30163((String)"+"), button -> this.zoomControl((byte)0), this.field_22789 - 65, 2);
        this.zoomOutButton = BrowserUtil.initButton(class_2561.method_30163((String)"-"), button -> this.zoomControl((byte)1), this.field_22789 - 85, 2);
        this.navigationButtons = new class_4264[]{this.forwardButton, this.backButton, this.reloadButton, homeButton};
        this.zoomElements = new class_339[]{this.zoomInButton, this.zoomOutButton, this.zoomDetails};
        for (class_339 widget : this.uiElements = new class_339[]{this.forwardButton, this.backButton, this.reloadButton, homeButton, this.urlBox, this.specialButton, this.openInBrowserButton, this.newTabButton, this.zoomDetails, this.zoomInButton, this.zoomOutButton}) {
            this.method_25429((class_364)widget);
        }
    }

    public void updateWidgets() {
        this.urlBox.method_1852(this.currentTab.getURL());
        this.urlBox.method_1870(false);
        this.backButton.field_22763 = this.currentTab.canGoBack();
        this.forwardButton.field_22763 = this.currentTab.canGoForward();
        this.reloadButton.method_25355(class_2561.method_30163((String)(this.currentTab.isLoading() ? "\u274c" : "\u27f3")));
        SpecialButtonActions action = SpecialButtonActions.getFromUrlConstantValue(TabManager.getCurrentUrl());
        if (action != null) {
            this.specialButton.method_25355(action.getButtonText());
        }
        this.currentTab.resize(BrowserUtil.scaleX(this.field_22789, 50), BrowserUtil.scaleY(this.field_22790, 50));
    }

    public void method_25410(class_310 minecraft, int i, int j) {
        ArrayList<TabButton> tempList = new ArrayList<TabButton>(this.tabButtons);
        this.tabButtons.clear();
        super.method_25410(minecraft, i, j);
        this.resizeBrowser();
        this.updateWidgets();
        for (TabButton tabButton : this.tabButtons) {
            this.method_37066((class_364)tabButton);
        }
        this.tabButtons = tempList;
        for (TabButton tabButton : this.tabButtons) {
            this.method_25429((class_364)tabButton);
        }
        this.updateTabSize();
        for (class_339 widget : this.uiElements) {
            if (this.method_25396().contains(widget)) continue;
            this.method_25429((class_364)widget);
        }
    }

    public void method_25419() {
        BrowserUtil.instance = null;
        for (TabButton tabButton : this.tabButtons) {
            tabButton.resetIco();
        }
        if (this.isFpsLowered) {
            class_310.method_1551().method_61964().method_61938(this.previousLimit);
        }
        super.method_25419();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (TabManager.getCurrentTabHolder().isInit()) {
            this.currentTab.render(context, 50, 50, this.field_22789 - 100, this.field_22790 - 100);
        } else {
            TabManager.getCurrentTabHolder().init();
            this.resizeBrowser();
        }
        this.renderWidgets(context, mouseX, mouseY, delta);
        if (BrowserUtil.tooltipText != null && BrowserUtil.tooltipText.getBytes().length != 0) {
            context.method_51438(class_310.method_1551().field_1772, class_2561.method_30163((String)BrowserUtil.tooltipText), mouseX, mouseY);
        }
    }

    private void renderWidgets(class_332 context, int mouseX, int mouseY, float delta) {
        this.urlBox.method_48579(context, mouseX, mouseY, delta);
        for (class_4264 button : this.navigationButtons) {
            button.method_25394(context, mouseX, mouseY, delta);
        }
        if (SpecialButtonHelper.isOnCompatableSite(TabManager.getCurrentUrl())) {
            this.specialButton.method_25394(context, mouseX, mouseY, delta);
        }
        for (TabButton tabButton : this.tabButtons) {
            tabButton.method_25394(context, mouseX, mouseY, delta);
        }
        for (class_339 zoom : this.zoomElements) {
            if (BrowserUtil.ZoomActions.shouldRenderZoomElements()) {
                if (zoom.method_25405((double)mouseX, (double)mouseY)) {
                    BrowserUtil.ZoomActions.resetLastTimeCalled();
                }
                zoom.field_22763 = true;
                zoom.method_25394(context, mouseX, mouseY, delta);
                continue;
            }
            zoom.field_22763 = false;
        }
        this.newTabButton.method_25394(context, mouseX, mouseY, delta);
        this.openInBrowserButton.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        this.mouseButtonControlImpl(click, doubled, true);
        return super.method_25402(click, doubled);
    }

    public boolean method_25406(class_11909 click) {
        this.mouseButtonControlImpl(click, false, false);
        return super.method_25406(click);
    }

    public void method_16014(double mouseX, double mouseY) {
        BrowserUtil.runAsyncIfEnabled(() -> this.currentTab.sendMouseMove(BrowserUtil.mouseX(mouseX, 50), BrowserUtil.mouseY(mouseY, 50)));
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        BrowserUtil.updateMouseLocation(click.comp_4798(), click.comp_4799());
        return super.method_25403(click, offsetX, offsetY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        BrowserUtil.runAsyncIfEnabled(() -> this.currentTab.sendMouseWheel(BrowserUtil.mouseX(mouseX, 50), BrowserUtil.mouseY(mouseY, 50), verticalAmount, 0));
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(class_11908 input) {
        this.sendKeyActivityAndSetFocus(input.method_74228(), input.comp_4796(), input.comp_4797(), true);
        if (this.field_22787 != null && this.field_22787.method_74188() && BrowserUtil.ctrlKeyPressedSwitch(input.method_74228(), input.comp_4797()) || Arrays.stream(this.uiElements).noneMatch(class_339::method_25370) && input.method_74228() == 257) {
            return true;
        }
        if (input.method_74228() == 256 && this.method_25422()) {
            this.method_25419();
            return true;
        }
        return this.method_25399() != null && this.method_25399().method_25404(input);
    }

    public boolean method_16803(class_11908 input) {
        this.sendKeyActivityAndSetFocus(input.method_74228(), input.comp_4796(), input.comp_4797(), false);
        return super.method_16803(input);
    }

    private void sendKeyActivityAndSetFocus(int keyCode, int scanCode, int modifiers, boolean isPress) {
        if (isPress ? !this.urlBox.method_25370() : this.field_22787 == null || !this.field_22787.method_74188() || keyCode != 258) {
            BrowserUtil.runAsyncIfEnabled(() -> this.currentTab.sendKeyPressRelease(keyCode, scanCode, modifiers, isPress));
        }
        this.setFocus();
    }

    public boolean method_25400(class_11905 input) {
        if (input.comp_4793() == 0) {
            return false;
        }
        BrowserUtil.runAsyncIfEnabled(() -> this.currentTab.sendKeyTyped((char)input.comp_4793(), input.comp_4794()));
        this.setFocus();
        return super.method_25400(input);
    }

    public void setFocus() {
        boolean browserFocus = true;
        for (class_339 widget : this.uiElements) {
            boolean mouseOver = widget.method_25405(BrowserUtil.lastMouseX, BrowserUtil.lastMouseY);
            widget.method_25365(mouseOver);
            if (!mouseOver) continue;
            browserFocus = false;
        }
        this.currentTab.setFocus(browserFocus);
    }

    private void resizeBrowser() {
        if (this.field_22789 > 100 && this.field_22790 > 100) {
            for (TabHolder tab : TabManager.tabs) {
                tab.getBrowser().resize(BrowserUtil.scaleX(this.field_22789, 50), BrowserUtil.scaleY(this.field_22790, 50));
            }
        }
        if (this.urlBox != null) {
            this.urlBox.method_25358(BrowserUtil.getUrlBoxWidth(this.field_22789, 50));
        }
        if (this.specialButton != null) {
            this.specialButton.method_48229(50, this.field_22790 - 50 + 5);
        }
        if (this.openInBrowserButton != null) {
            this.openInBrowserButton.method_48229(this.field_22789 - 200, this.field_22790 - 50 + 5);
        }
    }

    private void mouseButtonControlImpl(class_11909 click, boolean isDouble, boolean isClick) {
        if (click.comp_4798() > 50.0 && click.comp_4798() < (double)(this.field_22789 - 50) && click.comp_4799() > 50.0 && click.comp_4799() < (double)(this.field_22790 - 50)) {
            this.currentTab.mouseButtonControl(click, isDouble, isClick);
        }
        this.setFocus();
    }

    public void zoomControl(byte zoomAction) {
        if (zoomAction == 0) {
            this.currentTab.setZoomLevel(this.currentTab.getZoomLevel() + MCBrowser.getConfig().zoomScalingFactor);
        } else if (zoomAction == 1) {
            this.currentTab.setZoomLevel(this.currentTab.getZoomLevel() - MCBrowser.getConfig().zoomScalingFactor);
        } else if (zoomAction == 2) {
            this.currentTab.setZoomLevel(0.0);
        } else {
            throw new IllegalArgumentException("Invalid zoom action value: " + zoomAction);
        }
        this.zoomDetails.method_25355((class_2561)BrowserUtil.getZoomLevelText(this.currentTab.getZoomLevel()));
        BrowserUtil.ZoomActions.resetLastTimeCalled();
    }
}

