/*
 * Decompiled with CFR 0.152.
 */
package io.github.blobanium.mcbrowser.util;

import com.cinemamod.mcef.MCEF;
import io.github.blobanium.mcbrowser.MCBrowser;
import io.github.blobanium.mcbrowser.feature.BrowserFeatureUtil;
import io.github.blobanium.mcbrowser.feature.specialbutton.SpecialButtonActions;
import io.github.blobanium.mcbrowser.screen.BrowserScreen;
import io.github.blobanium.mcbrowser.util.BrowserImpl;
import io.github.blobanium.mcbrowser.util.TabHolder;
import io.github.blobanium.mcbrowser.util.TabManager;
import io.github.blobanium.mcbrowser.util.button.BrowserTabIcon;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_11908;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;

public class BrowserUtil {
    public static double lastMouseX;
    public static double lastMouseY;
    public static BrowserScreen instance;
    public static String tooltipText;
    public static boolean openInExternalBrowser;

    public static class_4185 initButton(class_2561 message, class_4185.class_4241 onPress, int positionX, int buttonLevel) {
        return class_4185.method_46430((class_2561)message, (class_4185.class_4241)onPress).method_46434(positionX, 50 - 20 * buttonLevel, 15, 15).method_46431();
    }

    public static int mouseX(double x, int offset) {
        lastMouseX = x;
        return (int)((x - (double)offset) * (double)class_310.method_1551().method_22683().method_4495());
    }

    public static int mouseY(double y, int offset) {
        lastMouseY = y;
        return (int)((y - (double)offset) * (double)class_310.method_1551().method_22683().method_4495());
    }

    public static void updateMouseLocation(double mouseX, double mouseY) {
        lastMouseX = mouseX;
        lastMouseY = mouseY;
    }

    public static int scaleX(double x, int offset) {
        return (int)((x - (double)(offset * 2)) * (double)class_310.method_1551().method_22683().method_4495());
    }

    public static int scaleY(double y, int offset) {
        return (int)((y - (double)(offset * 2)) * (double)class_310.method_1551().method_22683().method_4495());
    }

    public static int getUrlBoxWidth(int width, int offset) {
        return width - offset * 2 - 80;
    }

    public static BrowserImpl createBrowser(String url) {
        if (MCEF.isInitialized()) {
            BrowserImpl browser = new BrowserImpl(MCEF.getClient(), url, false);
            browser.setCloseAllowed();
            browser.createImmediately();
            return browser;
        }
        throw new IllegalStateException("Chromium Embedded Framework was never initialized.");
    }

    public static BrowserTabIcon createIcon(String url) {
        if (MCEF.isInitialized()) {
            BrowserTabIcon icon = new BrowserTabIcon(MCEF.getClient(), url, false);
            icon.setCloseAllowed();
            icon.createImmediately();
            return icon;
        }
        throw new IllegalStateException("Chromium Embedded Framework was never initialized.");
    }

    public static class_342 initUrlBox(int offset, int width) {
        class_342 urlBox = new class_342(class_310.method_1551().field_1772, offset + 80, offset - 20, BrowserUtil.getUrlBoxWidth(width, offset), 15, class_2561.method_30163((String)"")){

            public boolean method_25404(class_11908 input) {
                if (this.method_25370()) {
                    for (TabHolder tab : TabManager.tabs) {
                        BrowserImpl browser = tab.getBrowser();
                        if (browser == null) continue;
                        browser.setFocus(false);
                    }
                    if (input.method_74228() == 257) {
                        TabManager.getCurrentTab().loadURL(BrowserFeatureUtil.prediffyURL(this.method_1882()));
                        this.method_25365(false);
                    }
                }
                return super.method_25404(input);
            }
        };
        urlBox.method_1880(2048);
        return urlBox;
    }

    public static void openInBrowser() {
        try {
            openInExternalBrowser = true;
            class_156.method_668().method_673(new URI(TabManager.getCurrentUrl()));
        }
        catch (URISyntaxException e) {
            MCBrowser.LOGGER.fatal("Unable to open Browser", (Throwable)e);
        }
    }

    public static void homeButtonAction() {
        String prediffyedHomePage = BrowserFeatureUtil.prediffyURL(MCBrowser.getConfig().homePage);
        BrowserUtil.instance.urlBox.method_1852(prediffyedHomePage);
        TabManager.getCurrentTab().loadURL(prediffyedHomePage);
    }

    public static void onUrlChange() {
        if (BrowserUtil.instance.urlBox.method_25370()) {
            BrowserUtil.instance.urlBox.method_25365(false);
        }
        BrowserUtil.instance.urlBox.method_1852(TabManager.getCurrentUrl());
        BrowserUtil.instance.urlBox.method_1870(false);
        SpecialButtonActions action = SpecialButtonActions.getFromUrlConstantValue(TabManager.getCurrentUrl());
        if (action != null) {
            BrowserUtil.instance.specialButton.method_25355(action.getButtonText());
        }
    }

    public static boolean ctrlKeyPressedSwitch(int keyCode, int modifiers) {
        switch (keyCode) {
            case 84: 
            case 258: {
                TabManager.tabControl(keyCode + modifiers);
                instance.setFocus();
                return true;
            }
            case 61: {
                instance.zoomControl((byte)0);
                return true;
            }
            case 45: {
                instance.zoomControl((byte)1);
                return true;
            }
            case 48: {
                instance.zoomControl((byte)2);
                return true;
            }
        }
        return false;
    }

    public static void runAsyncIfEnabled(Runnable runnable) {
        if (MCBrowser.getConfig().asyncBrowserInput) {
            CompletableFuture.runAsync(runnable);
        } else {
            runnable.run();
        }
    }

    public static int zoomLevelToZoomPercentage(double zoomLevel) {
        return (int)Math.round(Math.pow(1.2, zoomLevel) * 100.0);
    }

    public static class_5250 getZoomLevelText(double zoomLevel) {
        return class_2561.method_43469((String)"mcbrowser.zoom.percent", (Object[])new Object[]{BrowserUtil.zoomLevelToZoomPercentage(zoomLevel)});
    }

    static {
        openInExternalBrowser = false;
    }

    public static class ZoomActions {
        public static final byte INCREASE = 0;
        public static final byte DECREASE = 1;
        public static final byte RESET = 2;
        public static long lastTimeCalled = 0L;

        public static void resetLastTimeCalled() {
            lastTimeCalled = System.currentTimeMillis();
        }

        public static boolean shouldRenderZoomElements() {
            return System.currentTimeMillis() <= lastTimeCalled + 2500L;
        }
    }

    public static class Keybinds {
        public static final int CTRL_T = 86;
        public static final int CTRL_SHIFT_T = 87;
        public static final int CTRL_TAB = 260;
        public static final int CTRL_SHIFT_TAB = 261;
    }
}

