/*
 * Decompiled with CFR 0.152.
 */
package io.github.blobanium.mcbrowser.util;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.blobanium.mcbrowser.MCBrowser;
import io.github.blobanium.mcbrowser.feature.BrowserFeatureUtil;
import io.github.blobanium.mcbrowser.screen.BrowserScreen;
import io.github.blobanium.mcbrowser.util.BrowserImpl;
import io.github.blobanium.mcbrowser.util.BrowserUtil;
import io.github.blobanium.mcbrowser.util.TabHolder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class TabManager {
    public static final List<TabHolder> tabs = new ArrayList<TabHolder>();
    public static final List<String> closedTabs = new ArrayList<String>();
    public static int activeTab = 0;

    public static void setActiveTab(int index) {
        activeTab = index;
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof BrowserScreen) {
            BrowserScreen screen = (BrowserScreen)class_4372;
            screen.currentTab = TabManager.getCurrentTab();
            BrowserUtil.instance.updateWidgets();
        }
    }

    public static void openNewTab() {
        TabManager.openNewTab(BrowserFeatureUtil.prediffyURL(MCBrowser.getConfig().homePage));
    }

    public static void openNewTab(String url) {
        TabManager.openNewTab(url, tabs.size());
    }

    public static void openNewTab(String url, int index) {
        TabManager.openNewTab(url, index, index);
    }

    public static void openNewTab(String url, int index, int setActive) {
        tabs.add(index, new TabHolder(url));
        TabManager.setActiveTab(setActive);
        if (class_310.method_1551().field_1755 instanceof BrowserScreen) {
            BrowserUtil.instance.addTab(index);
        } else {
            MCBrowser.openBrowser();
        }
    }

    public static void closeTab(int index) {
        if (BrowserUtil.instance != null) {
            BrowserUtil.instance.removeTab(index);
        }
        closedTabs.add(tabs.get(index).getUrl());
        tabs.get(index).close();
        tabs.remove(index);
        if (tabs.isEmpty() && BrowserUtil.instance != null) {
            BrowserUtil.instance.method_25419();
            return;
        }
        if (index <= activeTab && activeTab != 0) {
            TabManager.setActiveTab(activeTab - 1);
        } else if (BrowserUtil.instance != null) {
            BrowserUtil.instance.updateWidgets();
        }
    }

    public static void copyTab(int index) {
        TabManager.openNewTab(tabs.get(index).getUrl(), index + 1, index);
    }

    public static TabHolder getCurrentTabHolder() {
        return tabs.get(activeTab);
    }

    public static BrowserImpl getCurrentTab() {
        if (!tabs.get(activeTab).isInit()) {
            tabs.get(activeTab).init();
        }
        return tabs.get(activeTab).getBrowser();
    }

    public static void saveTabsToJson() {
        ArrayList<String> urls = new ArrayList<String>();
        for (TabHolder tab : tabs) {
            urls.add(tab.getUrl());
        }
        try (FileWriter fileWriter = new FileWriter(String.valueOf(FabricLoader.getInstance().getConfigDir().resolve("MCBrowser")) + "\\tabs.json");){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(urls, (Appendable)fileWriter);
        }
        catch (IOException e) {
            MCBrowser.LOGGER.error("Could not save opened tabs for MCBrowser", (Throwable)e);
            return;
        }
        MCBrowser.LOGGER.info("Successfully saved tabs for MCBrowser");
    }

    public static void setTitleForTab(int identifier, String title) {
        for (TabHolder tab : tabs) {
            if (tab.getBrowser() == null || identifier != tab.getBrowser().getIdentifier()) continue;
            tab.setTitle(title);
        }
    }

    public static void loadTabsFromJson() {
        String filename = String.valueOf(FabricLoader.getInstance().getConfigDir().resolve("MCBrowser")) + "\\tabs.json";
        if (new File(filename).exists()) {
            try (FileReader fileReader = new FileReader(filename);){
                Type type = new TypeToken<ArrayList<String>>(){}.getType();
                Gson gson = new Gson();
                ArrayList urls = (ArrayList)gson.fromJson((Reader)fileReader, type);
                fileReader.close();
                for (String url : urls) {
                    if (url.isEmpty()) continue;
                    TabHolder tab = new TabHolder(url);
                    tabs.add(tab);
                }
            }
            catch (IOException e) {
                MCBrowser.LOGGER.error("Could not read list of tabs from \"{}\"", (Object)filename, (Object)e);
            }
        }
    }

    public static void reset() {
        for (TabHolder tab : tabs) {
            tab.close();
        }
        tabs.clear();
        activeTab = 0;
    }

    public static String getCurrentUrl() {
        return TabManager.getCurrentTab().getURL();
    }

    public static void tabControl(int keyCodeModifiers) {
        if (keyCodeModifiers == 86) {
            TabManager.openNewTab();
        } else if (keyCodeModifiers == 87 && !closedTabs.isEmpty()) {
            int lastTab = closedTabs.size() - 1;
            TabManager.openNewTab(closedTabs.get(lastTab));
            closedTabs.remove(lastTab);
        } else if (keyCodeModifiers == 260) {
            if (activeTab == tabs.size() - 1) {
                TabManager.setActiveTab(0);
            } else {
                TabManager.setActiveTab(activeTab + 1);
            }
        } else if (keyCodeModifiers == 261) {
            if (activeTab == 0) {
                TabManager.setActiveTab(tabs.size() - 1);
            } else {
                TabManager.setActiveTab(activeTab - 1);
            }
        }
    }
}

