/*
 * Decompiled with CFR 0.152.
 */
package io.github.blobanium.mcbrowser.util.button;

import io.github.blobanium.mcbrowser.MCBrowser;
import io.github.blobanium.mcbrowser.util.BrowserUtil;
import io.github.blobanium.mcbrowser.util.TabManager;
import io.github.blobanium.mcbrowser.util.button.BrowserTabIcon;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.class_10799;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4264;
import net.minecraft.class_6382;
import net.minecraft.class_8666;

public class TabButton
extends class_4264 {
    private static final class_8666 TEXTURES = new class_8666(class_2960.method_60656((String)"widget/button"), class_2960.method_60656((String)"widget/button_disabled"), class_2960.method_60656((String)"widget/button_highlighted"));
    int tab;
    final int startX;
    private final boolean selected;
    private final boolean tooSmall;

    public TabButton(int startX, int y, int width, int height, int tab) {
        super(0, y, width, height, null);
        this.selected = TabManager.activeTab == this.tab;
        this.tooSmall = this.method_25368() < this.method_25364() * 3;
        this.startX = startX;
        this.tab = tab;
    }

    public int method_46426() {
        return this.startX + this.tab * (this.method_25368() + 5);
    }

    public void setTab(int tab) {
        this.tab = tab;
    }

    public void method_25306(class_11907 input) {
    }

    protected void method_47399(class_6382 builder) {
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        String name;
        class_2960 texture = TEXTURES.method_52729(this.method_37303(), this.method_25370());
        if (this.method_46426() > BrowserUtil.instance.field_22789 - 50 - 35) {
            return;
        }
        if (this.method_25368() > this.method_25364()) {
            context.method_52706(class_10799.field_56883, texture, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        }
        if ((name = TabManager.tabs.get(this.tab).getTitle()) == null || name.isEmpty()) {
            name = "Loading...";
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        TabButton.method_52718((class_332)context, (class_327)textRenderer, (class_2561)class_2561.method_30163((String)name), (int)(this.method_46426() + 2 + 15), (int)this.method_46427(), (int)(this.method_46426() + this.method_25368() - (!this.tooSmall || this.selected ? 17 : 2)), (int)(this.method_46427() + this.method_25364()), (int)(0xFFFFFF | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24));
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25364(), this.method_46427() + this.method_25364(), 0xFFFFFF);
        this.renderIco(context);
        if (!this.tooSmall || this.selected) {
            context.method_52706(class_10799.field_56883, texture, this.method_46426() + (this.method_25368() - 15), this.method_46427(), 15, this.method_25364());
            String cross = "\u274c";
            context.method_51433(textRenderer, cross, this.method_46426() + this.method_25368() - 8 - textRenderer.method_1727(cross) / 2, this.method_46427() + 4, -1, true);
        }
        if (this.selected) {
            context.method_25294(this.method_46426(), this.method_46427() + this.method_25364(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364() + 2, -1);
        }
    }

    public void renderIco(class_332 context) {
        BrowserTabIcon ico = TabManager.tabs.get(this.tab).getIcon();
        if (ico == null) {
            this.initIco();
            return;
        }
        if (!TabManager.tabs.get(this.tab).isInit()) {
            ico.render(context, this.method_46426() + 1, this.method_46427() + 1, this.method_25364() - 2, this.method_25364() - 2);
            return;
        }
        String browserUrl = TabManager.tabs.get(this.tab).getBrowser().getURL();
        String icoUrl = ico.getURL();
        if (!icoUrl.isEmpty() && !browserUrl.isEmpty()) {
            if (icoUrl.endsWith(browserUrl) || this.isIcoForUrl(icoUrl, browserUrl)) {
                ico.render(context, this.method_46426() + 1, this.method_46427() + 1, this.method_25364() - 2, this.method_25364() - 2);
            } else {
                this.resetIco();
            }
        }
    }

    private boolean isIcoForUrl(String icoUrl, String url) {
        String siteUrl;
        int end = icoUrl.length();
        int begin = 0;
        if (icoUrl.contains("&size=")) {
            end = icoUrl.lastIndexOf("&size=");
        }
        if (icoUrl.contains("&url=")) {
            begin = icoUrl.lastIndexOf("&url=") + 5;
        }
        if ((icoUrl = icoUrl.substring(begin, end)).contains("://")) {
            icoUrl = icoUrl.substring(icoUrl.indexOf("://") + 3);
        }
        if ((siteUrl = url).contains("://")) {
            siteUrl = siteUrl.substring(siteUrl.indexOf("://") + 3);
        }
        if (siteUrl.contains("/")) {
            siteUrl = siteUrl.substring(0, siteUrl.indexOf(47));
        }
        return icoUrl.startsWith(siteUrl);
    }

    private void initIco() {
        String currentUrl = TabManager.tabs.get(this.tab).getUrl();
        if (currentUrl.isEmpty()) {
            return;
        }
        TabManager.tabs.get(this.tab).initIcon(currentUrl);
        CompletableFuture.runAsync(() -> {
            try {
                BufferedImage bufferedImage = ImageIO.read(new URI("https://www.google.com/s2/favicons?sz=64&domain_url=" + currentUrl).toURL());
                TabManager.tabs.get(this.tab).getIcon().setSize(bufferedImage.getWidth());
            }
            catch (IOException | URISyntaxException e) {
                MCBrowser.LOGGER.warn("Could not find size of ico for {}", (Object)currentUrl, (Object)e);
            }
        });
    }

    public void resetIco() {
        TabManager.tabs.get(this.tab).resetIcon();
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.method_46426() > BrowserUtil.instance.field_22789 - 50 - 35 || !this.method_25367()) {
            return false;
        }
        if (click.method_74245() == 2) {
            this.close();
            return true;
        }
        if (this.tooSmall && !this.selected) {
            this.open();
            return true;
        }
        if (click.comp_4798() <= (double)(this.method_46426() + this.method_25368() - 15)) {
            this.open();
        } else {
            this.close();
        }
        return true;
    }

    public void open() {
        TabManager.setActiveTab(this.tab);
    }

    public void close() {
        TabManager.closeTab(this.tab);
    }

    public boolean method_49606() {
        this.method_25365(super.method_49606());
        return super.method_49606();
    }
}

