package cc.cassian.raspberry;

import cc.cassian.raspberry.compat.QuarkCompat;
import cc.cassian.raspberry.registry.RaspberrySoundEvents;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import org.apache.commons.lang3.text.WordUtils;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.state.CookingPotSupport;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Consumer;

import static cc.cassian.raspberry.RaspberryMod.MOD_ID;
import static cc.cassian.raspberry.registry.RaspberryTags.*;

public class ModHelpers {

    // Automatically generate translation keys for config options.
    public static Component fieldName(Field field) {
        var key = "config."+MOD_ID+".config." + field.getName();
        if (I18n.m_118936_(key)) {
            return Component.m_237115_(key);
        } else {
            return Component.m_237113_(WordUtils.capitalizeFully(field.getName()));
        }
    }

    // Get the current value of a config field.
    @SuppressWarnings("unchecked")
    public static <T> T fieldGet(Object instance, Field field) {
        try {
            return (T) field.get(instance);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    // Set a config field.
    public static <T> Consumer<T> fieldSetter(Object instance, Field field) {
        return t -> {
            try {
                field.set(instance, t);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    /**
     * Used to check what colour the text should be.
     * Adapted from Item Descriptions.
     */
    public static char getColour(String colour) {
        int length = colour.length();
        if (length == 1) {
            return colour.charAt(0);
        }
        else {
            String replacedColour = colour.toLowerCase().replace(" ", "_");
            return switch (replacedColour) {
                case "black", "dark_blue", "dark_green", "dark_red", "dark_purple",
                     "blue", "green", "aqua", "red", "yellow", "white" ->
                        Objects.requireNonNullElse(ChatFormatting.m_126657_(colour), ChatFormatting.GRAY).m_178510_();
                case "pink", "light_purple" ->
                        Objects.requireNonNullElse(ChatFormatting.m_126657_("light_purple"), ChatFormatting.GRAY).m_178510_();
                case "dark_gray", "dark_grey" ->
                        Objects.requireNonNullElse(ChatFormatting.m_126657_("dark_gray"), ChatFormatting.GRAY).m_178510_();
                case "cyan", "dark_aqua" ->
                        Objects.requireNonNullElse(ChatFormatting.m_126657_("dark_aqua"), ChatFormatting.GRAY).m_178510_();
                case "orange", "gold", "dark_yellow" ->
                        Objects.requireNonNullElse(ChatFormatting.m_126657_("gold"), ChatFormatting.GRAY).m_178510_();
                default -> ChatFormatting.GRAY.m_178510_();
            };

        }
    }

    public static SoundEvent getSoundForItem(ItemStack stack, SoundEvent original) {
        if (stack.m_204117_(CRUNCHY_FRUIT_SOUNDS)) {
            return RaspberrySoundEvents.CRUNCHY_FRUIT_SOUNDS.get();
        } else if (stack.m_204117_(DRIED_KELP_SOUNDS)) {
            return RaspberrySoundEvents.DRIED_KELP_SOUNDS.get();
        } else if (stack.m_204117_(SOFT_FRUIT_SOUNDS)) {
            return RaspberrySoundEvents.SOFT_FRUIT_SOUNDS.get();
        } else if (stack.m_204117_(STEW_SOUNDS)) {
            return RaspberrySoundEvents.STEW_SOUNDS.get();
        } else if (stack.m_204117_(VEGETABLE_SOUNDS)) {
            return RaspberrySoundEvents.VEGETABLE_SOUNDS.get();
        } else if (stack.m_204117_(GENERIC_SOUNDS)) {
            return SoundEvents.f_11912_;
        } else if (stack.m_204117_(DRINK_SOUNDS)) {
            return SoundEvents.f_11911_;
        } else if (stack.m_204117_(HONEY_SOUNDS)) {
            return SoundEvents.f_11970_;
        }
        return original;
    }

    public static boolean shouldWoodPostChainConnect(BlockState downState) {
        if(downState.m_60734_() instanceof CookingPotBlock && downState.m_61143_(CookingPotBlock.SUPPORT).equals(CookingPotSupport.HANDLE)) {
            return true;
        }
        else if (downState.m_60734_() instanceof CandleHolderBlock && downState.m_61143_(BlockStateProperties.f_61376_).equals(AttachFace.CEILING)) {
            return true;
        }
        else return (ModCompat.QUARK && QuarkCompat.isPaperLantern(downState));
    }
}