package cc.cassian.raspberry.blocks;

import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Direction.Axis;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.*;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BrickCounterBlock extends Block implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING;
    public static final EnumProperty<StairsShape> SHAPE;
    public static final BooleanProperty WATERLOGGED;
    protected static final VoxelShape TOP;
    protected static final VoxelShape BASE_NW;
    protected static final VoxelShape BASE_NE;
    protected static final VoxelShape BASE_SW;
    protected static final VoxelShape BASE_SE;
    protected static final VoxelShape[] SHAPES;
    private static final int[] SHAPE_BY_STATE;

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return IntStream.range(0, 16).mapToObj((i) -> makeStairShape(i, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray((i) -> new VoxelShape[i]);
    }

    private static VoxelShape makeStairShape(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = Shapes.m_83110_(slabShape, nwCorner);
        }

        if ((bitfield & 2) != 0) {
            voxelshape = Shapes.m_83110_(voxelshape, neCorner);
        }

        if ((bitfield & 4) != 0) {
            voxelshape = Shapes.m_83110_(voxelshape, swCorner);
        }

        if ((bitfield & 8) != 0) {
            voxelshape = Shapes.m_83110_(voxelshape, seCorner);
        }

        return voxelshape;
    }

    public BrickCounterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_(this.f_49792_.m_61090_().m_61124_(FACING, Direction.NORTH).m_61124_(SHAPE, StairsShape.STRAIGHT).m_61124_(WATERLOGGED, false));
    }

    @Override
    public boolean m_7923_(BlockState state) {
        return true;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(FACING) == Direction.UP) {
            return Block.m_49796_(0,12,0,16,16,16);
        }
        if (isFullBlock(state)) {
            return Block.m_49796_(0,0,0,16,16,16);
        }
        return SHAPES[SHAPE_BY_STATE[this.getShapeIndex(state)]];
    }

    private int getShapeIndex(BlockState state) {
        return state.m_61143_(SHAPE).ordinal() * 4 + state.m_61143_(FACING).m_122416_();
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(blockpos);
        BlockState blockstate = this.m_49966_().m_61124_(FACING, context.m_7820_()).m_61124_(WATERLOGGED, fluidstate.m_76152_() == Fluids.f_76193_);
        return blockstate.m_61124_(SHAPE, getStairsShape(blockstate, context.m_43725_(), blockpos));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (state.m_61143_(WATERLOGGED)) {
            level.m_186469_(currentPos, Fluids.f_76193_, Fluids.f_76193_.m_6718_(level));
        }

        return direction.m_122434_().m_122479_() ? state.m_61124_(SHAPE, getStairsShape(state, level, currentPos)) : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    private static StairsShape getStairsShape(BlockState state, BlockGetter level, BlockPos pos) {
        Direction direction = state.m_61143_(FACING);
        if (direction.m_122434_() == Axis.Y) {
            return StairsShape.STRAIGHT;
        }

        BlockState blockstate = level.m_8055_(pos.m_121945_(direction));
        if (isCounter(blockstate)) {
            Direction direction1 = blockstate.m_61143_(FACING);
            if (direction1.m_122434_() != Axis.Y && direction1.m_122434_() != state.m_61143_(FACING).m_122434_() && canTakeShape(state, level, pos, direction1.m_122424_())) {
                if (direction1 == direction.m_122428_()) {
                    return StairsShape.OUTER_LEFT;
                }

                return StairsShape.OUTER_RIGHT;
            }
        }

        BlockState blockstate1 = level.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (isCounter(blockstate1)) {
            Direction direction2 = blockstate1.m_61143_(FACING);
            if (direction2.m_122434_() != Axis.Y && direction2.m_122434_() != state.m_61143_(FACING).m_122434_() && canTakeShape(state, level, pos, direction2)) {
                if (direction2 == direction.m_122428_()) {
                    return StairsShape.INNER_LEFT;
                }

                return StairsShape.INNER_RIGHT;
            }
        }

        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        BlockState blockstate = level.m_8055_(pos.m_121945_(face));
        return !isCounter(blockstate) || blockstate.m_61143_(FACING) != state.m_61143_(FACING);
    }

    public static boolean isCounter(BlockState state) {
        return state.m_60734_() instanceof BrickCounterBlock;
    }

    public static boolean isFullBlock(BlockState state) {
        return state.m_61143_(FACING) == Direction.DOWN;
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return state.m_61124_(FACING, rotation.m_55954_(state.m_61143_(FACING)));
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction direction = state.m_61143_(FACING);
        StairsShape stairsshape = state.m_61143_(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT:
                if (direction.m_122434_() == Axis.Z) {
                    switch (stairsshape) {
                        case INNER_LEFT -> {
                            return state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, StairsShape.INNER_RIGHT);
                        }
                        case INNER_RIGHT -> {
                            return state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, StairsShape.INNER_LEFT);
                        }
                        case OUTER_LEFT -> {
                            return state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, StairsShape.OUTER_RIGHT);
                        }
                        case OUTER_RIGHT -> {
                            return state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, StairsShape.OUTER_LEFT);
                        }
                        default -> {
                            return state.m_60717_(Rotation.CLOCKWISE_180);
                        }
                    }
                }
                break;
            case FRONT_BACK:
                if (direction.m_122434_() == Axis.X) {
                    switch (stairsshape) {
                        case INNER_LEFT -> {
                            return state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, StairsShape.INNER_LEFT);
                        }
                        case INNER_RIGHT -> {
                            return state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, StairsShape.INNER_RIGHT);
                        }
                        case OUTER_LEFT -> {
                            return state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, StairsShape.OUTER_RIGHT);
                        }
                        case OUTER_RIGHT -> {
                            return state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, StairsShape.OUTER_LEFT);
                        }
                        case STRAIGHT -> {
                            return state.m_60717_(Rotation.CLOCKWISE_180);
                        }
                    }
                }
        }

        return super.m_6943_(state, mirror);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(FACING, SHAPE, WATERLOGGED);
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        return state.m_61143_(WATERLOGGED) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return !(Boolean)state.m_61143_(BlockStateProperties.f_61362_) && fluid == Fluids.f_76193_ && !isFullBlock(state);
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    static {
        FACING = DirectionalBlock.f_52588_;
        SHAPE = BlockStateProperties.f_61398_;
        WATERLOGGED = BlockStateProperties.f_61362_;
        TOP = Block.m_49796_(0.0F, 12.0F, 0.0F, 16.0F, 16.0F, 16.0F);
        BASE_NW = Block.m_49796_(0.0F, 0.0F, 0.0F, 8.0F, 12.0F, 8.0F);
        BASE_NE = Block.m_49796_(8.0F, 0.0F, 0.0F, 16.0F, 12.0F, 8.0F);
        BASE_SW = Block.m_49796_(0.0F, 0.0F, 8.0F, 8.0F, 12.0F, 16.0F);
        BASE_SE = Block.m_49796_(8.0F, 0.0F, 8.0F, 16.0F, 12.0F, 16.0F);
        SHAPES = makeShapes(TOP, BASE_NW, BASE_NE, BASE_SW, BASE_SE);
        SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    }
}
