/*
# Supplementaries Team License
Version 1.5, September 2025

Copyright (c) 2025 Supplementaries Team.  All Rights Reserved.

This License Agreement is made between the author(s) of the Software and any person or entity who obtains a copy of this Software and/or its associated files.

By using the Software, the Licensee agrees to be bound by the terms and conditions of this Agreement.

## 0. Summary
This license allows nearly all uses for personal purposes, including modification and private sharing from official sources.
The license protects authors' rights while maintaining some open-source qualities, such as accepting contributions and allowing code integration in non-competing projects.
Public use is permitted with proper credit to the authors.
Public redistribution and commercial use are prohibited.

## 1. Definitions

Definitions
For the purposes of this Agreement, the following definitions apply:

- **Our Sources** refers to copies of the Software or its associated files obtained directly from the owners. This includes files available on the owners' official CurseForge or Modrinth project pages.

- **Compete** refers to any project or software that provides similar functionality, features, or services to the Software and is aimed at the same or a similar user base, such that it could serve as a substitute for the Software, in part or whole. Thus, a project or software is considered Competing if it replicates, replaces, or provides alternatives to one or more key functionalities of the Software in a way that reduces or eliminates the need for the Software


- **Assets** refers to any non-code components of the Software, including but not limited to textures, models, sounds, icons, and other visual or auditory elements.

## 2. Grant of License

Permissions are hereby granted below to any person having a copy of
this software and/or its associated files:

### 2.1. Usage
The Software may be used for both private and public purposes.
It may be integrated with your code as either a soft (e.g., dynamic linking or API access) or hard (e.g., static linking or direct calls) dependency, provided that the Software is obtained exclusively from "Our Sources".

### 2.2. Copying
The Software may be copied for private use or to contribute to its development.
The Licensee may incorporate part of this Software code into their own projects provided that:
- Appropriate credit is given to the original authors of the Software.
- The Licensee's project does not "Compete" with the Software.
- "Assets" are exempt from this clause and require explicit permission unless they are part of a project that is a dependency of the Software.

### 2.3. Modification
The Software may be modified for private use or to contribute to its development.

### 2.3. Publishing
Public distribution or publication of the Software, in whole or in part, is strictly prohibited without the express written permission of the authors.

### 2.4. Sharing
The Licensee is permitted to share the Software privately with a limited number of individuals, such as friends or family members, provided that:

- The sharing is done without any form of commercial gain or compensation.
- The Software, in whole or in part, is not made publicly available or accessible to the general public.
- The recipients of the Software agree to abide by the terms and conditions of this Agreement.

### 2.5. Sub-Licensing
The Licensee shall not, under any circumstances, sub-license, lease, rent, or otherwise transfer rights to the Software, in whole or in part, to any third party.

### 2.6. Selling
The sale of the Software, including its associated files, is strictly prohibited.

## 3. Attribution
Any public media produced by the Licensee (such as web pages or videos) that primarily focuses on the content of this Software must include explicit credits to the authors of the Software.
Credits must include a link back to the source of the Software.
The Licensee may not claim ownership of the Software or its associated files.

## 4. Contributions
By submitting contributions (including but not limited to code, documentation, bug fixes, or feature enhancements) to the Software, the contributor ("Contributor") agrees to the following terms:

- **License Grant**: The Contributor hereby grants the Owner a perpetual, irrevocable, worldwide, non-exclusive, royalty-free license to use, reproduce, modify, adapt, publish, translate, create derivative works from, distribute, perform, and display such contributions, in whole or in part, in any form, medium, or technology now known or later developed. The Owner is also granted the right to sublicense these contributions as part of the Software.
- **Warranty of Rights**: The Contributor represents and warrants that they have the right to make the contributions and that such contributions do not infringe on any third-party rights.

## 5. Modpack Clarification
Permission is granted for the Software to be used in "Modpacks", provided that:

- The Software used is an unmodified copy obtained from "Our Sources."
- The Software is not directly bundled in the "Modpack", as this would violate the redistribution clause.
- Explicit credits within the "Modpack" are not required.

## 6. Modification Clause
In the event that all authors of the Software were to become unreachable for a period exceeding one year, this license shall automatically convert to a Public Domain status.

## 7. Disclaimer of Warranty

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

## 8. Inclusion of Notices
The above copyright notice and these permission notices must be included in all copies or substantial portions of the Software.
 */

package cc.cassian.raspberry.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.jetbrains.annotations.Nullable;

public class DirectionalSlabBlock extends SlabBlock {

    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;

    public DirectionalSlabBlock(Properties properties) {
        super(properties);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(AXIS);
    }

    @Override
    public @Nullable BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        BlockState blockState = context.m_43725_().m_8055_(blockPos);
        BlockState newState = super.m_5573_(context);
        if (blockState.m_60734_() == this) {
            if (blockState.m_61143_(f_56353_) == SlabType.BOTTOM) {
                return newState.m_61124_(AXIS, blockState.m_61143_(AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X);
            }
            return newState;
        }
        return newState.m_61124_(AXIS, context.m_8125_().m_122434_());
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return state.m_61124_(AXIS, state.m_61143_(AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X);
    }

}
