package cc.cassian.raspberry.blocks;

import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.*;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

import java.util.function.BiFunction;

public class FlowerBedBlock extends BushBlock implements BonemealableBlock {
    public static final int MIN_FLOWERS = 1;
    public static final int MAX_FLOWERS = 4;
    public static final DirectionProperty FACING;
    public static final IntegerProperty AMOUNT;
    private static final BiFunction<Direction, Integer, VoxelShape> SHAPE_BY_PROPERTIES;


    public FlowerBedBlock(Properties properties) {
        super(properties);
        this.m_49959_(this.f_49792_.m_61090_().m_61124_(FACING, Direction.NORTH).m_61124_(AMOUNT, 1));
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return blockState.m_61124_(FACING, rotation.m_55954_(blockState.m_61143_(FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_(blockState.m_61143_(FACING)));
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        return !blockPlaceContext.m_7078_() && blockPlaceContext.m_43722_().m_150930_(this.m_5456_()) && blockState.m_61143_(AMOUNT) < 4 || super.m_6864_(blockState, blockPlaceContext);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE_BY_PROPERTIES.apply(blockState.m_61143_(FACING), blockState.m_61143_(AMOUNT));
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockState blockState = blockPlaceContext.m_43725_().m_8055_(blockPlaceContext.m_8083_());
        return blockState.m_60713_(this) ? blockState.m_61124_(AMOUNT, Math.min(4, blockState.m_61143_(AMOUNT) + 1)) : this.m_49966_().m_61124_(FACING, blockPlaceContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(FACING, AMOUNT);
    }

    @Override
    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void m_214148_(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        int i = blockState.m_61143_(AMOUNT);
        if (i < 4) {
            serverLevel.m_7731_(blockPos, blockState.m_61124_(AMOUNT, i + 1), 2);
        } else {
            m_49840_(serverLevel, blockPos, new ItemStack(this));
        }

    }

    public static VoxelShape singleEncompassing(VoxelShape voxelShape) {
        return voxelShape.m_83281_() ? Shapes.m_83040_() : Shapes.m_83048_(voxelShape.m_83288_(Direction.Axis.X), voxelShape.m_83288_(Direction.Axis.Y), voxelShape.m_83288_(Direction.Axis.Z), voxelShape.m_83297_(Direction.Axis.X), voxelShape.m_83297_(Direction.Axis.Y), voxelShape.m_83297_(Direction.Axis.Z));
    }

    static {
        FACING = BlockStateProperties.f_61374_;
        AMOUNT = IntegerProperty.m_61631_("flower_amount", MIN_FLOWERS, MAX_FLOWERS);
        SHAPE_BY_PROPERTIES = Util.m_143821_((direction, integer) -> {
            VoxelShape[] voxelShapes = new VoxelShape[]{Block.m_49796_(8.0F, 0.0F, 8.0F, 16.0F, 3.0F, 16.0F), Block.m_49796_(8.0F, 0.0F, 0.0F, 16.0F, 3.0F, 8.0F), Block.m_49796_(0.0F, 0.0F, 0.0F, 8.0F, 3.0F, 8.0F), Block.m_49796_(0.0F, 0.0F, 8.0F, 8.0F, 3.0F, 16.0F)};
            VoxelShape voxelShape = Shapes.m_83040_();

            for(int i = 0; i < integer; ++i) {
                int j = Math.floorMod(i - direction.m_122416_(), 4);
                voxelShape = Shapes.m_83110_(voxelShape, voxelShapes[j]);
            }

            return singleEncompassing(voxelShape);
        });
    }
}
