package cc.cassian.raspberry.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;

public class GravitationalSnowLayerBlock extends SnowLayerBlock implements Fallable {
    public GravitationalSnowLayerBlock(Properties properties) {
        super(properties);
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @Override
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.m_186460_(pos, this, this.getDelayAfterPlace());
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        level.m_186460_(currentPos, this, this.getDelayAfterPlace());
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (isFree(level.m_8055_(pos.m_7495_())) && pos.m_123342_() >= level.m_141937_()) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_(level, pos, state);
            this.falling(fallingBlockEntity);
        }
    }

    protected void falling(FallingBlockEntity entity) {
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public static boolean isFree(BlockState state) {
        if (state.m_60734_() instanceof AshBlock || state.m_60734_() instanceof GravitationalSnowLayerBlock) return false;
        return state.m_60795_() || state.m_204336_(BlockTags.f_13076_) || state.m_278721_() || state.m_247087_();
    }

    @Override
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(16) == 0) {
            BlockPos blockPos = pos.m_7495_();
            if (isFree(level.m_8055_(blockPos))) {
                double d = (double)pos.m_123341_() + random.m_188500_();
                double e = (double)pos.m_123342_() - 0.05;
                double f = (double)pos.m_123343_() + random.m_188500_();
                level.m_7106_(new BlockParticleOption(ParticleTypes.f_123814_, state), d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }

    public int getDustColor(BlockState state, BlockGetter level, BlockPos pos) {
        return -16777216;
    }
}
