package cc.cassian.raspberry.blocks;

import cc.cassian.raspberry.registry.RaspberryBlocks;
import com.baisylia.cookscollection.item.ModItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalMobEffects;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PancakeBlock;
import net.mehvahdjukaar.supplementaries.common.items.PancakeItem;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.BlockHitResult;

public class LemonPancakeBlock extends PancakeBlock {
    public LemonPancakeBlock(Properties copy) {
        super(copy);
        this.m_49959_(this.f_49792_.m_61090_().m_61124_(PANCAKES, 1).m_61124_(LEMON_TOPPING, false).m_61124_(TOPPING, ModBlockProperties.Topping.NONE).m_61124_(WATERLOGGED, false));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(PANCAKES, TOPPING, LEMON_TOPPING, WATERLOGGED);
    }

    public static final BooleanProperty LEMON_TOPPING = BooleanProperty.m_61465_("lemon_topping");


    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(handIn);
        ModBlockProperties.Topping t = ModBlockProperties.Topping.fromItem(stack.m_41720_()).getFirst();
        if (t != ModBlockProperties.Topping.NONE) {
            return InteractionResult.PASS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public static InteractionResult place(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(handIn);
        if (!state.m_61145_(LEMON_TOPPING).orElse(false) && state.m_61143_(TOPPING) == ModBlockProperties.Topping.NONE) {
            if (stack.m_150930_(ModItems.LEMON.get())) {
                if (!worldIn.f_46443_) {
                    worldIn.m_7731_(pos, RaspberryBlocks.LEMON_PANCAKE.get().m_152465_(state).m_61124_(LEMON_TOPPING, true), 3);
                    worldIn.m_5594_(null, pos, SoundEvents.f_11967_, SoundSource.BLOCKS, 1.0F, 1.2F);
                }
                if (!player.m_7500_()) {
                    Utils.swapItem(player, handIn, ItemStack.f_41583_);
                }

                return InteractionResult.m_19078_(worldIn.f_46443_);
            }
        } else {
            if (state.m_60713_(RaspberryBlocks.LEMON_PANCAKE.get())) {
                if (stack.m_41720_() instanceof PancakeItem && state.m_61145_(PANCAKES).orElse(0)<8) {
                    worldIn.m_7731_(pos, state.m_61124_(PANCAKES, state.m_61143_(PANCAKES)+1), 3);
                    stack.m_41764_(stack.m_41613_()-1);
                    SoundType soundtype = state.getSoundType(worldIn, pos, player);
                    worldIn.m_5594_(
                            player,
                            pos,
                            SoundEvents.f_12642_,
                            SoundSource.BLOCKS,
                            (soundtype.m_56773_() + 1.0F) / 2.0F,
                            soundtype.m_56774_() * 0.8F
                    );
                    return InteractionResult.SUCCESS;
                }
            }
        }

        return InteractionResult.PASS;
    }

    public static void removeLayer(BlockState state, BlockPos pos, Level world, Player player) {
        int i = state.m_61143_(PANCAKES);
        if (i == 8) {
            BlockPos up = pos.m_7494_();
            BlockState upState = world.m_8055_(up);
            if (upState.m_60734_() == state.m_60734_()) {
                removeLayer(upState, up, world, player);
                return;
            }
        }

        if (i > 1) {
            world.m_7731_(pos, state.m_61124_(PANCAKES, i - 1), 3);
        } else {
            world.m_7471_(pos, false);
        }

        if (state.m_61143_(LEMON_TOPPING)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 160));
        }

    }
}
