package cc.cassian.raspberry.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockState;

public class TemporaryCobwebBlock extends WebBlock {
    private static final int LIFETIME_TICKS = 100; // 5 seconds

    public TemporaryCobwebBlock(Properties properties) {
        super(properties);
    }

    @Override
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.m_5776_()) {
            level.m_186460_(pos, this, LIFETIME_TICKS);
        }
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    @Override
    public float m_5880_(BlockState state, Player player, net.minecraft.world.level.BlockGetter level, BlockPos pos) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof SwordItem || heldItem.m_41720_() instanceof ShearsItem) {
            return 0.15F;
        }
        return super.m_5880_(state, player, level, pos);
    }
}