package cc.cassian.raspberry.compat.supplementaries;

import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.BombExplosion;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.*;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

import javax.annotation.Nullable;
import java.util.List;

public class RoseGoldBombExplosion extends BombExplosion {
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    private final float radius;

    public RoseGoldBombExplosion(Level world, @Nullable Entity entity, @Nullable ExplosionDamageCalculator context, double x, double y, double z, BombEntity.BombType bombType, Explosion.BlockInteraction interaction) {
        super(world, entity, context, x, y, z, bombType, interaction);
        this.level = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = 4;
    }

    @Override
    public void m_46061_() {
        this.level.m_142346_(this.m_253049_(), GameEvent.f_157812_, BlockPos.m_274561_(this.x, this.y, this.z));
        float diameter = this.radius * 2.0F;
        int k1 = Mth.m_14107_(this.x - (double)diameter - (double)1.0F);
        int l1 = Mth.m_14107_(this.x + (double)diameter + (double)1.0F);
        int i2 = Mth.m_14107_(this.y - (double)diameter - (double)1.0F);
        int i1 = Mth.m_14107_(this.y + (double)diameter + (double)1.0F);
        int j2 = Mth.m_14107_(this.z - (double)diameter - (double)1.0F);
        int j1 = Mth.m_14107_(this.z + (double)diameter + (double)1.0F);
        List<Entity> list = this.level.m_45933_(this.m_253049_(), new AABB(k1, i2, j2, l1, i1, j1));
        ForgeHelper.onExplosionDetonate(this.level, this, list, diameter);
        Vec3 vector3d = new Vec3(this.x, this.y, this.z);

        for(Entity entity : list) {
            if (!entity.m_6128_()) {
                double distSq = entity.m_20238_(vector3d);
                double normalizedDist = Mth.m_14116_((float)distSq) / diameter;
                if (normalizedDist <= (double)1.0F) {
                    double dx = entity.m_20185_() - this.x;
                    double dy = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y;
                    double dz = entity.m_20189_() - this.z;
                    double distFromCenterSqr = Mth.m_14116_((float)(dx * dx + dy * dy + dz * dz));
                    if (distFromCenterSqr != (double)0.0F) {
                        dx /= distFromCenterSqr;
                        dy /= distFromCenterSqr;
                        dz /= distFromCenterSqr;
                        double d14 = m_46064_(vector3d, entity);
                        double d10 = ((double)1.0F - normalizedDist) * d14;
                        entity.m_6469_(this.m_46077_(), (float)((int)((d10 * d10 + d10) / (double)2.0F * (double)7.0F * (double)diameter + (double)1.0F)));
                        double d11 = d10;
                        boolean isPlayer = entity instanceof Player;
                        Player playerEntity;
                        if (isPlayer) {
                            playerEntity = (Player)entity;
                            if (!playerEntity.m_5833_() && (!playerEntity.m_7500_() || !playerEntity.m_150110_().f_35935_)) {
                                this.m_46078_().put(playerEntity, new Vec3(dx * d10, dy * d10, dz * d10));
                            }
                        }

                        if (entity instanceof LivingEntity) {
                            if (entity instanceof Creeper creeper) {
                                creeper.m_32312_();
                            }

                            d11 = ProtectionEnchantment.m_45135_((LivingEntity)entity, d10);
                        }

                        entity.m_20256_(entity.m_20184_().m_82520_(dx * d11, dy * d11, dz * d11));
                    }
                }
            }
        }
    }

    public static class RoseGoldBombExplosionDamageCalculator extends ExplosionDamageCalculator {

        public RoseGoldBombExplosionDamageCalculator() {
        }

        public boolean m_6714_(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, float power) {
            return false;
        }
    }
}