package cc.cassian.raspberry.entity;

import cc.cassian.raspberry.RaspberryMod;
import cc.cassian.raspberry.compat.supplementaries.RoseGoldBombExplosion;
import cc.cassian.raspberry.registry.RaspberryEntityTypes;
import cc.cassian.raspberry.registry.RaspberryItems;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.BombExplosion;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundExplosionPacket;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.*;

public class RoseGoldBombEntity extends ImprovedProjectileEntity {

    private final boolean hasFuse = CommonConfigs.Tools.BOMB_FUSE.get() != 0;
    private boolean active = true;
    private int changeTimer = -1;
    private boolean superCharged = false;

    public RoseGoldBombEntity(EntityType<RoseGoldBombEntity> type, Level world) {
        super(type, world);
        this.maxAge = (hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 200);
    }

    public RoseGoldBombEntity(Level worldIn, LivingEntity throwerIn) {
        super(RaspberryEntityTypes.ROSE_GOLD_BOMB.get(), throwerIn, worldIn);
        this.maxAge = (hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 200);
    }

    public RoseGoldBombEntity(Level worldIn, double x, double y, double z) {
        super(RaspberryEntityTypes.ROSE_GOLD_BOMB.get(), x, y, z, worldIn);
        this.maxAge = (hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 200);
    }

    //data to be saved when the entity gets unloaded
    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Active", this.active);
        compound.m_128405_("Timer", this.changeTimer);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.active = compound.m_128471_("Active");
        this.changeTimer = compound.m_128451_("Timer");
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return PlatHelper.getEntitySpawnPacket(this);
    }

    @Override
    protected Item m_7881_() {
        return RaspberryItems.ROSE_GOLD_BOMB.get();
    }

    @Override
    public ItemStack m_7846_() {
        return RaspberryItems.ROSE_GOLD_BOMB.get().m_7968_();
    }

    private void spawnBreakParticles() {
        for (int i = 0; i < 8; ++i) {
            this.m_9236_().m_7106_(new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack(ModRegistry.BOMB_ITEM.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0D, 0.0D, 0.0D);
        }
    }

    public void m_7822_(byte id) {
        switch (id) {
            case 3:
                this.spawnBreakParticles();
                this.m_146870_();
                break;
            case 10:
                this.spawnBreakParticles();
                this.m_146870_();
                break;
            case 67:
                RandomSource random = this.m_9236_().m_213780_();

                for(int i = 0; i < 10; ++i) {
                    this.m_9236_().m_7106_(ParticleTypes.f_123762_, this.m_20185_() + (double)0.25F - (double)(random.m_188501_() * 0.5F), this.m_20186_() + (double)0.45F - (double)(random.m_188501_() * 0.5F), this.m_20189_() + (double)0.25F - (double)(random.m_188501_() * 0.5F), (double)0.0F, 0.005, (double)0.0F);
                }

                this.active = false;
                break;
            case 68:
                this.m_9236_().m_7106_(ParticleTypes.f_235902_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)0.0F, (double)0.0F, (double)0.0F);
                break;
            default:
                super.m_7822_(id);
        }

    }

    @Override
    public boolean hasReachedEndOfLife() {
        return super.hasReachedEndOfLife() || this.changeTimer == 0;
    }

    @Override
    public void m_8119_() {

        //if((this.tickCount-1)%6==0) {
        //    this.playSound(ModSounds.GUNPOWDER_IGNITE.get(), 1.0f,
        //            1.8f + level.getRandom().nextFloat() * 0.2f);
        //}

        if (this.changeTimer > 0) {
            this.changeTimer--;
            m_9236_().m_7106_(ParticleTypes.f_123762_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_, 0.0D, 0.0D, 0.0D);
        }

        if (this.active && this.m_20069_()) {
            this.turnOff();
        }

        super.m_8119_();
    }

    @Override
    public void spawnTrailParticles(Vec3 currentPos, Vec3 newPos) {
        if (this.active && !this.f_19803_) {

            double x = currentPos.f_82479_;
            double y = currentPos.f_82480_;
            double z = currentPos.f_82481_;
            double dx = newPos.f_82479_ - x;
            double dy = newPos.f_82480_ - y;
            double dz = newPos.f_82481_ - z;
            int s = 4;
            for (int i = 0; i < s; ++i) {
                double j = i / (double) s;
                this.m_9236_().m_7106_(ModParticles.BOMB_SMOKE_PARTICLE.get(), x + dx * j, 0.5 + y + dy * j, z + dz * j, 0, 0.02, 0);
            }
        }
    }


    @Override
    protected void m_5790_(EntityHitResult hit) {
        super.m_5790_(hit);
        hit.m_82443_().m_6469_(hit.m_82443_().m_269291_().m_269390_(this, this.m_19749_()), 1);
        if (hit.m_82443_() instanceof LargeFireball) {
            this.superCharged = true;
            hit.m_82443_().m_142687_(RemovalReason.DISCARDED);
        }
    }

    public void turnOff() {
        if (!m_9236_().m_5776_()) {
            this.m_9236_().m_7605_(this, (byte) 67);
            m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5F, 1.5F);
        }
        this.active = false;
    }

    @Override
    public void m_6123_(Player entityIn) {
        if (!this.m_9236_().f_46443_) {
            if (!this.active && entityIn.m_150109_().m_36054_(this.m_7846_())) {
                entityIn.m_7938_(this, 1);
                this.m_142687_(RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        Vec3 vector3d = hit.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vector3d);
        Vec3 vector3d1 = vector3d.m_82541_().m_82490_(m_7139_());
        this.m_20343_(this.m_20185_() - vector3d1.f_82479_, this.m_20186_() - vector3d1.f_82480_, this.m_20189_() - vector3d1.f_82481_);
    }

    @Override
    protected float m_7139_() {
        return 0.05F;
    }

    @Override
    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_ && !this.hasFuse) {

            //normal explosion
            if (!this.m_213877_()) {
                this.reachedEndOfLife();
            }
        }
    }

    @Override
    protected void m_37283_() {
    }

    public void reachedEndOfLife() {
        Level level = this.m_9236_();
        level.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12198_, SoundSource.NEUTRAL, 1.5F, 1.5F);
        if (!level.f_46443_) {
            if (this.active) {
                this.createExplosion();
                level.m_7605_(this, (byte)10);
            } else {
                level.m_7605_(this, (byte)3);
            }

            this.m_146870_();
        }

    }

    private void createExplosion() {
        boolean breaks = false;

        if (this.superCharged) {
            this.m_9236_().m_255391_(this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6.0F, breaks, Level.ExplosionInteraction.NONE);
        }

        BombExplosion explosion = new RoseGoldBombExplosion(this.m_9236_(), this, new RoseGoldBombExplosion.RoseGoldBombExplosionDamageCalculator(), this.m_20185_(), this.m_20186_() + (double)0.25F, this.m_20189_(), BombEntity.BombType.NORMAL, Explosion.BlockInteraction.KEEP);
        explosion.m_46061_();
        explosion.m_46075_(true);

        for(Player p : this.m_9236_().m_6907_()) {
            if (p.m_20280_(this) < (double)4096.0F && p instanceof ServerPlayer sp) {
                Message message = ClientBoundExplosionPacket.bomb(explosion, p);
                ModNetwork.CHANNEL.sendToClientPlayer(sp, message);
            }
        }

    }
}