package cc.cassian.raspberry.events;

import cc.cassian.raspberry.items.FlowerGarlandItem;
import cc.cassian.raspberry.registry.RaspberryItems;
import cc.cassian.raspberry.registry.RaspberryParticleTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class FlowerGarlandEvent {
    private static final float STEP_LENGTH = 2.0F; // How far does the player need to move before trying to spawn another particle
    private static final float PARTICLE_CHANCE = 0.25F;
    private static final float PARTICLE_CHANCE_SPRINTING = 0.75F;
    private static final float TWO_PARTICLE_CHANCE = 0.5F;
    private static final Map<UUID, Vec3> prevPositions = new HashMap<>();
    private static final Map<Item, SimpleParticleType> PARTICLES = new HashMap<>();

    static {
        PARTICLES.put(RaspberryItems.CHEERY_WILDFLOWER_GARLAND.get(), RaspberryParticleTypes.CHEERY_PETAL.get());
        PARTICLES.put(RaspberryItems.PLAYFUL_WILDFLOWER_GARLAND.get(), RaspberryParticleTypes.PLAYFUL_PETAL.get());
        PARTICLES.put(RaspberryItems.HOPEFUL_WILDFLOWER_GARLAND.get(), RaspberryParticleTypes.HOPEFUL_PETAL.get());
        PARTICLES.put(RaspberryItems.MOODY_WILDFLOWER_GARLAND.get(), RaspberryParticleTypes.MOODY_PETAL.get());
    }

    public static void tick(Minecraft mc) {
        ParticleStatus status = mc.f_91066_.m_231929_().m_231551_();
        var player = mc.f_91074_;
        if (status == ParticleStatus.MINIMAL) return;
        if (player == null) return;

        Item headItem = player.m_6844_(EquipmentSlot.HEAD).m_41720_();
        if (headItem instanceof FlowerGarlandItem && player.m_20096_()) {
            UUID playerId = player.m_20148_();
            Vec3 playerPos = player.m_20182_();

            if (!prevPositions.containsKey(playerId)) {
                prevPositions.put(playerId, playerPos);
                return;
            }

            Vec3 prevPlayerPos = prevPositions.get(playerId);
            double distance = playerPos.m_82554_(prevPlayerPos);

            if (distance > STEP_LENGTH && player.m_217043_().m_188501_() <= (player.m_20142_() ? PARTICLE_CHANCE_SPRINTING : PARTICLE_CHANCE) ) {
                Vec3 movement = player.m_20184_().m_82541_().m_82548_();
                SimpleParticleType particle = PARTICLES.get(headItem);

                if (particle != null) {
                    int particleCount = player.m_217043_().m_188501_() <= TWO_PARTICLE_CHANCE ? 1 : 2;
                    for (int i = 0; i < particleCount; i++) {
                        player.m_9236_().m_7106_(
                            particle,
                            playerPos.m_7096_() + (movement.f_82479_/2),
                            playerPos.m_7098_()+1 + player.m_217043_().m_188501_() * 0.4,
                            playerPos.m_7094_() + (movement.f_82481_/2),
                            0, 0, 0
                        );
                    }
                }
                prevPositions.put(playerId, playerPos);
            }
        }
    }
}
