package cc.cassian.raspberry.mixin.aquaculture;

import cc.cassian.raspberry.registry.RaspberryTags;
import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.block.blockentity.TackleBoxBlockEntity;
import com.teammetallurgy.aquaculture.item.HookItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(TackleBoxBlockEntity.class)
public class TackleBoxBlockEntityMixin {
    @Inject(method = "canBePutInTackleBox", at = @At("HEAD"), cancellable = true, remap = false)
    private static void baitUsedToBeBelievable(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Item item = stack.m_41720_();
        boolean isDyeable = item instanceof DyeableLeatherItem;
        cir.setReturnValue(stack.m_204117_(AquacultureAPI.Tags.TACKLE_BOX) || item instanceof HookItem || stack.m_204117_(RaspberryTags.BAIT) || stack.m_204117_(AquacultureAPI.Tags.FISHING_LINE) && isDyeable || stack.m_204117_(AquacultureAPI.Tags.BOBBER) && isDyeable);
    }
}
